/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.kettle.PdiAction;
import org.pentaho.platform.plugin.kettle.messages.Messages;
import org.pentaho.platform.web.http.api.resources.FileResourceContentGenerator;

public class PdiContentGenerator
extends FileResourceContentGenerator {
    private static final long serialVersionUID = 3654713863075785759L;
    private static final Log logger = LogFactory.getLog(PdiContentGenerator.class);
    private OutputStream out;
    private RepositoryFile repositoryFile;
    private PdiAction pdiComponent;
    private StringBuilder outputStringBuilder;
    final Messages PDI_PLUGIN_MESSAGES = Messages.getInstance();

    public String getMimeType(String streamPropertyName) {
        return "text/html";
    }

    public PdiContentGenerator() {
        this.pdiComponent = new PdiAction();
        this.outputStringBuilder = new StringBuilder();
    }

    public void execute() throws Exception {
        String pdiPath = this.repositoryFile.getPath();
        this.pdiComponent.setDirectory(FilenameUtils.getPathNoEndSeparator((String)pdiPath));
        if (this.repositoryFile.getName().toLowerCase().endsWith(".ktr")) {
            this.pdiComponent.setTransformation(FilenameUtils.getBaseName((String)pdiPath));
        } else if (this.repositoryFile.getName().toLowerCase().endsWith(".kjb")) {
            this.pdiComponent.setJob(FilenameUtils.getBaseName((String)pdiPath));
        }
        IPentahoSession session = PentahoSessionHolder.getSession();
        long start = System.currentTimeMillis();
        try {
            AuditHelper.audit((String)session.getId(), (String)session.getName(), (String)pdiPath, (String)this.getObjectName(), (String)((Object)((Object)this)).getClass().getName(), (String)"instance_start", (String)this.instanceId, (String)"", (float)0.0f, (ILogger)this);
            this.pdiComponent.execute();
            AuditHelper.audit((String)session.getId(), (String)session.getName(), (String)pdiPath, (String)this.getObjectName(), (String)((Object)((Object)this)).getClass().getName(), (String)"instance_end", (String)this.instanceId, (String)"", (float)((float)(System.currentTimeMillis() - start) / 1000.0f), (ILogger)this);
        }
        catch (Exception ex) {
            AuditHelper.audit((String)session.getId(), (String)session.getName(), (String)pdiPath, (String)this.getObjectName(), (String)((Object)((Object)this)).getClass().getName(), (String)"instance_failed", (String)this.instanceId, (String)"", (float)((float)(System.currentTimeMillis() - start) / 1000.0f), (ILogger)this);
            logger.error((Object)ex);
            this.clearOutputBuffer();
            throw ex;
        }
        if (!this.pdiComponent.isExecutionSuccessful()) {
            this.clearOutputBuffer();
            String errorMessage = org.pentaho.platform.engine.services.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0011_TRANSFORMATION_PREPARATION_FAILED");
            AuditHelper.audit((String)session.getId(), (String)session.getName(), (String)pdiPath, (String)this.getObjectName(), (String)((Object)((Object)this)).getClass().getName(), (String)"instance_failed", (String)this.instanceId, (String)errorMessage, (float)((float)(System.currentTimeMillis() - start) / 1000.0f), (ILogger)this);
            this.outputStringBuilder = this.pdiComponent.isTransPrepareExecutionFailed() ? this.writeFailureMessage() : this.writeFinishedWithErrorsMessage();
            this.out.write(this.outputStringBuilder.toString().getBytes());
            return;
        }
        this.outputStringBuilder = this.writeFinishedMessage();
        this.out.write(this.outputStringBuilder.toString().getBytes());
    }

    protected void setPdiAction(PdiAction action) {
        this.pdiComponent = action;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public RepositoryFile getRepositoryFile() {
        return this.repositoryFile;
    }

    public void setRepositoryFile(RepositoryFile repositoryFile) {
        this.repositoryFile = repositoryFile;
    }

    public StringBuilder writeFinishedMessage() {
        return this.formatMessage("content/pdi-platform-plugin/resources/images/success.svg", this.PDI_PLUGIN_MESSAGES.getString("PdiAction.STATUS_SUCCESS_HEADING"), this.PDI_PLUGIN_MESSAGES.getString("PdiAction.STATUS_SUCCESS_DESC"));
    }

    public StringBuilder writeFinishedWithErrorsMessage() {
        return this.formatMessage("content/pdi-platform-plugin/resources/images/alert.svg", this.PDI_PLUGIN_MESSAGES.getString("PdiAction.STATUS_ERRORS_HEADING"), this.PDI_PLUGIN_MESSAGES.getString("PdiAction.STATUS_ERRORS_DESC"));
    }

    public StringBuilder writeFailureMessage() {
        return this.formatMessage("content/pdi-platform-plugin/resources/images/alert.svg", this.PDI_PLUGIN_MESSAGES.getString("PdiAction.STATUS_NOT_RUN_HEADING"), this.PDI_PLUGIN_MESSAGES.getString("PdiAction.STATUS_NOT_RUN_DESC"));
    }

    protected StringBuilder formatMessage(String imgPath, String heading, String descriptions) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("<html>").append("  <base href=\"").append(PentahoSystem.getApplicationContext().getFullyQualifiedServerURL()).append("\">").append("  <head>").append("    <script src='js/themes.js'></script>").append("  </head>").append("  <body style='width: 100%; height: 100%; display: flex; justify-content: center; align-items: center; flex-direction: column'; margin: 0; padding: 0>").append("    <div style='margin: 0 auto; width: 410px; display: flex; padding: 30px;'>").append("      <img src='").append(imgPath).append("' style='float: left; width: 48px; height: 43px; margin-top: 3px;'/>").append("      <div>").append("        <div style='font-size: 25px; font-weight: normal; padding: 0px 0px 8px 13px; letter-spacing: -0.5px; height: 25px; line-height: 25px;'>").append(heading).append("</div>").append("        <div style='padding: 0px 0px 0px 15px;'>").append(descriptions).append("</div>").append("        <div style='padding-top: 30px; padding-left: 15px;'>").append("          <button type='submit' class='pentaho-button' onclick='closeStatusPage()'>Close</button>").append("        </div>").append("      </div>").append("    </div>").append("  </body>").append("  <script>").append("    var active_theme_tree = core_theme_tree[active_theme];").append("    document.write('<link rel=\"stylesheet\" type=\"text/css\" href=\"' + active_theme_tree.rootDir + active_theme_tree.resources[0] + '\"');").append("    var closeStatusPage = function() {").append("      if(window.parent.mantle_initialized) {").append("        window.parent.closeTab('');").append("      } else {").append("        window.close();").append("      }").append("    }").append("  </script>").append("</html>");
        return messageBuilder;
    }

    private void clearOutputBuffer() {
        if (this.outputStringBuilder != null) {
            this.outputStringBuilder.setLength(0);
        }
    }

    protected StringBuilder getOutputStringBuilder() {
        return this.outputStringBuilder;
    }
}

