/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParametersBean {
    private Log log = LogFactory.getLog(ParametersBean.class);
    private static final String PARAMETER_CORE_NAMESPACE = "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core";
    private String[] userParams;
    private Document document;
    private Map<String, String> requestParams = new HashMap<String, String>();

    public ParametersBean(String[] userParams) {
        this.userParams = userParams;
    }

    public ParametersBean(String[] userParams, Map<String, String> requestParams) {
        this.userParams = userParams;
        this.requestParams = requestParams != null ? requestParams : new HashMap();
    }

    public String getParametersXmlString() throws ParserConfigurationException, TransformerException, IOException {
        this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element parameters = this.document.createElement("parameters");
        parameters = this.setRootLevelSystemAttributes(parameters);
        parameters = this.createUserParameters(parameters, this.requestParams);
        parameters = this.createSystemRequiredParameters(parameters);
        this.document.appendChild(parameters);
        StringBuffer buffer = XmlDom4JHelper.docToString((Document)this.document);
        return buffer.toString();
    }

    private Element setRootLevelSystemAttributes(Element rootElement) throws DOMException {
        rootElement.setAttribute("autoSubmit", "true");
        rootElement.setAttribute("autoSubmitUI", "true");
        rootElement.setAttribute("accepted-page", "-1");
        rootElement.setAttribute("is-mandatory", "false");
        rootElement.setAttribute("is-prompt-needed", "false");
        return rootElement;
    }

    private Element createAttribute(String name, String value) {
        Element attribute = this.document.createElement("attribute");
        attribute.setAttribute("name", name);
        attribute.setAttribute("namespace", PARAMETER_CORE_NAMESPACE);
        attribute.setAttribute("value", value);
        return attribute;
    }

    private Element createBaseElement(String elementName, String name, String type, boolean hidden) {
        String defaultType = "java.lang.String";
        Element element = this.document.createElement(elementName);
        element.setAttribute("is-list", "false");
        element.setAttribute("is-mandatory", "false");
        element.setAttribute("is-multi-select", "false");
        element.setAttribute("is-strict", "false");
        element.setAttribute("name", name);
        element.setAttribute("type", StringUtils.isEmpty((String)type) ? defaultType : type);
        if (hidden) {
            element.appendChild(this.createAttribute("hidden", "true"));
        }
        return element;
    }

    private Element createUserParameters(Element parameters, Map<String, String> paramMap) {
        try {
            if (this.userParams != null) {
                for (String param : this.userParams) {
                    Element element = this.createBaseElement("parameter", param, null, false);
                    element.appendChild(this.createAttribute("role", "user"));
                    element.appendChild(this.createAttribute("label", param));
                    if (paramMap.containsKey(param)) {
                        String value = paramMap.get(param);
                        element.appendChild(this.createValue(value, "java.lang.String", value));
                    }
                    parameters.appendChild(element);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
        }
        return parameters;
    }

    private Element createValue(String name, String type, String value) {
        Element valuesElem = this.document.createElement("values");
        Element valueAttr = this.document.createElement("value");
        valueAttr.setAttribute("label", name);
        valueAttr.setAttribute("type", type);
        valueAttr.setAttribute("selected", "true");
        valueAttr.setAttribute("null", "false");
        valueAttr.setAttribute("value", value);
        valuesElem.appendChild(valueAttr);
        return valuesElem;
    }

    private Element createSystemRequiredParameters(Element parameters) {
        try {
            Element e1 = this.createBaseElement("parameter", "accepted-page", "java.lang.Integer", true);
            e1.appendChild(this.createAttribute("role", "system"));
            e1.appendChild(this.createAttribute("hidden", "true"));
            e1.appendChild(this.createAttribute("preferred", "true"));
            e1.appendChild(this.createAttribute("label", "accepted-page"));
            e1.appendChild(this.createAttribute("parameter-group", "system"));
            e1.appendChild(this.createAttribute("parameter-group-label", "System Parameters"));
            parameters.appendChild(e1);
            Element e2 = this.createBaseElement("parameter", "autoSubmit", "java.lang.Boolean", true);
            e2.appendChild(this.createAttribute("role", "system"));
            e2.appendChild(this.createAttribute("preferred", "true"));
            e2.appendChild(this.createAttribute("label", "autoSubmit"));
            e2.appendChild(this.createAttribute("parameter-group", "system"));
            e2.appendChild(this.createAttribute("parameter-group-label", "System Parameters"));
            e2.appendChild(this.createAttribute("parameter-render-type", "textbox"));
            e2.appendChild(this.createAttribute("deprecated", "true"));
            e2.appendChild(this.createValue("true", "java.lang.Boolean", "true"));
            Element e3 = this.createBaseElement("parameter", "autoSubmitUI", "java.lang.Boolean", true);
            e3.appendChild(this.createAttribute("role", "system"));
            e3.appendChild(this.createAttribute("preferred", "true"));
            e3.appendChild(this.createAttribute("label", "autoSubmitUI"));
            e3.appendChild(this.createAttribute("parameter-group", "system"));
            e3.appendChild(this.createAttribute("parameter-group-label", "System Parameters"));
            e3.appendChild(this.createAttribute("parameter-render-type", "textbox"));
            e3.appendChild(this.createAttribute("deprecated", "true"));
            e3.appendChild(this.createValue("true", "java.lang.Boolean", "true"));
            Element e4 = this.createBaseElement("parameter", "showParameters", "java.lang.Boolean", true);
            e4.appendChild(this.createAttribute("role", "system"));
            e4.appendChild(this.createAttribute("preferred", "true"));
            e4.appendChild(this.createAttribute("label", "autoSubmitUI"));
            e4.appendChild(this.createAttribute("parameter-group", "system"));
            e4.appendChild(this.createAttribute("parameter-group-label", "System Parameters"));
            e4.appendChild(this.createAttribute("parameter-render-type", "textbox"));
            e4.appendChild(this.createAttribute("deprecated", "true"));
            e4.appendChild(this.createValue("true", "java.lang.Boolean", "true"));
            parameters.appendChild(e2);
            parameters.appendChild(e3);
            parameters.appendChild(e4);
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
        }
        return parameters;
    }
}

