/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;
import org.pentaho.platform.util.messages.LocaleHelper;

public class ParameterUIContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = -6537706461351621253L;
    String viewerFilePath;
    String pluginId;
    Map<String, String> resourceMap;

    public Log getLogger() {
        return null;
    }

    public void createContent(OutputStream outputStream) throws Exception {
        IPluginResourceLoader resourceLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class);
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        ClassLoader classLoader = pluginManager.getClassLoader(this.pluginId);
        String filePath = !this.viewerFilePath.startsWith("/") ? "/" + this.viewerFilePath : this.viewerFilePath;
        String viewer = IOUtils.toString((InputStream)resourceLoader.getResourceAsStream(classLoader, filePath), (String)LocaleHelper.getSystemEncoding());
        viewer = this.doResourceReplacement(viewer);
        InputStream is = IOUtils.toInputStream((String)viewer, (String)LocaleHelper.getSystemEncoding());
        IOUtils.copy((InputStream)is, (OutputStream)outputStream);
        outputStream.flush();
    }

    public String getMimeType() {
        return "text/html";
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public Map<String, String> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(Map<String, String> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public String getViewerFilePath() {
        return this.viewerFilePath;
    }

    public void setViewerFilePath(String viewerFilePath) {
        this.viewerFilePath = viewerFilePath;
    }

    public String doResourceReplacement(String viewer) {
        if (!StringUtils.isEmpty((String)viewer) && this.resourceMap != null && this.resourceMap.keySet() != null) {
            for (String resource : this.resourceMap.keySet()) {
                if (StringUtils.isEmpty((String)resource) || !viewer.contains(resource)) continue;
                viewer = viewer.replaceAll(resource, this.resourceMap.get(resource));
            }
        }
        return viewer;
    }
}

