/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class ErrorPage
extends HtmlPage {
    @Override
    protected void render(Hamlet.HTML<HtmlPage._> html) {
        this.set("ui.accordion.id", "msg");
        String title = "Sorry, got error " + this.status();
        ((Hamlet.HTML)((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.PRE)((Hamlet.DIV)((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.HTML)((Hamlet.HTML)((Hamlet.HTML)((Hamlet.HTML)html.title(title)).link(this.root_url("static", "yarn.css")))._(JQueryUI.class)).style(new Object[]{"#msg { margin: 1em auto; width: 88%; }", "#msg h1 { padding: 0.2em 1.5em; font: bold 1.3em serif; }"})).div("#msg")).h1(title)).div())._(new Object[]{"Please consult"})).a("http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html", "RFC 2616"))._(new Object[]{" for meanings of the error code."})))._()).h1("Error Details")).pre())._(new Object[]{this.errorDetails()})))._())._())._();
    }

    protected String errorDetails() {
        if (!this.$("error.details").isEmpty()) {
            return this.$("error.details");
        }
        if (this.error() != null) {
            return ErrorPage.toStackTrace(this.error(), 65536);
        }
        return "No exception was thrown.";
    }

    public static String toStackTrace(Throwable error, int cutoff) {
        CharArrayWriter buffer = new CharArrayWriter(8192);
        error.printStackTrace(new PrintWriter(buffer));
        return buffer.size() < cutoff ? buffer.toString() : buffer.toString().substring(0, cutoff);
    }
}

