/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.BeanMatchersException;
import com.google.code.beanmatchers.DistinctValues;
import com.google.code.beanmatchers.TypeBasedValueGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValueGenerators {
    private static final int MAX_ATTEMPTS = 128;

    private ValueGenerators() {
    }

    public static <T> DistinctValues<T> generateTwoDistinctValues(TypeBasedValueGenerator valueGenerator, Class<T> valueType) {
        T valueTwo;
        int attempts = 0;
        T valueOne = valueGenerator.generate(valueType);
        do {
            if (attempts == 128) {
                throw new BeanMatchersException("Could not generate two distinct values after 128 attempts of type " + valueType.getName());
            }
            valueTwo = valueGenerator.generate(valueType);
            ++attempts;
        } while (valueOne.equals(valueTwo));
        return new DistinctValues<T>(valueOne, valueTwo);
    }
}

