/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.AbstractBeanHashCodeMatcher;
import com.google.code.beanmatchers.JavaBean;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasValidBeanHashCodeExcludingMatcher<T>
extends AbstractBeanHashCodeMatcher<T> {
    private final List<String> excludedProperties;

    HasValidBeanHashCodeExcludingMatcher(TypeBasedValueGenerator valueGenerator, String ... excludedProperties) {
        super(valueGenerator);
        this.excludedProperties = Arrays.asList(excludedProperties);
    }

    protected boolean matchesSafely(Class<T> beanType, Description mismatchDescription) {
        JavaBean bean = new JavaBean(beanType);
        List<String> properties = bean.properties();
        properties.removeAll(this.excludedProperties);
        return this.hashCodeIsInfluencedByProperties(bean, properties, mismatchDescription);
    }

    public void describeTo(Description description) {
        if (this.excludedProperties.isEmpty()) {
            description.appendText("bean with all properties influencing hashCode");
        } else {
            description.appendText("bean with all properties excluding ");
            description.appendValue(this.excludedProperties);
            description.appendText(" influencing hashCode");
        }
    }
}

