/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.AccessorMissingException;
import com.google.code.beanmatchers.BeanMatchersException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanOperations {
    private BeanOperations() {
    }

    public static <T> T instantiateBean(Class<T> beanClass) {
        try {
            Constructor<T> constructor = BeanOperations.noArgsConstructor(beanClass);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new BeanMatchersException("Could not instantiate bean with no-args constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new BeanMatchersException("Could not instantiate bean with no-args constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanMatchersException("Could not instantiate bean with no-args constructor", e);
        }
    }

    public static <T> Constructor<T> noArgsConstructor(Class<T> beanClass) {
        try {
            return beanClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new BeanMatchersException("Bean does not have no-args constructor", e);
        }
    }

    public static List<String> properties(Class<?> beanType) {
        return BeanOperations.properties(BeanOperations.propertyDescriptors(beanType));
    }

    public static List<String> properties(PropertyDescriptor[] descriptors) {
        ArrayList<String> properties = new ArrayList<String>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            properties.add(descriptor.getName());
        }
        properties.remove("class");
        return properties;
    }

    public static <T> PropertyDescriptor[] propertyDescriptors(T bean) {
        return BeanOperations.propertyDescriptors(bean.getClass());
    }

    private static PropertyDescriptor[] propertyDescriptors(Class<?> beanType) {
        return BeanOperations.beanInfo(beanType).getPropertyDescriptors();
    }

    private static BeanInfo beanInfo(Class targetClass) {
        try {
            return Introspector.getBeanInfo(targetClass);
        }
        catch (Exception e) {
            throw new BeanMatchersException(e);
        }
    }

    public static Object invokeGetter(Object bean, PropertyDescriptor property) {
        Method method = property.getReadMethod();
        if (method == null) {
            throw new AccessorMissingException("missing getter for the property " + property.getName());
        }
        return BeanOperations.invokeMethod(bean, method, new Object[0]);
    }

    public static void invokeSetter(Object bean, PropertyDescriptor property, Object value) {
        Method method = property.getWriteMethod();
        if (method == null) {
            throw new AccessorMissingException("missing setter for the property " + property.getName());
        }
        BeanOperations.invokeMethod(bean, method, value);
    }

    private static Object invokeMethod(Object bean, Method method, Object ... args) {
        try {
            return method.invoke(bean, args);
        }
        catch (Exception e) {
            throw new BeanMatchersException(e);
        }
    }
}

