/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.text.MessageFormat;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MultivaluedBtree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.ShrinkablePage;

public class BtreeListByKey
extends AbstractSequentialList {
    private MultivaluedBtree btree;
    private byte[] key;
    private Object objectKey;
    private int listModCounter = 0;

    BtreeListByKey(MultivaluedBtree btree, Object key) throws StorageException {
        this.btree = btree;
        this.objectKey = key;
        this.key = btree.keyInfo.toBuffer(key);
        if (this.key == null) {
            throw new StorageBadRequestException(MessageFormat.format("Invalid key type for this index: {0} received, {1} expected", key.getClass().getName(), btree.keyInfo.typeName()));
        }
    }

    public int size() {
        BtreeListByKeyIterator iterator = new BtreeListByKeyIterator(0, null);
        while (iterator.moveForward()) {
        }
        return iterator.previousIndex();
    }

    public boolean isEmpty() {
        return !this.listIterator(0).hasNext();
    }

    public boolean add(Object o) {
        ListIterator<Object> it = this.listIterator();
        while (it.hasNext()) {
            it.next();
        }
        it.add(o);
        return true;
    }

    public boolean addAll(Collection c) {
        boolean result = false;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            it.next();
        }
        Iterator cit = c.iterator();
        while (cit.hasNext()) {
            try {
                it.add(cit.next());
                result = true;
            }
            catch (RuntimeStorageException runtimeStorageException) {
                // empty catch block
            }
        }
        return result;
    }

    public void increaseModCount() {
        ++this.listModCounter;
    }

    public int hashCode() {
        return this.objectKey.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof BtreeListByKey) {
            return ((BtreeListByKey)o).objectKey.equals(this.objectKey);
        }
        if (o instanceof Key) {
            return ((Key)o).objectKey.equals(this.objectKey);
        }
        return false;
    }

    public ListIterator listIterator(int index) {
        return new BtreeListByKeyIterator(index, null);
    }

    ListIterator listIterator(int index, SinglevaluedIndex repos) {
        return new BtreeListByKeyIterator(index, repos);
    }

    public class BtreeListByKeyIterator
    implements ListIterator {
        private SearchResult current;
        private SearchResult first;
        private int index;
        private boolean empty;
        private int modCount;
        private SinglevaluedIndex repos;
        private boolean itemAvailable = false;
        private boolean retrievedByNext = false;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        BtreeListByKeyIterator(int startIndex, SinglevaluedIndex repos) throws IndexOutOfBoundsException {
            try {
                try {
                    this.repos = repos;
                    BtreeListByKey.this.btree.beginRead();
                    this.modCount = BtreeListByKey.this.listModCounter;
                    this.index = -1;
                    this.current = BtreeListByKey.this.btree.getLocation(BtreeListByKey.this.key);
                    this.first = new SearchResult(this.current);
                    --this.current.entryNum;
                    if (!this.current.matched) {
                        this.empty = true;
                    }
                    if (startIndex < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    int i = 0;
                    while (i < startIndex) {
                        if (!this.moveForward()) {
                            throw new IndexOutOfBoundsException();
                        }
                        ++i;
                    }
                }
                catch (StorageException e) {
                    throw new RuntimeStorageException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                BtreeListByKey.this.btree.endRead();
                throw throwable;
            }
            {
                Object var5_8 = null;
            }
            BtreeListByKey.this.btree.endRead();
        }

        public Object next() throws NoSuchElementException {
            if (!this.moveForward()) {
                throw new NoSuchElementException();
            }
            this.itemAvailable = true;
            this.retrievedByNext = true;
            return this.getCurrentItem();
        }

        public Object previous() throws NoSuchElementException {
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
            Object item = this.getCurrentItem();
            this.moveBackward();
            this.itemAvailable = true;
            this.retrievedByNext = false;
            return item;
        }

        public boolean hasNext() {
            boolean bl;
            try {
                BtreeListByKey.this.btree.beginRead();
                this.checkModCount();
                this.locateCurrentItem();
                bl = BtreePage.hasNext(BtreeListByKey.this.key, this.current);
                Object var2_2 = null;
            }
            catch (StorageException e) {
                try {
                    throw new RuntimeStorageException(e);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    BtreeListByKey.this.btree.endRead();
                    throw throwable;
                }
            }
            BtreeListByKey.this.btree.endRead();
            return bl;
        }

        public boolean hasPrevious() {
            return this.index >= 0;
        }

        private boolean moveForward() {
            boolean bl;
            try {
                BtreeListByKey.this.btree.beginRead();
                this.checkModCount();
                this.locateCurrentItem();
                BtreePage.getNext(BtreeListByKey.this.key, this.current);
                ++this.index;
                bl = this.current.matched;
                Object var2_2 = null;
            }
            catch (StorageException e) {
                try {
                    e.printStackTrace();
                    throw new RuntimeStorageException(e);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    BtreeListByKey.this.btree.endRead();
                    throw throwable;
                }
            }
            BtreeListByKey.this.btree.endRead();
            return bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void moveBackward() {
            try {
                try {
                    BtreeListByKey.this.btree.beginRead();
                    this.checkModCount();
                    this.locateCurrentItem();
                    int tempEntryNum = this.current.entryNum;
                    BtreePage.getPrevious(BtreeListByKey.this.key, this.current);
                    if (!this.current.matched && this.current.entryNum == tempEntryNum) {
                        --this.current.entryNum;
                    }
                    --this.index;
                }
                catch (StorageException e) {
                    throw new RuntimeStorageException(e);
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                BtreeListByKey.this.btree.endRead();
                throw throwable;
            }
            {
                Object var2_5 = null;
            }
            BtreeListByKey.this.btree.endRead();
        }

        private Object getCurrentItem() {
            Object object;
            try {
                BtreeListByKey.this.btree.beginRead();
                this.checkModCount();
                this.locateCurrentItem();
                Object result = this.repos != null ? ((BtreeListByKey)BtreeListByKey.this).btree.dataInfo.objectFromBuffer(this.current.page.getData(this.current.entryNum), this.repos) : ((BtreeListByKey)BtreeListByKey.this).btree.dataInfo.fromBuffer(this.current.page.getData(this.current.entryNum));
                object = result;
                Object var3_3 = null;
            }
            catch (StorageException e) {
                try {
                    throw new RuntimeStorageException(e);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    BtreeListByKey.this.btree.endRead();
                    throw throwable;
                }
            }
            BtreeListByKey.this.btree.endRead();
            return object;
        }

        public int nextIndex() {
            return this.index + 1;
        }

        public int previousIndex() {
            return this.index;
        }

        private void checkModCount() {
            if (BtreeListByKey.this.listModCounter != this.modCount) {
                throw new ConcurrentModificationException("Index " + BtreeListByKey.this.btree.getName() + ", key " + BtreeListByKey.this.objectKey + " has been modified since iterator was created.");
            }
        }

        public void remove() {
            if (!this.itemAvailable) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            this.removeItem();
            this.itemAvailable = false;
            if (this.retrievedByNext) {
                --this.index;
            }
            BtreeListByKey btreeListByKey = BtreeListByKey.this;
            btreeListByKey.listModCounter = btreeListByKey.listModCounter + 1;
            this.modCount = BtreeListByKey.this.listModCounter;
        }

        public void set(Object o) {
            if (!this.itemAvailable) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            this.setItem(o);
            BtreeListByKey btreeListByKey = BtreeListByKey.this;
            btreeListByKey.listModCounter = btreeListByKey.listModCounter + 1;
            this.modCount = BtreeListByKey.this.listModCounter;
        }

        public void add(Object o) {
            this.checkModCount();
            this.addItem(o);
            this.itemAvailable = false;
            ++this.index;
            BtreeListByKey btreeListByKey = BtreeListByKey.this;
            btreeListByKey.listModCounter = btreeListByKey.listModCounter + 1;
            this.modCount = BtreeListByKey.this.listModCounter;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setItem(Object o) {
            try {
                try {
                    BtreeListByKey.this.btree.beginWrite();
                    this.locateCurrentItem();
                    BtreePage.BtreeEntry entry = new BtreePage.BtreeEntry(BtreeListByKey.this.key, ((BtreeListByKey)BtreeListByKey.this).btree.dataInfo.toBuffer(o));
                    if (this.current.page instanceof ShrinkablePage) {
                        BtreePage root = ((BtreeListByKey)BtreeListByKey.this).btree.pageSource.getPage(((BtreeListByKey)BtreeListByKey.this).btree.rootPageId, BtreeListByKey.this.btree);
                        root.put(BtreeListByKey.this.key, ((BtreeListByKey)BtreeListByKey.this).btree.dataInfo.toBuffer(o), (byte)1, this.index, this.current);
                        ((BtreeListByKey)BtreeListByKey.this).btree.pageSource.unpinPage(root);
                    } else {
                        this.current.page.replace(entry, this.current.entryNum, null);
                    }
                }
                catch (StorageException e) {
                    throw new RuntimeStorageException(e);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                BtreeListByKey.this.btree.endWrite();
                throw throwable;
            }
            {
                Object var4_7 = null;
            }
            BtreeListByKey.this.btree.endWrite();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void removeItem() {
            try {
                try {
                    BtreeListByKey.this.btree.beginWrite();
                    this.locateCurrentItem();
                    SearchResult temp = new SearchResult(this.current);
                    if (this.retrievedByNext) {
                        BtreePage.getPrevious(BtreeListByKey.this.key, this.current);
                        if (!this.current.matched && this.current.entryNum == temp.entryNum) {
                            --this.current.entryNum;
                        }
                    } else {
                        BtreePage.getNext(BtreeListByKey.this.key, temp);
                    }
                    temp.page.delete(temp.entryNum, temp.entryNum);
                    if (this.retrievedByNext && this.index == 0 || !this.retrievedByNext && this.index == -1) {
                        this.first = new SearchResult(this.current);
                        BtreePage.getNext(BtreeListByKey.this.key, this.first);
                    }
                }
                catch (StorageException e) {
                    throw new RuntimeStorageException(e);
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                BtreeListByKey.this.btree.endWrite();
                throw throwable;
            }
            {
                Object var2_5 = null;
            }
            BtreeListByKey.this.btree.endWrite();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addItem(Object o) {
            try {
                try {
                    BtreeListByKey.this.btree.beginWrite();
                    this.locateCurrentItem();
                    BtreePage root = ((BtreeListByKey)BtreeListByKey.this).btree.pageSource.getPage(((BtreeListByKey)BtreeListByKey.this).btree.rootPageId, BtreeListByKey.this.btree);
                    root.put(BtreeListByKey.this.key, ((BtreeListByKey)BtreeListByKey.this).btree.dataInfo.toBuffer(o), (byte)0, this.index + 1, this.current);
                    ((BtreeListByKey)BtreeListByKey.this).btree.pageSource.unpinPage(root);
                    if (this.index == -1) {
                        this.first = new SearchResult(this.current);
                    }
                }
                catch (StorageException e) {
                    throw new RuntimeStorageException(e);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                BtreeListByKey.this.btree.endWrite();
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            BtreeListByKey.this.btree.endWrite();
        }

        private void locateCurrentItem() throws StorageException {
            SearchResult res = this.first.page.searchPage(BtreeListByKey.this.key, this.first.entryNum);
            if (this.first.entryNum != res.entryNum || this.first.page != res.page) {
                this.first = res;
                this.current = new SearchResult(this.first);
                if (this.index == -1) {
                    --this.current.entryNum;
                } else {
                    this.first.page.findNth(this.current, BtreeListByKey.this.key, this.index, false);
                }
            } else if (this.index > -1 && this.current.page.compare(BtreeListByKey.this.key, this.current.entryNum) != 0) {
                this.current = new SearchResult(this.first);
                this.first.page.findNth(this.current, BtreeListByKey.this.key, this.index, false);
            }
        }
    }

    static class Key {
        private Object objectKey;

        Key(Object key) {
            this.objectKey = key;
        }

        public int hashCode() {
            return this.objectKey.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof BtreeListByKey) {
                return ((BtreeListByKey)o).objectKey.equals(this.objectKey);
            }
            if (o instanceof Key) {
                return ((Key)o).objectKey.equals(this.objectKey);
            }
            return false;
        }
    }
}

