/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.mapred.Reporter;

public class CounterStatsPublisher
implements StatsPublisher,
StatsCollectionTaskIndependent {
    private static final Log LOG = LogFactory.getLog((String)CounterStatsPublisher.class.getName());
    private Reporter reporter;

    @Override
    public boolean init(StatsCollectionContext context) {
        return true;
    }

    @Override
    public boolean connect(StatsCollectionContext statsContext) {
        MapredContext context = MapredContext.get();
        if (context == null || context.getReporter() == null) {
            return false;
        }
        this.reporter = context.getReporter();
        return true;
    }

    @Override
    public boolean publishStat(String fileID, Map<String, String> stats) {
        for (Map.Entry<String, String> entry : stats.entrySet()) {
            try {
                this.reporter.incrCounter(fileID, entry.getKey(), Long.valueOf(entry.getValue()).longValue());
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to increment counter value " + entry.getValue() + " for " + entry.getKey() + ": " + e), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean closeConnection(StatsCollectionContext context) {
        return true;
    }
}

