/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.HiveDriverRunHook;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.hooks.PostExecute;
import org.apache.hadoop.hive.ql.hooks.PreExecute;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContextImpl;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.ShutdownHookManager;

public class Driver
implements CommandProcessor {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private Runnable shutdownRunner = null;
    private static final Object compileMonitor = new Object();
    private int maxRows = 100;
    ByteStream.Output bos = new ByteStream.Output();
    private HiveConf conf;
    private DataInput resStream;
    private Context ctx;
    private DriverContext driverCxt;
    private QueryPlan plan;
    private Schema schema;
    private String errorMessage;
    private String SQLState;
    private Throwable downstreamError;
    private Set<FileSinkDesc> acidSinks;
    private boolean acidInQuery;
    private int maxthreads;
    private int tryCount = Integer.MAX_VALUE;
    private boolean destroyed;
    private String userName;
    private String operationId;

    private boolean checkConcurrency() {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (!supportConcurrency) {
            LOG.info((Object)"Concurrency mode is disabled, not creating a lock manager");
            return false;
        }
        return true;
    }

    @Override
    public void init() {
        Operator.resetId();
    }

    public ClusterStatus getClusterStatus() throws Exception {
        ClusterStatus cs;
        try {
            JobConf job = new JobConf((Configuration)this.conf);
            JobClient jc = new JobClient(job);
            cs = jc.getClusterStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning cluster status: " + cs.toString()));
        return cs;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static Schema getSchema(BaseSemanticAnalyzer sem, HiveConf conf) {
        Schema schema = null;
        if (sem != null) {
            if (sem.getResultSchema() != null) {
                List<FieldSchema> lst = sem.getResultSchema();
                schema = new Schema(lst, null);
            } else if (sem.getFetchTask() != null) {
                FetchTask ft = sem.getFetchTask();
                TableDesc td = ft.getTblDesc();
                if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                    td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
                }
                if (td == null) {
                    LOG.info((Object)"No returning schema.");
                } else {
                    String tableName = "result";
                    List lst = null;
                    try {
                        lst = MetaStoreUtils.getFieldsFromDeserializer((String)tableName, (Deserializer)td.getDeserializer(conf));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error getting schema: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
                    }
                    if (lst != null) {
                        schema = new Schema(lst, null);
                    }
                }
            }
        }
        if (schema == null) {
            schema = new Schema();
        }
        LOG.info((Object)("Returning Hive schema: " + schema));
        return schema;
    }

    public Schema getThriftSchema() throws Exception {
        Schema schema;
        try {
            List lst;
            schema = this.getSchema();
            if (schema != null && (lst = schema.getFieldSchemas()) != null) {
                for (FieldSchema f : lst) {
                    f.setType(MetaStoreUtils.typeToThriftType((String)f.getType()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning Thrift schema: " + schema));
        return schema;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public Driver(HiveConf conf) {
        this.conf = conf;
    }

    public Driver(HiveConf conf, String userName) {
        this(conf);
        this.userName = userName;
    }

    public Driver() {
        if (SessionState.get() != null) {
            this.conf = SessionState.get().getConf();
        }
    }

    public int compile(String command) {
        return this.compile(command, true);
    }

    public void saveSession(QueryState qs) {
        SessionState oldss = SessionState.get();
        if (oldss != null && oldss.getHiveOperation() != null) {
            qs.init(oldss.getHiveOperation(), oldss.getCmd());
        }
    }

    public void restoreSession(QueryState qs) {
        SessionState ss = SessionState.get();
        if (ss != null && qs != null && qs.isInitialized()) {
            ss.setCmd(qs.getCmd());
            ss.setCommandType(qs.getOp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String command, boolean resetTaskIds) {
        String explainOutput;
        BaseSemanticAnalyzer sem;
        ASTNode tree;
        HadoopShims shim;
        String originalCallerContext;
        String queryId;
        QueryState queryState;
        PerfLogger perfLogger;
        block21: {
            perfLogger = PerfLogger.getPerfLogger(true);
            perfLogger.PerfLogBegin(CLASS_NAME, "Driver.run");
            perfLogger.PerfLogBegin(CLASS_NAME, "compile");
            String queryStr = null;
            queryState = new QueryState();
            if (this.plan != null) {
                this.close();
                this.plan = null;
            }
            if (resetTaskIds) {
                TaskFactory.resetId();
            }
            this.saveSession(queryState);
            queryId = QueryPlan.makeQueryId();
            this.conf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
            SessionState.get().setupQueryCurrentTimestamp();
            originalCallerContext = "";
            shim = ShimLoader.getHadoopShims();
            try {
                final HiveTxnManager txnManager = SessionState.get().initTxnMgr(this.conf);
                ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
                this.shutdownRunner = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Driver.this.releaseLocksAndCommitOrRollback(Driver.this.ctx.getHiveLocks(), false, txnManager);
                        }
                        catch (LockException e) {
                            LOG.warn((Object)("Exception when releasing locks in ShutdownHook for Driver: " + e.getMessage()));
                        }
                    }
                };
                ShutdownHookManager.addShutdownHook(this.shutdownRunner, 0);
                originalCallerContext = shim.getHadoopCallerContext();
                LOG.info((Object)("We are setting the hadoop caller context from " + originalCallerContext + " to " + queryId));
                shim.setHadoopQueryContext(queryId);
                command = new VariableSubstitution().substitute(this.conf, command);
                this.ctx = new Context(this.conf);
                this.ctx.setTryCount(this.getTryCount());
                this.ctx.setCmd(command);
                this.ctx.setHDFSCleanup(true);
                perfLogger.PerfLogBegin(CLASS_NAME, "parse");
                ParseDriver pd = new ParseDriver();
                tree = pd.parse(command, this.ctx);
                tree = ParseUtils.findRootNonNullToken(tree);
                perfLogger.PerfLogEnd(CLASS_NAME, "parse");
                SessionState.get().initTxnMgr(this.conf);
                perfLogger.PerfLogBegin(CLASS_NAME, "semanticAnalyze");
                sem = SemanticAnalyzerFactory.get(this.conf, tree);
                List<HiveSemanticAnalyzerHook> saHooks = this.getHooks(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, HiveSemanticAnalyzerHook.class);
                if (saHooks != null) {
                    HiveSemanticAnalyzerHookContextImpl hookCtx = new HiveSemanticAnalyzerHookContextImpl();
                    hookCtx.setConf(this.conf);
                    hookCtx.setUserName(this.userName);
                    hookCtx.setIpAddress(SessionState.get().getUserIpAddress());
                    hookCtx.setCommand(command);
                    for (HiveSemanticAnalyzerHook hook : saHooks) {
                        tree = hook.preAnalyze(hookCtx, tree);
                    }
                    sem.analyze(tree, this.ctx);
                    hookCtx.update(sem);
                    for (HiveSemanticAnalyzerHook hook : saHooks) {
                        hook.postAnalyze(hookCtx, sem.getRootTasks());
                    }
                } else {
                    sem.analyze(tree, this.ctx);
                }
                this.acidSinks = sem.getAcidFileSinks();
                LOG.info((Object)"Semantic Analysis Completed");
                sem.validate();
                this.acidInQuery = sem.hasAcidInQuery();
                perfLogger.PerfLogEnd(CLASS_NAME, "semanticAnalyze");
                queryStr = HookUtils.redactLogString(this.conf, command);
                this.plan = new QueryPlan(queryStr, sem, perfLogger.getStartTime("Driver.run"), queryId, SessionState.get().getCommandType(), SessionState.get().getSessionId(), Thread.currentThread().getName(), HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_LOG_TRACE_ID));
                this.conf.setVar(HiveConf.ConfVars.HIVEQUERYSTRING, queryStr);
                this.conf.set("mapreduce.workflow.id", "hive_" + queryId);
                this.conf.set("mapreduce.workflow.name", queryStr);
                if (this.plan.getFetchTask() != null) {
                    this.plan.getFetchTask().initialize(this.conf, this.plan, null);
                }
                this.schema = Driver.getSchema(sem, this.conf);
                if (sem.skipAuthorization() || !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) break block21;
                try {
                    perfLogger.PerfLogBegin(CLASS_NAME, "doAuthorization");
                    Driver.doAuthorization(sem, command);
                }
                catch (AuthorizationException authExp) {
                    console.printError("Authorization failed:" + authExp.getMessage() + ". Use SHOW GRANT to get more details.");
                    this.errorMessage = authExp.getMessage();
                    this.SQLState = "42000";
                    int n = 403;
                    perfLogger.PerfLogEnd(CLASS_NAME, "compile");
                    this.dumpMetaCallTimingWithoutEx("compilation");
                    this.restoreSession(queryState);
                    LOG.info((Object)("We are resetting the hadoop caller context to " + originalCallerContext));
                    shim.setHadoopCallerContext(originalCallerContext);
                    return n;
                }
            }
            catch (Exception e) {
                ErrorMsg error = ErrorMsg.getErrorMsg(e.getMessage());
                this.errorMessage = "FAILED: " + e.getClass().getSimpleName();
                if (error != ErrorMsg.GENERIC_ERROR) {
                    this.errorMessage = this.errorMessage + " [Error " + error.getErrorCode() + "]:";
                }
                this.errorMessage = e instanceof IllegalArgumentException && e.getMessage() == null && e.getCause() != null ? this.errorMessage + " " + e.getCause().getMessage() : this.errorMessage + " " + e.getMessage();
                if (error == ErrorMsg.TXNMGR_NOT_ACID) {
                    this.errorMessage = this.errorMessage + ". Failed command: " + queryStr;
                }
                this.SQLState = error.getSQLState();
                this.downstreamError = e;
                console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                int n = error.getErrorCode();
                return n;
            }
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT) && (explainOutput = this.getExplainOutput(sem, this.plan, tree)) != null) {
            LOG.info((Object)("EXPLAIN output for queryid " + queryId + " : " + explainOutput));
        }
        int n = 0;
        return n;
        {
            finally {
                perfLogger.PerfLogEnd(CLASS_NAME, "doAuthorization");
            }
        }
        finally {
            perfLogger.PerfLogEnd(CLASS_NAME, "compile");
            this.dumpMetaCallTimingWithoutEx("compilation");
            this.restoreSession(queryState);
            LOG.info((Object)("We are resetting the hadoop caller context to " + originalCallerContext));
            shim.setHadoopCallerContext(originalCallerContext);
        }
    }

    private void dumpMetaCallTimingWithoutEx(String phase) {
        try {
            Hive.get().dumpAndClearMetaCallTiming(phase);
        }
        catch (HiveException he) {
            LOG.warn((Object)("Caught exception attempting to write metadata call information " + he), (Throwable)he);
        }
    }

    private String getExplainOutput(BaseSemanticAnalyzer sem, QueryPlan plan, ASTNode astTree) throws IOException {
        String ret = null;
        ExplainTask task = new ExplainTask();
        task.initialize(this.conf, plan, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            List<Task<?>> rootTasks = sem.getRootTasks();
            task.getJSONPlan(ps, astTree, rootTasks, sem.getFetchTask(), false, true, true);
            ret = baos.toString();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception generating explain output: " + e), (Throwable)e);
        }
        return ret;
    }

    public static void doAuthorization(BaseSemanticAnalyzer sem, String command) throws HiveException, AuthorizationException {
        ImportSemanticAnalyzer isa;
        SessionState ss = SessionState.get();
        HiveOperation op = ss.getHiveOperation();
        Hive db = sem.getDb();
        HashSet<ReadEntity> additionalInputs = new HashSet<ReadEntity>();
        for (Entity entity : sem.getInputs()) {
            if (entity.getType() != Entity.Type.PARTITION) continue;
            additionalInputs.add(new ReadEntity(entity.getTable()));
        }
        HashSet<WriteEntity> additionalOutputs = new HashSet<WriteEntity>();
        for (WriteEntity e : sem.getOutputs()) {
            if (e.getType() != Entity.Type.PARTITION) continue;
            additionalOutputs.add(new WriteEntity(e.getTable(), e.getWriteType()));
        }
        Sets.SetView<ReadEntity> setView = Sets.union(sem.getInputs(), additionalInputs);
        Sets.SetView<WriteEntity> outputs = Sets.union(sem.getOutputs(), additionalOutputs);
        if (ss.isAuthorizationModeV2()) {
            ColumnAccessInfo colAccessInfo = sem.getColumnAccessInfo();
            Map<String, List<String>> selectTab2Cols = colAccessInfo != null ? colAccessInfo.getTableToColumnAccessMap() : null;
            Map<String, List<String>> updateTab2Cols = sem.getUpdateColumnAccessInfo() != null ? sem.getUpdateColumnAccessInfo().getTableToColumnAccessMap() : null;
            Driver.doAuthorizationV2(ss, op, setView, outputs, command, selectTab2Cols, updateTab2Cols);
            return;
        }
        if (op == null) {
            throw new HiveException("Operation should not be null");
        }
        HiveAuthorizationProvider authorizer = ss.getAuthorizer();
        if (op.equals((Object)HiveOperation.CREATEDATABASE)) {
            authorizer.authorize(op.getInputRequiredPrivileges(), op.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.CREATETABLE)) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.IMPORT) && !(isa = (ImportSemanticAnalyzer)sem).existsTable()) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        }
        if (outputs != null && outputs.size() > 0) {
            for (WriteEntity write : outputs) {
                Partition part;
                if (write.isDummy() || write.isPathType()) continue;
                if (write.getType() == Entity.Type.DATABASE) {
                    if (op.equals((Object)HiveOperation.IMPORT)) continue;
                    authorizer.authorize(write.getDatabase(), null, op.getOutputRequiredPrivileges());
                    continue;
                }
                if (write.getType() == Entity.Type.PARTITION && (part = db.getPartition(write.getTable(), write.getPartition().getSpec(), false)) != null) {
                    authorizer.authorize(write.getPartition(), null, op.getOutputRequiredPrivileges());
                    continue;
                }
                if (write.getTable() == null) continue;
                authorizer.authorize(write.getTable(), null, op.getOutputRequiredPrivileges());
            }
        }
        if (setView != null && setView.size() > 0) {
            HashMap<Table, List<String>> tab2Cols = new HashMap<Table, List<String>>();
            HashMap<Partition, List<String>> part2Cols = new HashMap<Partition, List<String>>();
            HashMap<String, Boolean> tableUsePartLevelAuth = new HashMap<String, Boolean>();
            for (ReadEntity read : setView) {
                boolean usePartLevelPriv;
                String tblName;
                if (read.isDummy() || read.isPathType() || read.getType() == Entity.Type.DATABASE) continue;
                Table tbl = read.getTable();
                if (read.getPartition() == null && (tbl == null || !tbl.isPartitioned()) || tableUsePartLevelAuth.get(tblName = tbl.getTableName()) != null) continue;
                boolean bl = usePartLevelPriv = tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE") != null && "TRUE".equalsIgnoreCase(tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"));
                if (usePartLevelPriv) {
                    tableUsePartLevelAuth.put(tblName, Boolean.TRUE);
                    continue;
                }
                tableUsePartLevelAuth.put(tblName, Boolean.FALSE);
            }
            Driver.getTablePartitionUsedColumns(op, sem, tab2Cols, part2Cols, tableUsePartLevelAuth);
            HashSet<String> tableAuthChecked = new HashSet<String>();
            for (ReadEntity read : setView) {
                Partition partition;
                if (read.isDummy() || read.isPathType() || !read.isDirect()) continue;
                if (read.getType() == Entity.Type.DATABASE) {
                    authorizer.authorize(read.getDatabase(), op.getInputRequiredPrivileges(), null);
                    continue;
                }
                Table tbl = read.getTable();
                if (tbl.isView() && sem instanceof SemanticAnalyzer) {
                    tab2Cols.put(tbl, sem.getColumnAccessInfo().getTableToColumnAccessMap().get(tbl.getCompleteName()));
                }
                if (read.getPartition() != null && Boolean.TRUE.equals(tableUsePartLevelAuth.get((tbl = (partition = read.getPartition()).getTable()).getTableName()))) {
                    List cols = (List)part2Cols.get(partition);
                    if (cols != null && cols.size() > 0) {
                        authorizer.authorize(partition.getTable(), partition, cols, op.getInputRequiredPrivileges(), null);
                        continue;
                    }
                    authorizer.authorize(partition, op.getInputRequiredPrivileges(), null);
                    continue;
                }
                if (tbl == null || tableAuthChecked.contains(tbl.getTableName()) || Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) continue;
                List cols = (List)tab2Cols.get(tbl);
                if (cols != null && cols.size() > 0) {
                    authorizer.authorize(tbl, null, cols, op.getInputRequiredPrivileges(), null);
                } else {
                    authorizer.authorize(tbl, op.getInputRequiredPrivileges(), null);
                }
                tableAuthChecked.add(tbl.getTableName());
            }
        }
    }

    private static void getTablePartitionUsedColumns(HiveOperation op, BaseSemanticAnalyzer sem, Map<Table, List<String>> tab2Cols, Map<Partition, List<String>> part2Cols, Map<String, Boolean> tableUsePartLevelAuth) throws HiveException {
        if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.QUERY)) {
            SemanticAnalyzer querySem = (SemanticAnalyzer)sem;
            ParseContext parseCtx = querySem.getParseContext();
            for (Map.Entry<String, Operator<? extends OperatorDesc>> topOpMap : querySem.getParseContext().getTopOps().entrySet()) {
                TableScanOperator tableScanOp = (TableScanOperator)topOpMap.getValue();
                if (tableScanOp.isInsideView()) continue;
                Table tbl = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata();
                List<Integer> neededColumnIds = tableScanOp.getNeededColumnIDs();
                List<FieldSchema> columns = tbl.getCols();
                ArrayList<String> cols = new ArrayList<String>();
                for (int i = 0; i < neededColumnIds.size(); ++i) {
                    cols.add(columns.get(neededColumnIds.get(i)).getName());
                }
                if (tbl.isPartitioned() && Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) {
                    String alias_id = topOpMap.getKey();
                    PrunedPartitionList partsList = PartitionPruner.prune(tableScanOp, parseCtx, alias_id);
                    Set<Partition> parts = partsList.getPartitions();
                    for (Partition part : parts) {
                        List<String> existingCols = part2Cols.get(part);
                        if (existingCols == null) {
                            existingCols = new ArrayList<String>();
                        }
                        existingCols.addAll(cols);
                        part2Cols.put(part, existingCols);
                    }
                    continue;
                }
                List<String> existingCols = tab2Cols.get(tbl);
                if (existingCols == null) {
                    existingCols = new ArrayList<String>();
                }
                existingCols.addAll(cols);
                tab2Cols.put(tbl, existingCols);
            }
        }
    }

    private static void doAuthorizationV2(SessionState ss, HiveOperation op, Set<ReadEntity> inputs, Set<WriteEntity> outputs, String command, Map<String, List<String>> tab2cols, Map<String, List<String>> updateTab2Cols) throws HiveException {
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        authzContextBuilder.setCommandString(command);
        HiveOperationType hiveOpType = Driver.getHiveOperationType(op);
        List<HivePrivilegeObject> inputsHObjs = Driver.getHivePrivObjects(inputs, tab2cols);
        List<HivePrivilegeObject> outputHObjs = Driver.getHivePrivObjects(outputs, updateTab2Cols);
        ss.getAuthorizerV2().checkPrivileges(hiveOpType, inputsHObjs, outputHObjs, authzContextBuilder.build());
    }

    private static List<HivePrivilegeObject> getHivePrivObjects(Set<? extends Entity> privObjects, Map<String, List<String>> tableName2Cols) {
        ArrayList<HivePrivilegeObject> hivePrivobjs = new ArrayList<HivePrivilegeObject>();
        if (privObjects == null) {
            return hivePrivobjs;
        }
        block7: for (Entity entity : privObjects) {
            HivePrivilegeObject.HivePrivilegeObjectType privObjType = AuthorizationUtils.getHivePrivilegeObjectType(entity.getType());
            if (entity.isDummy() || entity instanceof ReadEntity && !((ReadEntity)entity).isDirect() || entity instanceof WriteEntity && ((WriteEntity)entity).isTempURI()) continue;
            String dbname = null;
            String objName = null;
            List<String> partKeys = null;
            List<String> columns = null;
            switch (entity.getType()) {
                case DATABASE: {
                    dbname = entity.getDatabase().getName();
                    break;
                }
                case TABLE: {
                    dbname = entity.getTable().getDbName();
                    objName = entity.getTable().getTableName();
                    columns = tableName2Cols == null ? null : tableName2Cols.get(Table.getCompleteName(dbname, objName));
                    break;
                }
                case DFS_DIR: 
                case LOCAL_DIR: {
                    objName = entity.getD().toString();
                    break;
                }
                case FUNCTION: {
                    if (entity.getDatabase() != null) {
                        dbname = entity.getDatabase().getName();
                    }
                    objName = entity.getFunctionName();
                    break;
                }
                case DUMMYPARTITION: 
                case PARTITION: {
                    continue block7;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected object type");
                }
            }
            HivePrivilegeObject.HivePrivObjectActionType actionType = AuthorizationUtils.getActionType(entity);
            HivePrivilegeObject hPrivObject = new HivePrivilegeObject(privObjType, dbname, objName, partKeys, columns, actionType, null);
            hivePrivobjs.add(hPrivObject);
        }
        return hivePrivobjs;
    }

    private static HiveOperationType getHiveOperationType(HiveOperation op) {
        return HiveOperationType.valueOf(op.name());
    }

    public QueryPlan getPlan() {
        return this.plan;
    }

    private List<HiveLockObj> getLockObjects(Database d, Table t, Partition p, HiveLockMode mode) throws SemanticException {
        LinkedList<HiveLockObj> locks = new LinkedList<HiveLockObj>();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(this.plan.getQueryId(), String.valueOf(System.currentTimeMillis()), "IMPLICIT", this.plan.getQueryStr());
        if (d != null) {
            locks.add(new HiveLockObj(new HiveLockObject(d.getName(), lockData), mode));
            return locks;
        }
        if (t != null) {
            locks.add(new HiveLockObj(new HiveLockObject(t.getDbName(), lockData), mode));
            locks.add(new HiveLockObj(new HiveLockObject(t, lockData), mode));
            mode = HiveLockMode.SHARED;
            locks.add(new HiveLockObj(new HiveLockObject(t.getDbName(), lockData), mode));
            return locks;
        }
        if (p != null) {
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable().getDbName(), lockData), mode));
            if (!(p instanceof DummyPartition)) {
                locks.add(new HiveLockObj(new HiveLockObject(p, lockData), mode));
            }
            mode = HiveLockMode.SHARED;
            String name = p.getName();
            if (p instanceof DummyPartition) {
                name = p.getName().split("@")[2];
            }
            String partialName = "";
            String[] partns = name.split("/");
            int len = p instanceof DummyPartition ? partns.length : partns.length - 1;
            LinkedHashMap<String, String> partialSpec = new LinkedHashMap<String, String>();
            for (int idx = 0; idx < len; ++idx) {
                String partn = partns[idx];
                partialName = partialName + partn;
                String[] nameValue = partn.split("=");
                assert (nameValue.length == 2);
                partialSpec.put(nameValue[0], nameValue[1]);
                try {
                    locks.add(new HiveLockObj(new HiveLockObject(new DummyPartition(p.getTable(), p.getTable().getDbName() + "/" + p.getTable().getTableName() + "/" + partialName, partialSpec), lockData), mode));
                    partialName = partialName + "/";
                    continue;
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage());
                }
            }
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable(), lockData), mode));
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable().getDbName(), lockData), mode));
        }
        return locks;
    }

    private void recordValidTxns() throws LockException {
        HiveTxnManager txnMgr = SessionState.get().getTxnMgr();
        ValidTxnList txns = txnMgr.getValidTxns();
        String txnStr = txns.toString();
        this.conf.set("hive.txn.valid.txns", txnStr);
        if (this.plan.getFetchTask() != null) {
            this.plan.getFetchTask().setValidTxnList(txnStr);
        }
        LOG.debug((Object)("Encoding valid txns info " + txnStr + " txnid:" + txnMgr.getCurrentTxnId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireLocksAndOpenTxn() {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "acquireReadWriteLocks");
        SessionState ss = SessionState.get();
        HiveTxnManager txnMgr = ss.getTxnMgr();
        try {
            String userFromUGI;
            try {
                userFromUGI = this.conf.getUser();
            }
            catch (IOException e) {
                this.errorMessage = "FAILED: Error in determining user while acquiring locks: " + e.getMessage();
                this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                this.downstreamError = e;
                console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                int n = 10;
                perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
                return n;
            }
            if (txnMgr.getAutoCommit() && this.haveAcidWrite()) {
                if (txnMgr.isTxnOpen()) {
                    throw new RuntimeException("Already have an open transaction txnid:" + txnMgr.getCurrentTxnId());
                }
                txnMgr.openTxn(this.ctx, userFromUGI);
                LOG.debug((Object)("Setting current transaction to " + txnMgr.getCurrentTxnId()));
                for (FileSinkDesc desc : this.acidSinks) {
                    desc.setTransactionId(txnMgr.getCurrentTxnId());
                    desc.setStatementId(txnMgr.getWriteIdAndIncrement());
                }
            }
            txnMgr.acquireLocks(this.plan, this.ctx, userFromUGI);
            if (this.acidInQuery) {
                this.recordValidTxns();
            }
            int n = 0;
            return n;
        }
        catch (LockException e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 10;
            return n;
        }
        finally {
            perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
        }
    }

    private boolean haveAcidWrite() {
        return this.acidSinks != null && !this.acidSinks.isEmpty();
    }

    private void releaseLocksAndCommitOrRollback(List<HiveLock> hiveLocks, boolean commit, HiveTxnManager txnManager) throws LockException {
        HiveTxnManager txnMgr;
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "releaseLocks");
        if (txnManager == null) {
            SessionState ss = SessionState.get();
            txnMgr = ss.getTxnMgr();
        } else {
            txnMgr = txnManager;
        }
        if (txnMgr.isTxnOpen()) {
            if (commit) {
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN)) {
                    txnMgr.rollbackTxn();
                } else {
                    txnMgr.commitTxn();
                }
            } else {
                txnMgr.rollbackTxn();
            }
        } else if (hiveLocks != null) {
            txnMgr.releaseLocks(hiveLocks);
        }
        this.ctx.setHiveLocks(null);
        perfLogger.PerfLogEnd(CLASS_NAME, "releaseLocks");
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandNeedRetryException {
        return this.run(command, false);
    }

    public CommandProcessorResponse run() throws CommandNeedRetryException {
        return this.run(null, true);
    }

    public CommandProcessorResponse run(String command, boolean alreadyCompiled) throws CommandNeedRetryException {
        CommandProcessorResponse cpr = this.runInternal(command, alreadyCompiled);
        if (cpr.getResponseCode() == 0) {
            return cpr;
        }
        SessionState ss = SessionState.get();
        if (ss == null) {
            return cpr;
        }
        MetaDataFormatter mdf = MetaDataFormatUtils.getFormatter(ss.getConf());
        if (!(mdf instanceof JsonMetaDataFormatter)) {
            return cpr;
        }
        try {
            if (this.downstreamError == null) {
                mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState);
                return cpr;
            }
            ErrorMsg canonicalErr = ErrorMsg.getErrorMsg(cpr.getResponseCode());
            if (canonicalErr != null && canonicalErr != ErrorMsg.GENERIC_ERROR) {
                mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState, null);
                return cpr;
            }
            if (this.downstreamError instanceof HiveException) {
                HiveException rc = (HiveException)this.downstreamError;
                mdf.error(ss.out, this.errorMessage, rc.getCanonicalErrorMsg().getErrorCode(), this.SQLState, rc.getCanonicalErrorMsg() == ErrorMsg.GENERIC_ERROR ? org.apache.hadoop.util.StringUtils.stringifyException((Throwable)rc) : null);
            } else {
                ErrorMsg canonicalMsg = ErrorMsg.getErrorMsg(this.downstreamError.getMessage());
                mdf.error(ss.out, this.errorMessage, canonicalMsg.getErrorCode(), this.SQLState, org.apache.hadoop.util.StringUtils.stringifyException((Throwable)this.downstreamError));
            }
        }
        catch (HiveException ex) {
            console.printError("Unable to JSON-encode the error", org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
        }
        return cpr;
    }

    public CommandProcessorResponse compileAndRespond(String command) {
        return this.createProcessorResponse(this.compileInternal(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compileInternal(String command) {
        int ret;
        Object object = compileMonitor;
        synchronized (object) {
            ret = this.compile(command);
        }
        if (ret != 0) {
            try {
                this.releaseLocksAndCommitOrRollback(this.ctx.getHiveLocks(), false, null);
            }
            catch (LockException e) {
                LOG.warn((Object)("Exception in releasing locks. " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        return ret;
    }

    private CommandProcessorResponse runInternal(String command, boolean alreadyCompiled) throws CommandNeedRetryException {
        int ret;
        List<HiveDriverRunHook> driverRunHooks;
        this.errorMessage = null;
        this.SQLState = null;
        this.downstreamError = null;
        HiveDriverRunHookContextImpl hookContext = new HiveDriverRunHookContextImpl(this.conf, command);
        try {
            driverRunHooks = this.getHooks(HiveConf.ConfVars.HIVE_DRIVER_RUN_HOOKS, HiveDriverRunHook.class);
            for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                driverRunHook.preDriverRun(hookContext);
            }
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return this.createProcessorResponse(12);
        }
        PerfLogger perfLogger = null;
        if (!alreadyCompiled) {
            int ret2 = this.compileInternal(command);
            perfLogger = SessionState.getPerfLogger();
            if (ret2 != 0) {
                return this.createProcessorResponse(ret2);
            }
        } else {
            perfLogger = SessionState.getPerfLogger();
            this.plan.setQueryStartTime(perfLogger.getStartTime("Driver.run"));
        }
        this.ctx.setHiveTxnManager(SessionState.get().getTxnMgr());
        if (this.requiresLock() && (ret = this.acquireLocksAndOpenTxn()) != 0) {
            try {
                this.releaseLocksAndCommitOrRollback(this.ctx.getHiveLocks(), false, null);
            }
            catch (LockException e) {
                // empty catch block
            }
            return this.createProcessorResponse(ret);
        }
        ret = this.execute();
        if (ret != 0) {
            try {
                this.releaseLocksAndCommitOrRollback(this.ctx.getHiveLocks(), false, null);
            }
            catch (LockException e) {
                // empty catch block
            }
            return this.createProcessorResponse(ret);
        }
        try {
            this.releaseLocksAndCommitOrRollback(this.ctx.getHiveLocks(), true, null);
        }
        catch (LockException e) {
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return this.createProcessorResponse(12);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "Driver.run");
        perfLogger.close(LOG, this.plan);
        try {
            for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                driverRunHook.postDriverRun(hookContext);
            }
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return this.createProcessorResponse(12);
        }
        return this.createProcessorResponse(ret);
    }

    private boolean requiresLock() {
        if (!this.checkConcurrency()) {
            return false;
        }
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_LOCK_MAPRED_ONLY)) {
            return true;
        }
        LinkedList<Task<? extends Serializable>> taskQueue = new LinkedList<Task<? extends Serializable>>();
        taskQueue.addAll(this.plan.getRootTasks());
        while (taskQueue.peek() != null) {
            Task tsk = (Task)taskQueue.remove();
            if (tsk.requireLock()) {
                return true;
            }
            if (tsk instanceof ConditionalTask) {
                taskQueue.addAll(((ConditionalTask)tsk).getListTasks());
            }
            if (tsk.getChildTasks() == null) continue;
            taskQueue.addAll(tsk.getChildTasks());
        }
        return false;
    }

    private CommandProcessorResponse createProcessorResponse(int ret) {
        SessionState.getPerfLogger().cleanupPerfLogMetrics();
        return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState, this.downstreamError);
    }

    private List<Hook> getHooks(HiveConf.ConfVars hookConfVar) throws Exception {
        return this.getHooks(hookConfVar, Hook.class);
    }

    private <T extends Hook> List<T> getHooks(HiveConf.ConfVars hookConfVar, Class<T> clazz) throws Exception {
        try {
            return HookUtils.getHooks(this.conf, hookConfVar, clazz);
        }
        catch (ClassNotFoundException e) {
            console.printError(hookConfVar.varname + " Class not found:" + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws CommandNeedRetryException {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "Driver.execute");
        boolean noName = StringUtils.isEmpty(this.conf.getVar(HiveConf.ConfVars.HADOOPJOBNAME));
        int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
        String queryId = this.plan.getQueryId();
        String queryStr = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYSTRING);
        this.maxthreads = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.EXECPARALLETHREADNUMBER);
        String originalCallerContext = "";
        try {
            LOG.info((Object)("Setting caller context to query id " + queryId));
            originalCallerContext = ShimLoader.getHadoopShims().getHadoopCallerContext();
            ShimLoader.getHadoopShims().setHadoopQueryContext(queryId);
            LOG.info((Object)("Starting command(queryId=" + queryId + "): " + queryStr));
            Hive.get().clearMetaCallTiming();
            this.plan.setStarted();
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().startQuery(queryStr, this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                SessionState.get().getHiveHistory().logPlanProgress(this.plan);
            }
            this.resStream = null;
            SessionState ss = SessionState.get();
            HookContext hookContext = new HookContext(this.plan, this.conf, this.ctx.getPathToCS(), ss.getUserFromAuthenticator(), ss.getUserIpAddress(), InetAddress.getLocalHost().getHostAddress(), this.operationId, ss.getSessionId(), Thread.currentThread().getName(), ss.isHiveServerQuery(), perfLogger);
            hookContext.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
            for (Hook peh : this.getHooks(HiveConf.ConfVars.PREEXECHOOKS)) {
                if (peh instanceof ExecuteWithHookContext) {
                    perfLogger.PerfLogBegin(CLASS_NAME, "PreHook." + peh.getClass().getName());
                    ((ExecuteWithHookContext)peh).run(hookContext);
                    perfLogger.PerfLogEnd(CLASS_NAME, "PreHook." + peh.getClass().getName());
                    continue;
                }
                if (!(peh instanceof PreExecute)) continue;
                perfLogger.PerfLogBegin(CLASS_NAME, "PreHook." + peh.getClass().getName());
                ((PreExecute)peh).run(SessionState.get(), this.plan.getInputs(), this.plan.getOutputs(), Utils.getUGI());
                perfLogger.PerfLogEnd(CLASS_NAME, "PreHook." + peh.getClass().getName());
            }
            int jobs = Utilities.getMRTasks(this.plan.getRootTasks()).size() + Utilities.getTezTasks(this.plan.getRootTasks()).size() + Utilities.getSparkTasks(this.plan.getRootTasks()).size();
            if (jobs > 0) {
                console.printInfo("Query ID = " + this.plan.getQueryId());
                console.printInfo("Total jobs = " + jobs);
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_NUM_TASKS, String.valueOf(jobs));
                SessionState.get().getHiveHistory().setIdToTableMap(this.plan.getIdToTableNameMap());
            }
            String jobname = Utilities.abbreviate(queryStr, maxlen - 6);
            DriverContext driverCxt = new DriverContext(this.ctx);
            driverCxt.prepare(this.plan);
            this.ctx.setHDFSCleanup(true);
            this.driverCxt = driverCxt;
            SessionState.get().setMapRedStats(new LinkedHashMap<String, MapRedStats>());
            SessionState.get().setStackTraces(new HashMap<String, List<List<String>>>());
            SessionState.get().setLocalMapRedErrors(new HashMap<String, List<String>>());
            for (Task task : this.plan.getRootTasks()) {
                assert (task.getParentTasks() == null || task.getParentTasks().isEmpty());
                driverCxt.addToRunnable(task);
            }
            perfLogger.PerfLogBegin(CLASS_NAME, "runTasks");
            while (!this.destroyed && driverCxt.isRunning()) {
                TaskRunner taskRunner;
                Task<? extends Serializable> task;
                while ((task = driverCxt.getRunnable(this.maxthreads)) != null && (taskRunner = this.launchTask(task, queryId, noName, jobname, jobs, driverCxt)).isRunning()) {
                }
                TaskRunner taskRunner2 = driverCxt.pollFinished();
                if (taskRunner2 == null) continue;
                hookContext.addCompleteTask(taskRunner2);
                Task<? extends Serializable> tsk = taskRunner2.getTask();
                TaskResult result = taskRunner2.getTaskResult();
                int exitVal = result.getExitVal();
                if (exitVal != 0) {
                    if (tsk.ifRetryCmdWhenFail()) {
                        driverCxt.shutdown();
                        this.ctx.restoreOriginalTracker();
                        throw new CommandNeedRetryException();
                    }
                    Task<Serializable> backupTask = tsk.getAndInitBackupTask();
                    if (backupTask != null) {
                        this.setErrorMsgAndDetail(exitVal, result.getTaskError(), tsk);
                        console.printError(this.errorMessage);
                        this.errorMessage = "ATTEMPT: Execute BackupTask: " + backupTask.getClass().getName();
                        console.printError(this.errorMessage);
                        if (!DriverContext.isLaunchable(backupTask)) continue;
                        driverCxt.addToRunnable(backupTask);
                        continue;
                    }
                    hookContext.setHookType(HookContext.HookType.ON_FAILURE_HOOK);
                    for (Hook ofh : this.getHooks(HiveConf.ConfVars.ONFAILUREHOOKS)) {
                        perfLogger.PerfLogBegin(CLASS_NAME, "FailureHook." + ofh.getClass().getName());
                        ((ExecuteWithHookContext)ofh).run(hookContext);
                        perfLogger.PerfLogEnd(CLASS_NAME, "FailureHook." + ofh.getClass().getName());
                    }
                    this.setErrorMsgAndDetail(exitVal, result.getTaskError(), tsk);
                    this.SQLState = "08S01";
                    console.printError(this.errorMessage);
                    driverCxt.shutdown();
                    this.ctx.restoreOriginalTracker();
                    int i$ = exitVal;
                    return i$;
                }
                driverCxt.finished(taskRunner2);
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().setTaskProperty(queryId, tsk.getId(), HiveHistory.Keys.TASK_RET_CODE, String.valueOf(exitVal));
                    SessionState.get().getHiveHistory().endTask(queryId, tsk);
                }
                if (tsk.getChildTasks() == null) continue;
                for (Task<Serializable> child : tsk.getChildTasks()) {
                    if (!DriverContext.isLaunchable(child)) continue;
                    driverCxt.addToRunnable(child);
                }
            }
            perfLogger.PerfLogEnd(CLASS_NAME, "runTasks");
            this.ctx.restoreOriginalTracker();
            if (driverCxt.isShutdown()) {
                this.SQLState = "HY008";
                this.errorMessage = "FAILED: Operation cancelled";
                console.printError(this.errorMessage);
                int task = 1000;
                return task;
            }
            LinkedHashSet<WriteEntity> remOutputs = new LinkedHashSet<WriteEntity>();
            for (WriteEntity output : this.plan.getOutputs()) {
                if (output.isComplete()) continue;
                remOutputs.add(output);
            }
            for (WriteEntity output : remOutputs) {
                this.plan.getOutputs().remove(output);
            }
            hookContext.setHookType(HookContext.HookType.POST_EXEC_HOOK);
            for (Hook peh : this.getHooks(HiveConf.ConfVars.POSTEXECHOOKS)) {
                if (peh instanceof ExecuteWithHookContext) {
                    perfLogger.PerfLogBegin(CLASS_NAME, "PostHook." + peh.getClass().getName());
                    ((ExecuteWithHookContext)peh).run(hookContext);
                    perfLogger.PerfLogEnd(CLASS_NAME, "PostHook." + peh.getClass().getName());
                    continue;
                }
                if (!(peh instanceof PostExecute)) continue;
                perfLogger.PerfLogBegin(CLASS_NAME, "PostHook." + peh.getClass().getName());
                ((PostExecute)peh).run(SessionState.get(), this.plan.getInputs(), this.plan.getOutputs(), SessionState.get() != null ? SessionState.get().getLineageState().getLineageInfo() : null, Utils.getUGI());
                perfLogger.PerfLogEnd(CLASS_NAME, "PostHook." + peh.getClass().getName());
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(0));
                SessionState.get().getHiveHistory().printRowCount(queryId);
            }
        }
        catch (CommandNeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.ctx.restoreOriginalTracker();
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(12));
            }
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = "08S01";
            this.downstreamError = e;
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 12;
            return n;
        }
        finally {
            LOG.info((Object)("Resetting the caller context to " + originalCallerContext));
            ShimLoader.getHadoopShims().setHadoopCallerContext(originalCallerContext);
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().endQuery(queryId);
            }
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, "");
            }
            this.dumpMetaCallTimingWithoutEx("execution");
            perfLogger.PerfLogEnd(CLASS_NAME, "Driver.execute");
            Map<String, MapRedStats> stats = SessionState.get().getMapRedStats();
            if (stats != null && !stats.isEmpty()) {
                long totalCpu = 0L;
                console.printInfo("MapReduce Jobs Launched: ");
                for (Map.Entry<String, MapRedStats> entry : stats.entrySet()) {
                    console.printInfo("Stage-" + entry.getKey() + ": " + entry.getValue());
                    totalCpu += entry.getValue().getCpuMSec();
                }
                console.printInfo("Total MapReduce CPU Time Spent: " + Utilities.formatMsecToStr(totalCpu));
            }
        }
        this.releasePlan(this.plan);
        if (console != null) {
            console.printInfo("OK");
        }
        return 0;
    }

    private synchronized void releasePlan(QueryPlan plan) {
        if (plan != null) {
            plan.setDone();
            if (SessionState.get() != null) {
                SessionState.get().getLineageState().clear();
                try {
                    SessionState.get().getHiveHistory().logPlanProgress(plan);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Could not log query plan progress", (Throwable)e);
                }
            }
        }
    }

    private void setErrorMsgAndDetail(int exitVal, Throwable downstreamError, Task tsk) {
        this.downstreamError = downstreamError;
        this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
        if (downstreamError != null) {
            this.errorMessage = this.errorMessage + ". " + downstreamError.getMessage();
        } else {
            ErrorMsg em = ErrorMsg.getErrorMsg(exitVal);
            if (em != null) {
                this.errorMessage = this.errorMessage + ". " + em.getMsg();
            }
        }
    }

    private TaskRunner launchTask(Task<? extends Serializable> tsk, String queryId, boolean noName, String jobname, int jobs, DriverContext cxt) throws HiveException {
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().startTask(queryId, tsk, tsk.getClass().getName());
        }
        if (tsk.isMapRedTask() && !(tsk instanceof ConditionalTask)) {
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, jobname + "(" + tsk.getId() + ")");
            }
            this.conf.set("mapreduce.workflow.node.name", tsk.getId());
            Utilities.setWorkflowAdjacencies(this.conf, this.plan);
            cxt.incCurJobNo(1);
            console.printInfo("Launching Job " + cxt.getCurJobNo() + " out of " + jobs);
        }
        tsk.initialize(this.conf, this.plan, cxt);
        TaskResult tskRes = new TaskResult();
        TaskRunner tskRun = new TaskRunner(tsk, tskRes);
        cxt.launching(tskRun);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.EXECPARALLEL) && tsk.isMapRedTask()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Starting task [" + tsk + "] in parallel"));
            }
            tskRun.setOperationLog(OperationLog.getCurrentOperationLog());
            tskRun.start();
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Starting task [" + tsk + "] in serial mode"));
            }
            tskRun.runSequential();
        }
        return tskRun;
    }

    public boolean isFetchingTable() {
        return this.plan != null && this.plan.getFetchTask() != null;
    }

    public boolean getResults(List res) throws IOException, CommandNeedRetryException {
        if (this.destroyed) {
            throw new IOException("FAILED: Operation cancelled");
        }
        if (this.isFetchingTable()) {
            FetchTask ft = this.plan.getFetchTask();
            ft.setMaxRows(this.maxRows);
            return ft.fetch(res);
        }
        if (this.resStream == null) {
            this.resStream = this.ctx.getStream();
        }
        if (this.resStream == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.StreamStatus ss;
            if (this.resStream == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.resStream, this.bos);
                if (this.bos.getLength() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getLength(), "UTF-8");
                } else if (ss == Utilities.StreamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
                row = null;
            }
            catch (IOException e) {
                console.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                return false;
            }
            if (ss != Utilities.StreamStatus.EOF) continue;
            this.resStream = this.ctx.getStream();
        }
        return true;
    }

    public void resetFetch() throws IOException {
        if (this.plan != null && this.plan.getFetchTask() != null) {
            try {
                this.plan.getFetchTask().clearFetch();
            }
            catch (Exception e) {
                throw new IOException("Error closing the current fetch task", e);
            }
            this.plan.getFetchTask().initialize(this.conf, this.plan, null);
        } else {
            this.ctx.resetStream();
            this.resStream = null;
        }
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public int close() {
        try {
            FetchTask fetchTask;
            if (this.plan != null && null != (fetchTask = this.plan.getFetchTask())) {
                try {
                    fetchTask.clearFetch();
                }
                catch (Exception e) {
                    LOG.debug((Object)" Exception while clearing the Fetch task ", (Throwable)e);
                }
            }
            if (this.driverCxt != null) {
                this.driverCxt.shutdown();
                this.driverCxt = null;
            }
            if (this.ctx != null) {
                this.ctx.clear();
            }
            if (null != this.resStream) {
                try {
                    ((FSDataInputStream)this.resStream).close();
                }
                catch (Exception e) {
                    LOG.debug((Object)" Exception while closing the resStream ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            console.printError("FAILED: Hive Internal Error: " + Utilities.getNameMessage(e) + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 13;
        }
        return 0;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.ctx != null) {
            try {
                this.releaseLocksAndCommitOrRollback(this.ctx.getHiveLocks(), false, null);
            }
            catch (LockException e) {
                LOG.warn((Object)("Exception when releasing locking in destroy: " + e.getMessage()));
            }
        }
        ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
    }

    public Query getQueryPlan() throws IOException {
        return this.plan.getQueryPlan();
    }

    public String getErrorMsg() {
        return this.errorMessage;
    }

    public void setOperationId(String opId) {
        this.operationId = opId;
    }

    private static class QueryState {
        private HiveOperation op;
        private String cmd;
        private boolean init = false;

        private QueryState() {
        }

        public void init(HiveOperation op, String cmd) {
            this.op = op;
            this.cmd = cmd;
            this.init = true;
        }

        public boolean isInitialized() {
            return this.init;
        }

        public HiveOperation getOp() {
            return this.op;
        }

        public String getCmd() {
            return this.cmd;
        }
    }
}

