/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.welcome;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.settings.SettingsUtil;
import org.pentaho.reporting.designer.core.welcome.SampleReport;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class SamplesTreeBuilder {
    private static final Log logger = LogFactory.getLog(SamplesTreeBuilder.class);
    private static DefaultTreeModel sampleTreeModel;
    private static final DirectoryFileFilter DIRECTORY_FILTER;
    private static final FilesystemFilter REPORT_FILES_FILTER;

    private SamplesTreeBuilder() {
    }

    public static synchronized TreeModel getSampleTreeModel() {
        if (sampleTreeModel == null) {
            sampleTreeModel = SamplesTreeBuilder.createModel();
        }
        return sampleTreeModel;
    }

    private static DefaultTreeModel createModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Messages.getString("WelcomePane.samples", new Object[0]));
        DefaultTreeModel model = new DefaultTreeModel(root);
        try {
            File configTemplateDir;
            ResourceManager resourceManager = new ResourceManager();
            HashMap cache = SamplesTreeBuilder.loadFromCache(resourceManager);
            File installationDirectory = SettingsUtil.computeInstallationDirectory();
            if (installationDirectory != null && (configTemplateDir = new File(installationDirectory, "samples")).exists() && configTemplateDir.isDirectory()) {
                SamplesTreeBuilder.processDirectory(root, configTemplateDir, cache, resourceManager);
            }
            SamplesTreeBuilder.storeToCache(cache);
        }
        catch (Exception e) {
            return model;
        }
        return model;
    }

    private static void processDirectory(DefaultMutableTreeNode root, File dir, HashMap cachedEntries, ResourceManager resourceManager) {
        try {
            File[] dirs = dir.listFiles(DIRECTORY_FILTER);
            if (dirs == null) {
                return;
            }
            for (File f : dirs) {
                DirectoryNode dirNode = new DirectoryNode((Object)f.getName());
                root.add(dirNode);
                SamplesTreeBuilder.processDirectory(dirNode, f, cachedEntries, resourceManager);
            }
            Object[] samplesArray = dir.listFiles((FilenameFilter)REPORT_FILES_FILTER);
            if (samplesArray == null) {
                return;
            }
            Arrays.sort(samplesArray);
            for (Object f : samplesArray) {
                SampleReport entryFromCache = (SampleReport)cachedEntries.get(((File)f).getAbsolutePath());
                if (entryFromCache == null) {
                    SampleReport tempRpt = new SampleReport((File)f, resourceManager);
                    if (!StringUtils.isEmpty((String)tempRpt.getReportName())) {
                        SampleNode sample = new SampleNode(tempRpt.getReportName(), tempRpt.getFileName());
                        root.add(sample);
                    }
                    cachedEntries.put(((File)f).getAbsolutePath(), tempRpt);
                    continue;
                }
                if (StringUtils.isEmpty((String)entryFromCache.getReportName())) continue;
                SampleNode sample = new SampleNode(entryFromCache.getReportName(), entryFromCache.getFileName());
                root.add(sample);
            }
        }
        catch (Exception se) {
            logger.error((Object)"Cannot access Application directory", (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static HashMap loadFromCache(ResourceManager resourceManager) {
        File location = SamplesTreeBuilder.createStorageLocation();
        if (location == null) {
            return new HashMap();
        }
        File ttfCache = new File(location, "samples-cache.ser");
        try {
            HashMap cachedSeenFiles;
            ResourceKey resourceKey = resourceManager.createKey((Object)ttfCache);
            ResourceData data = resourceManager.load(resourceKey);
            try (InputStream stream = data.getResourceAsStream(resourceManager);){
                ObjectInputStream oin = new ObjectInputStream(stream);
                Object[] cache = (Object[])oin.readObject();
                if (cache.length != 1) {
                    HashMap hashMap = new HashMap();
                    return hashMap;
                }
                cachedSeenFiles = (HashMap)cache[0];
            }
            if (!SamplesTreeBuilder.isCacheValid(cachedSeenFiles)) return new HashMap();
            return cachedSeenFiles;
        }
        catch (ClassNotFoundException cnfe) {
            logger.debug((Object)"Failed to restore the cache: Cache was created by a different version of ReportDesigner");
            return new HashMap();
        }
        catch (Exception e) {
            logger.debug((Object)"Non-Fatal: Failed to restore the cache. The cache will be rebuilt.", (Throwable)e);
        }
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void storeToCache(HashMap seenFiles) {
        File location = SamplesTreeBuilder.createStorageLocation();
        if (location == null) {
            return;
        }
        location.mkdirs();
        if (!location.exists() || !location.isDirectory()) {
            return;
        }
        File ttfCache = new File(location, "samples-cache.ser");
        try {
            FileOutputStream fout = new FileOutputStream(ttfCache);
            try {
                Object[] map = new Object[]{seenFiles};
                ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(fout));
                objectOut.writeObject(map);
                objectOut.close();
            }
            finally {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    logger.debug((Object)"Failed to store cached samples data", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to store cached samples data", (Throwable)e);
        }
    }

    protected static File createStorageLocation() {
        String homeDirectory = SamplesTreeBuilder.safeSystemGetProperty("user.home", null);
        if (homeDirectory == null) {
            return null;
        }
        File homeFile = new File(homeDirectory);
        if (!homeFile.isDirectory()) {
            return null;
        }
        return new File(homeFile, ".pentaho/caches/prd-samples");
    }

    protected static String safeSystemGetProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    protected static boolean isCacheValid(HashMap cachedSeenFiles) {
        for (Map.Entry entry : cachedSeenFiles.entrySet()) {
            String fullFileName = (String)entry.getKey();
            SampleReport fontFileRecord = (SampleReport)entry.getValue();
            File fontFile = new File(fullFileName);
            if (!fontFile.isFile() || !fontFile.exists()) {
                return false;
            }
            if (fontFile.length() != fontFileRecord.getFileSize()) {
                return false;
            }
            if (fontFile.lastModified() == fontFileRecord.getLastAccessTime()) continue;
            return false;
        }
        return true;
    }

    static {
        DIRECTORY_FILTER = new DirectoryFileFilter();
        REPORT_FILES_FILTER = new FilesystemFilter(new String[]{".report", ".prpt"}, "", false);
    }

    public static class SampleNode
    extends DefaultMutableTreeNode {
        private String fileName;

        public SampleNode(String lbl, String file) {
            super(file);
            this.fileName = lbl;
        }

        @Override
        public String toString() {
            return this.fileName;
        }
    }

    private static class DirectoryFileFilter
    implements FileFilter {
        private DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.getName().length() > 0 && file.getName().charAt(0) == '.') {
                return false;
            }
            return file.isDirectory();
        }
    }

    private static class DirectoryNode
    extends DefaultMutableTreeNode {
        private DirectoryNode(Object userObject) {
            super(userObject);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }
}

