/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;

public class UndoManager
implements Serializable {
    private static final Log LOG = LogFactory.getLog(UndoManager.class);
    private static final int MAXIMUM_UNDO_SIZE = 5000;
    private transient EventListenerList undoListeners = new EventListenerList();
    private ArrayList<UndoRecord> undos = new ArrayList(5000);
    private ArrayList<String> undoNames = new ArrayList(5000);
    private int offset;

    public void addChange(String undoName, UndoEntry entry) {
        UndoEntry merged;
        UndoRecord lastRecord;
        while (this.offset < this.undos.size()) {
            this.undos.remove(this.undos.size() - 1);
            this.undoNames.remove(this.undoNames.size() - 1);
        }
        if (this.offset > 0 && (lastRecord = this.undos.get(this.offset - 1)).isNear(System.currentTimeMillis()) && (merged = lastRecord.getEntry().merge(entry)) != null) {
            this.undos.set(this.offset - 1, new UndoRecord(merged));
            this.undoNames.set(this.offset - 1, undoName);
            this.fireChangeEvent();
            return;
        }
        this.undos.add(new UndoRecord(entry));
        this.undoNames.add(undoName);
        this.offset = this.undos.size();
        while (this.undos.size() > 5000) {
            this.removeLastRecord();
        }
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        ChangeListener[] changeListeners = (ChangeListener[])this.undoListeners.getListeners(ChangeListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener listener = changeListeners[i];
            listener.stateChanged(event);
        }
    }

    private void removeLastRecord() {
        this.undos.remove(0);
        this.undoNames.remove(0);
    }

    public String getUndoName() {
        if (this.offset == 0) {
            return null;
        }
        String name = this.undoNames.get(this.offset - 1);
        return name;
    }

    public String getRedoName() {
        if (this.undos.isEmpty()) {
            return null;
        }
        if (this.offset == this.undos.size()) {
            return null;
        }
        String name = this.undoNames.get(this.offset);
        return name;
    }

    public void undo(ReportDocumentContext context) {
        if (this.offset == 0) {
            return;
        }
        UndoRecord record = this.undos.get(this.offset - 1);
        --this.offset;
        record.getEntry().undo(context);
        this.fireChangeEvent();
    }

    public void redo(ReportDocumentContext context) {
        if (this.undos.isEmpty()) {
            return;
        }
        if (this.offset == this.undos.size()) {
            return;
        }
        UndoRecord record = this.undos.get(this.offset);
        ++this.offset;
        record.getEntry().redo(context);
        this.fireChangeEvent();
    }

    public boolean isUndoPossible() {
        return this.offset > 0;
    }

    public void removeUndoListener(ChangeListener undoAction) {
        this.undoListeners.remove(ChangeListener.class, undoAction);
    }

    public void addUndoListener(ChangeListener undoAction) {
        this.undoListeners.add(ChangeListener.class, undoAction);
    }

    public boolean isRedoPossible() {
        return this.offset < this.undos.size();
    }

    private static class UndoRecord
    implements Serializable {
        private static final int UNDO_THREASHOLD = 250;
        private long timestamp;
        private UndoEntry entry;

        private UndoRecord(UndoEntry entry) {
            if (entry == null) {
                throw new NullPointerException();
            }
            this.timestamp = System.currentTimeMillis();
            this.entry = entry;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public UndoEntry getEntry() {
            return this.entry;
        }

        public boolean isNear(long time) {
            return Math.abs(this.timestamp - time) < 250L;
        }
    }
}

