/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class StyleExpressionEditUndoEntry
implements UndoEntry {
    private InstanceID target;
    private StyleKey styleKey;
    private Expression newValue;
    private Expression oldValue;

    public StyleExpressionEditUndoEntry(InstanceID target, StyleKey styleKey, Expression oldValue, Expression newValue) {
        this.target = target;
        this.styleKey = styleKey;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        ReportElement elementById = ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.setStyleExpression(this.styleKey, this.oldValue);
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        ReportElement elementById = ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.setStyleExpression(this.styleKey, this.newValue);
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        if (!(newEntry instanceof StyleExpressionEditUndoEntry)) {
            return null;
        }
        StyleExpressionEditUndoEntry entry = (StyleExpressionEditUndoEntry)newEntry;
        if (entry.target == this.target && ObjectUtilities.equal((Object)entry.styleKey, (Object)this.styleKey)) {
            return newEntry;
        }
        return null;
    }
}

