/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ElementFormatUndoEntry
extends MassElementStyleUndoEntry {
    private Expression[][] oldExpressions;
    private Expression[][] newExpressions;

    public ElementFormatUndoEntry(InstanceID[] elements, Object[][] oldStyleData, Object[][] newStyleData, Expression[][] oldExpressions, Expression[][] newExpressions) {
        super(elements, oldStyleData, newStyleData);
        this.oldExpressions = oldExpressions;
        this.newExpressions = newExpressions;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        super.undo(renderContext);
        AbstractReportDefinition reportDefinition = renderContext.getReportDefinition();
        StyleKey[] keys = StyleKey.getDefinedStyleKeys();
        InstanceID[] visualElements = this.getVisualElements();
        for (int i = 0; i < visualElements.length; ++i) {
            InstanceID visualElement = visualElements[i];
            ReportElement element = ModelUtility.findElementById(reportDefinition, visualElement);
            Expression[] properties = this.oldExpressions[i];
            for (int j = 0; j < keys.length; ++j) {
                StyleKey key = keys[j];
                element.setStyleExpression(key, properties[key.identifier]);
            }
        }
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        super.redo(renderContext);
        AbstractReportDefinition reportDefinition = renderContext.getReportDefinition();
        StyleKey[] keys = StyleKey.getDefinedStyleKeys();
        InstanceID[] visualElements = this.getVisualElements();
        for (int i = 0; i < visualElements.length; ++i) {
            InstanceID visualElement = visualElements[i];
            ReportElement element = ModelUtility.findElementById(reportDefinition, visualElement);
            Expression[] properties = this.newExpressions[i];
            for (int j = 0; j < keys.length; ++j) {
                StyleKey key = keys[j];
                element.setStyleExpression(key, properties[key.identifier]);
            }
        }
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }

    public static Expression[] computeExpressions(ReportElement visualElement) {
        Map expressions = visualElement.getStyleExpressions();
        StyleKey[] keys = expressions.keySet().toArray(new StyleKey[expressions.size()]);
        Expression[] retval = new Expression[StyleKey.getDefinedStyleKeyCount()];
        for (int i = 0; i < keys.length; ++i) {
            Expression styleExpression;
            StyleKey styleKey = keys[i];
            if (styleKey == null || (styleExpression = visualElement.getStyleExpression(styleKey)) == null) continue;
            retval[styleKey.identifier] = styleExpression;
        }
        return retval;
    }

    public static class EditResult {
        private ElementStyleSheet styleSheet;
        private Map<StyleKey, Expression> styleExpressions;

        public EditResult(ElementStyleSheet styleSheet, Map<StyleKey, Expression> styleExpressions) {
            this.styleSheet = styleSheet;
            if (styleExpressions != null) {
                this.styleExpressions = Collections.unmodifiableMap(styleExpressions);
            }
        }

        public ElementStyleSheet getStyleSheet() {
            return this.styleSheet;
        }

        public Map getStyleExpressions() {
            if (this.styleExpressions != null) {
                return Collections.unmodifiableMap(this.styleExpressions);
            }
            return Collections.EMPTY_MAP;
        }

        public ElementFormatUndoEntry process(List<Element> visualElements) {
            return this.process(visualElements.toArray(new Element[visualElements.size()]));
        }

        public ElementFormatUndoEntry process(Element[] visualElements) {
            Object[][] oldStyleData = new Object[visualElements.length][];
            Expression[][] oldExpressions = new Expression[visualElements.length][];
            for (int i = 0; i < visualElements.length; ++i) {
                Element visualElement = visualElements[i];
                oldStyleData[i] = MassElementStyleUndoEntryBuilder.computeStyleChangeSet((ReportElement)visualElement);
                oldExpressions[i] = ElementFormatUndoEntry.computeExpressions((ReportElement)visualElement);
            }
            ElementStyleSheet editableStyleSheet = this.getStyleSheet();
            StyleKey[] definedKeys = editableStyleSheet.getDefinedPropertyNamesArray();
            for (int i = 0; i < definedKeys.length; ++i) {
                StyleKey key = definedKeys[i];
                if (key == null) continue;
                Object value = editableStyleSheet.getStyleProperty(key);
                for (int j = 0; j < visualElements.length; ++j) {
                    Element element = visualElements[j];
                    ElementStyleSheet elementStyleSheet = element.getStyle();
                    if (ObjectUtilities.equal((Object)value, (Object)elementStyleSheet.getStyleProperty(key))) continue;
                    elementStyleSheet.setStyleProperty(key, value);
                }
            }
            Map resultExpressions = this.getStyleExpressions();
            for (Map.Entry entry : resultExpressions.entrySet()) {
                StyleKey key = (StyleKey)entry.getKey();
                Expression value = (Expression)entry.getValue();
                for (int j = 0; j < visualElements.length; ++j) {
                    Element element = visualElements[j];
                    if (ObjectUtilities.equal((Object)value, (Object)element.getStyleExpression(key))) continue;
                    if (value != null) {
                        element.setStyleExpression(key, value.getInstance());
                        continue;
                    }
                    element.setStyleExpression(key, null);
                }
            }
            Object[][] newStyleData = new Object[visualElements.length][];
            Expression[][] newExpressions = new Expression[visualElements.length][];
            InstanceID[] ids = new InstanceID[visualElements.length];
            for (int i = 0; i < visualElements.length; ++i) {
                Element visualElement = visualElements[i];
                newStyleData[i] = MassElementStyleUndoEntryBuilder.computeStyleChangeSet((ReportElement)visualElement);
                newExpressions[i] = ElementFormatUndoEntry.computeExpressions((ReportElement)visualElement);
                ids[i] = visualElement.getObjectID();
                visualElement.notifyNodePropertiesChanged();
            }
            return new ElementFormatUndoEntry(ids, oldStyleData, newStyleData, oldExpressions, newExpressions);
        }
    }
}

