/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class AttributeExpressionEditUndoEntry
implements UndoEntry {
    private InstanceID target;
    private String attributeNamespace;
    private String attributeName;
    private Expression newValue;
    private Expression oldValue;

    public AttributeExpressionEditUndoEntry(InstanceID target, String attributeNamespace, String attributeName, Expression oldValue, Expression newValue) {
        this.target = target;
        this.attributeNamespace = attributeNamespace;
        this.attributeName = attributeName;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        ReportElement elementById = ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.setAttributeExpression(this.attributeNamespace, this.attributeName, this.oldValue);
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        ReportElement elementById = ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.setAttributeExpression(this.attributeNamespace, this.attributeName, this.newValue);
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        if (!(newEntry instanceof AttributeExpressionEditUndoEntry)) {
            return null;
        }
        AttributeExpressionEditUndoEntry entry = (AttributeExpressionEditUndoEntry)newEntry;
        if (entry.target == this.target && ObjectUtilities.equal((Object)entry.attributeNamespace, (Object)this.attributeNamespace) && ObjectUtilities.equal((Object)entry.attributeName, (Object)this.attributeName)) {
            return newEntry;
        }
        return null;
    }
}

