/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.table.ResourcePropertyEditorComponent;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ClassicEngineFactoryParameters;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.AdvancedPropertyEditor;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class ResourcePropertyEditor
implements AdvancedPropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ResourcePropertyEditorComponent editorComponent;
    private Object currentValue;

    public ResourcePropertyEditor(ReportDocumentContext reportRenderContext) {
        this.editorComponent = new ResourcePropertyEditorComponent(reportRenderContext);
        this.editorComponent.addPropertyChangeListener(new ComponentChangeListener());
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object newValue) {
        if (ObjectUtilities.equal((Object)newValue, (Object)this.currentValue)) {
            return;
        }
        Object oldValue = this.currentValue;
        this.currentValue = newValue;
        this.editorComponent.setValue(this.currentValue);
        this.propertyChangeSupport.firePropertyChange(null, oldValue, newValue);
    }

    public Object getValue() {
        return this.editorComponent.getValue();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof ResourceKey) {
            ResourceKey resourceKey = (ResourceKey)value;
            Object source = resourceKey.getFactoryParameters().get(ClassicEngineFactoryParameters.ORIGINAL_VALUE);
            if (source != null) {
                return String.valueOf(source);
            }
            return resourceKey.getIdentifierAsString();
        }
        return value.toString();
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this.editorComponent;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public boolean supportsText() {
        return false;
    }

    private class ComponentChangeListener
    implements PropertyChangeListener {
        private ComponentChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = ResourcePropertyEditor.this.currentValue;
            ResourcePropertyEditor.this.currentValue = ResourcePropertyEditor.this.editorComponent.getValue();
            if (!ObjectUtilities.equal((Object)oldValue, (Object)ResourcePropertyEditor.this.currentValue)) {
                ResourcePropertyEditor.this.propertyChangeSupport.firePropertyChange(null, oldValue, ResourcePropertyEditor.this.currentValue);
            }
        }
    }
}

