/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.util.table.GroupedName;

public class GroupedNameCellEditor
extends DefaultCellEditor {
    private transient GroupedName value;
    private transient GroupedName originalValue;

    public GroupedNameCellEditor() {
        super(new JTextField());
        this.getComponent().setName("Table.editor");
    }

    @Override
    public boolean stopCellEditing() {
        String s = (String)super.getCellEditorValue();
        if ("".equals(s)) {
            return super.stopCellEditing();
        }
        try {
            this.value = this.originalValue != null ? new GroupedName(this.originalValue.getMetaData(), s, this.originalValue.getGroupName()) : new GroupedName(null, s, "");
        }
        catch (Exception e) {
            JComponent editorComponent = (JComponent)this.getComponent();
            editorComponent.setBorder(new LineBorder(Color.red));
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        if (value instanceof GroupedName) {
            this.originalValue = (GroupedName)value;
            if (column == 0 && isSelected && String.valueOf(this.originalValue.getName()).compareTo(Messages.getString("DrillDownParameterTable.Parameter.DefaultName", new Object[0])) == 0) {
                this.originalValue.setName("");
            }
            return super.getTableCellEditorComponent(table, this.originalValue.getName(), isSelected, row, column);
        }
        this.originalValue = null;
        return super.getTableCellEditorComponent(table, null, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }
}

