/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.table.ArrayAccessUtility;
import org.pentaho.reporting.designer.core.util.table.ArrayCellEditorDialog;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ArrayCellEditor
extends JComponent
implements TableCellEditor,
DesignerContextComponent {
    private static final String POPUP_EDITOR = "popupEditor";
    private JTextField textField;
    private JButton ellipsisButton;
    private EventListenerList eventListenerList;
    private boolean nullable;
    private Object array;
    private Class arrayType;
    private ReportDesignerContext reportDesignerContext;
    private String valueRole;
    private Class propertyEditorType;
    private String[] extraFields;

    public ArrayCellEditor() {
        this.setLayout(new BorderLayout());
        this.eventListenerList = new EventListenerList();
        this.ellipsisButton = new EllipsisButton("...");
        this.ellipsisButton.setDefaultCapable(false);
        this.ellipsisButton.addActionListener(new ExtendedEditorAction());
        this.textField = new JTextField();
        this.textField.setDocument(new NonFilteringPlainDocument());
        this.textField.getInputMap().put(UtilMessages.getInstance().getKeyStroke("PropertyCellEditorWithEllipsis.PopupEditor.Accelerator"), POPUP_EDITOR);
        this.textField.getActionMap().put(POPUP_EDITOR, new ExtendedEditorAction());
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setEditable(false);
        this.add((Component)this.textField, "Center");
        this.add((Component)this.ellipsisButton, "East");
        this.nullable = false;
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
    }

    protected Object getArray() {
        return this.array;
    }

    protected void setArray(Object array, Class arrayType, String valueRole, String[] extraFields) {
        this.extraFields = (String[])extraFields.clone();
        this.valueRole = valueRole;
        this.array = array;
        if (!ArrayAccessUtility.isArray(array)) {
            if (arrayType.isArray()) {
                this.arrayType = arrayType;
                this.textField.setText("");
                this.ellipsisButton.setEnabled(true);
            } else {
                this.arrayType = null;
                this.textField.setText("");
                this.ellipsisButton.setEnabled(false);
            }
        } else {
            this.arrayType = arrayType.isArray() ? arrayType : array.getClass();
            this.textField.setText(ArrayAccessUtility.getArrayAsString(array));
            this.ellipsisButton.setEnabled(true);
        }
    }

    public String getValueRole() {
        return this.valueRole;
    }

    public Class getArrayType() {
        return this.arrayType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void setPropertyEditorType(Class aPropertyEditor) {
        this.propertyEditorType = aPropertyEditor;
    }

    protected JTextField getTextField() {
        return this.textField;
    }

    protected JButton getEllipsisButton() {
        return this.ellipsisButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.array;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.fireEditingStopped();
            this.textField.setText(null);
            return true;
        }
        catch (Exception e) {
            this.fireEditingCanceled();
            this.textField.setText(null);
            return true;
        }
    }

    @Override
    public void cancelCellEditing() {
        this.textField.setText(null);
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        TableModel tableModel = table.getModel();
        if (tableModel instanceof ElementMetaDataTableModel) {
            ElementMetaDataTableModel metaDataTableModel = (ElementMetaDataTableModel)tableModel;
            int realColumn = table.convertColumnIndexToModel(column);
            Class classForCell = metaDataTableModel.getClassForCell(row, realColumn);
            String valueRole = metaDataTableModel.getValueRole(row, realColumn);
            String[] extraFields = metaDataTableModel.getExtraFields(row, realColumn);
            this.setArray(value, classForCell, valueRole, extraFields);
        } else {
            Class<?> columnClass = table.getColumnClass(column);
            this.setArray(value, columnClass, null, new String[0]);
        }
        return this;
    }

    private class ExtendedEditorAction
    extends AbstractAction {
        private ExtendedEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ArrayCellEditor.this.getArrayType() == null) {
                return;
            }
            Object value = ArrayCellEditor.this.getArray();
            Window window = LibSwingUtil.getWindowAncestor((Component)ArrayCellEditor.this);
            ArrayCellEditorDialog editorDialog = window instanceof Frame ? new ArrayCellEditorDialog((Frame)window) : (window instanceof Dialog ? new ArrayCellEditorDialog((Dialog)window) : new ArrayCellEditorDialog());
            editorDialog.setReportDesignerContext(ArrayCellEditor.this.getReportDesignerContext());
            Object o = editorDialog.editArray(value, ArrayCellEditor.this.getArrayType(), ArrayCellEditor.this.getValueRole(), ArrayCellEditor.this.propertyEditorType, ArrayCellEditor.this.extraFields);
            if (o != null) {
                ArrayCellEditor.this.array = o;
                ArrayCellEditor.this.stopCellEditing();
            } else {
                ArrayCellEditor.this.cancelCellEditing();
            }
        }
    }

    private static class NonFilteringPlainDocument
    implements Document {
        private PlainDocument backend = new PlainDocument();

        private NonFilteringPlainDocument() {
        }

        @Override
        public int getLength() {
            return this.backend.getLength();
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            this.backend.addDocumentListener(listener);
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            this.backend.removeDocumentListener(listener);
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            this.backend.addUndoableEditListener(listener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            this.backend.removeUndoableEditListener(listener);
        }

        @Override
        public Object getProperty(Object key) {
            return this.backend.getProperty(key);
        }

        @Override
        public void putProperty(Object key, Object value) {
            if ("filterNewlines".equals(key)) {
                return;
            }
            this.backend.putProperty(key, value);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            this.backend.remove(offs, len);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            this.backend.insertString(offset, str, a);
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return this.backend.getText(offset, length);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            this.backend.getText(offset, length, txt);
        }

        @Override
        public Position getStartPosition() {
            return this.backend.getStartPosition();
        }

        @Override
        public Position getEndPosition() {
            return this.backend.getEndPosition();
        }

        @Override
        public Position createPosition(int offs) throws BadLocationException {
            return this.backend.createPosition(offs);
        }

        @Override
        public Element[] getRootElements() {
            return this.backend.getRootElements();
        }

        @Override
        public Element getDefaultRootElement() {
            return this.backend.getDefaultRootElement();
        }

        @Override
        public void render(Runnable r) {
            this.backend.render(r);
        }
    }
}

