/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    private static final int OFFSET_1 = 20;
    private static final int OFFSET_2 = 30;
    private static final int OFFSET_3 = 40;

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 4, 4);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color base = c.getBackground();
        if (base == null) {
            base = SystemColor.controlShadow;
        }
        Color col3 = new Color(base.getRed() - 20, base.getGreen() - 20, base.getBlue() - 20);
        Color col2 = new Color(base.getRed() - 30, base.getGreen() - 30, base.getBlue() - 30);
        Color col1 = new Color(base.getRed() - 40, base.getGreen() - 40, base.getBlue() - 40);
        g.setColor(col3);
        g.drawLine(x + width - 4, y, x + width - 3, y);
        g.drawLine(x, y + height - 4, x, y + height - 3);
        g.drawLine(x + 1, y + height - 2, x + width - 3, y + height - 2);
        g.drawLine(x + width - 3, y + height - 3, x + width - 3, y + height - 3);
        g.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 3);
        g.setColor(col2);
        g.drawLine(x + width - 5, y, x + width - 4, y);
        g.drawLine(x, y + height - 5, x, y + height - 4);
        g.drawLine(x + 1, y + height - 3, x + width - 4, y + height - 3);
        g.drawLine(x + width - 3, y + 1, x + width - 3, y + height - 4);
        g.setColor(col1);
        g.drawLine(x, y, x + width - 5, y);
        g.drawLine(x, y, x, y + height - 5);
        g.drawLine(x + 1, y + height - 4, x + width - 4, y + height - 4);
        g.drawLine(x + width - 4, y + 1, x + width - 4, y + height - 4);
    }
}

