/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.docking;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.StyleContext;
import org.pentaho.reporting.designer.core.util.docking.GlobalPane;

public class ImageToggleButton
extends JToggleButton {
    private ImageIcon imageIcon;
    private String text;
    private GlobalPane.Alignment alignment;

    public ImageToggleButton(ImageIcon icon, String text) {
        this(icon, text, GlobalPane.Alignment.LEFT);
    }

    public ImageToggleButton(ImageIcon icon, String text, GlobalPane.Alignment alignment) {
        this.imageIcon = icon;
        this.text = text;
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setFont(StyleContext.getDefaultStyleContext().getFont(this.getFont().getName(), 0, 10));
        this.setAlignmentX(alignment);
        this.setFocusable(false);
    }

    @Override
    public String getUIClassID() {
        return "ImageToggleButton";
    }

    public void setAlignmentX(GlobalPane.Alignment alignment) {
        this.alignment = alignment;
        switch (alignment) {
            case TOP: 
            case BOTTOM: {
                ImageIcon icon = ImageToggleButton.createRotatedTextIcon(this.getForeground(), 0, this.getFont(), this.text);
                icon = ImageToggleButton.createComposedImageIcon(this.imageIcon, icon, FirstIconAlignment.LEFT);
                ImageIcon normalIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), false, false);
                ImageIcon selectedIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), true, false);
                ImageIcon selectedRolloverIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), true, true);
                ImageIcon rolloverIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), false, true);
                this.setIcon(normalIcon);
                this.setSelectedIcon(selectedIcon);
                this.setRolloverSelectedIcon(selectedRolloverIcon);
                this.setRolloverIcon(rolloverIcon);
                break;
            }
            case LEFT: {
                ImageIcon icon = ImageToggleButton.createRotatedTextIcon(this.getForeground(), 2, this.getFont(), this.text);
                icon = ImageToggleButton.createComposedImageIcon(this.imageIcon, icon, FirstIconAlignment.BOTTOM);
                ImageIcon normalIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), false, false);
                ImageIcon selectedIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), true, false);
                ImageIcon selectedRolloverIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), true, true);
                ImageIcon rolloverIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), false, true);
                this.setIcon(normalIcon);
                this.setSelectedIcon(selectedIcon);
                this.setRolloverSelectedIcon(selectedRolloverIcon);
                this.setRolloverIcon(rolloverIcon);
                break;
            }
            case RIGHT: {
                ImageIcon icon = ImageToggleButton.createRotatedTextIcon(this.getForeground(), 1, this.getFont(), this.text);
                icon = ImageToggleButton.createComposedImageIcon(this.imageIcon, icon, FirstIconAlignment.TOP);
                ImageIcon normalIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), false, false);
                ImageIcon selectedIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), true, false);
                ImageIcon selectedRolloverIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), true, true);
                ImageIcon rolloverIcon = ImageToggleButton.createButtonImageIcon(icon, new Insets(3, 3, 3, 3), false, true);
                this.setIcon(normalIcon);
                this.setSelectedIcon(selectedIcon);
                this.setRolloverSelectedIcon(selectedRolloverIcon);
                this.setRolloverIcon(rolloverIcon);
                break;
            }
        }
    }

    private static ImageIcon createComposedImageIcon(ImageIcon firstIcon, ImageIcon secondIcon, FirstIconAlignment firstIconAlignment) {
        if (firstIcon == null && secondIcon == null) {
            return null;
        }
        if (firstIcon == null) {
            return secondIcon;
        }
        if (secondIcon == null) {
            return firstIcon;
        }
        switch (firstIconAlignment) {
            case TOP: {
                int width = Math.max(firstIcon.getIconWidth(), secondIcon.getIconWidth());
                int height = firstIcon.getIconHeight() + secondIcon.getIconHeight();
                BufferedImage bi = new BufferedImage(width, height, 2);
                Graphics graphics = bi.getGraphics();
                graphics.drawImage(firstIcon.getImage(), (width - firstIcon.getIconWidth()) / 2, 0, null);
                graphics.drawImage(secondIcon.getImage(), (width - secondIcon.getIconWidth()) / 2, firstIcon.getIconHeight(), null);
                return new ImageIcon(bi);
            }
            case BOTTOM: {
                int width = Math.max(firstIcon.getIconWidth(), secondIcon.getIconWidth());
                int height = firstIcon.getIconHeight() + secondIcon.getIconHeight();
                BufferedImage bi = new BufferedImage(width, height, 2);
                Graphics graphics = bi.getGraphics();
                graphics.drawImage(firstIcon.getImage(), (width - firstIcon.getIconWidth()) / 2, height - firstIcon.getIconHeight(), null);
                graphics.drawImage(secondIcon.getImage(), (width - secondIcon.getIconWidth()) / 2, 0, null);
                return new ImageIcon(bi);
            }
            case LEFT: {
                int width = firstIcon.getIconWidth() + secondIcon.getIconWidth();
                int height = Math.max(firstIcon.getIconHeight(), secondIcon.getIconHeight());
                BufferedImage bi = new BufferedImage(width, height, 2);
                Graphics graphics = bi.getGraphics();
                graphics.drawImage(firstIcon.getImage(), 0, (height - firstIcon.getIconHeight()) / 2, null);
                graphics.drawImage(secondIcon.getImage(), firstIcon.getIconWidth(), (height - secondIcon.getIconHeight()) / 2, null);
                return new ImageIcon(bi);
            }
            case RIGHT: {
                int width = firstIcon.getIconWidth() + secondIcon.getIconWidth();
                int height = Math.max(firstIcon.getIconHeight(), secondIcon.getIconHeight());
                BufferedImage bi = new BufferedImage(width, height, 2);
                Graphics graphics = bi.getGraphics();
                graphics.drawImage(firstIcon.getImage(), secondIcon.getIconWidth(), (height - firstIcon.getIconHeight()) / 2, null);
                graphics.drawImage(secondIcon.getImage(), 0, (height - secondIcon.getIconHeight()) / 2, null);
                return new ImageIcon(bi);
            }
        }
        return new ImageIcon();
    }

    private static ImageIcon createButtonImageIcon(ImageIcon icon, Insets insets, boolean selected, boolean rollover) {
        int b;
        int o;
        int w = icon.getIconWidth() + insets.left + insets.right;
        int h = icon.getIconHeight() + insets.top + insets.bottom;
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (selected) {
            o = -5;
            b = 40;
            if (rollover) {
                b = 60;
            }
            GradientPaint gp = new GradientPaint(0.0f, -5.0f, new Color(Math.min(164 + b, 255), Math.min(166 + b, 255), Math.min(172 + b, 255)), 0.0f, h + -5, new Color(Math.min(189 + b, 255), Math.min(192 + b, 255), Math.min(198 + b, 255)), true);
            g.setPaint(gp);
        } else {
            o = -5;
            b = 0;
            if (rollover) {
                b = 60;
            }
            GradientPaint gp = new GradientPaint(0.0f, -5.0f, new Color(Math.min(251 + b, 255), Math.min(251 + b, 255), Math.min(252 + b, 255)), 0.0f, h + -5, new Color(Math.min(215 + b, 255), Math.min(218 + b, 255), Math.min(224 + b, 255)), true);
            g.setPaint(gp);
        }
        RoundRectangle2D.Double roundRectangle2D = new RoundRectangle2D.Double(0.0, 0.0, w - 1, h - 1, 6.0, 6.0);
        g.fill(roundRectangle2D);
        if (selected) {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, new Color(Math.min(125, 255), Math.min(127, 255), Math.min(131, 255)), 0.0f, h, new Color(Math.min(162, 255), Math.min(164, 255), Math.min(169, 255)), true);
            g.setPaint(gp);
        } else {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, new Color(Math.min(149, 255), Math.min(155, 255), Math.min(158, 255)), 0.0f, h, new Color(Math.min(85, 255), Math.min(88, 255), Math.min(94, 255)), true);
            g.setPaint(gp);
        }
        g.draw(roundRectangle2D);
        g.drawImage(icon.getImage(), insets.left, insets.top, null);
        return new ImageIcon(bi);
    }

    private static ImageIcon createRotatedTextIcon(Color foreground, int rotate, Font font, String text) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        GlyphVector glyphs = font.createGlyphVector(fontRenderContext, text);
        int width = (int)glyphs.getLogicalBounds().getWidth() + 4;
        LineMetrics lineMetrics = font.getLineMetrics(text, fontRenderContext);
        float ascent = lineMetrics.getAscent();
        int height = (int)Math.ceil(lineMetrics.getHeight());
        int w = rotate == 1 || rotate == 2 ? height : width;
        int h = rotate == 1 || rotate == 2 ? width : height;
        BufferedImage bufferedImage = new BufferedImage(w, h, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setFont(font);
        AffineTransform oldTransform = g2d.getTransform();
        g2d.setColor(foreground);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (rotate == 0) {
            g2d.drawString(text, 2.0f, ascent);
        } else if (rotate == 1) {
            AffineTransform trans = new AffineTransform();
            trans.concatenate(oldTransform);
            trans.translate(0.0, 2.0);
            trans.rotate(1.5707963267948966, height / 2, width / 2);
            g2d.setTransform(trans);
            g2d.drawString(text, (float)((height - width) / 2), (float)((width - height) / 2) + ascent);
        } else if (rotate == 2) {
            AffineTransform trans = new AffineTransform();
            trans.concatenate(oldTransform);
            trans.translate(0.0, -2.0);
            trans.rotate(4.71238898038469, height / 2, width / 2);
            g2d.setTransform(trans);
            g2d.drawString(text, (float)((height - width) / 2), (float)((width - height) / 2) + ascent);
        }
        return new ImageIcon(bufferedImage);
    }

    @Override
    public void setUI(ButtonUI ui) {
        super.setUI(ui);
        if (this.alignment != null) {
            this.setAlignmentX(this.alignment);
        }
    }

    static {
        UIManager.put("ImageToggleButton", "javax.swing.plaf.basic.BasicToggleButtonUI");
    }

    private static class RotateTextIcon {
        public static final int NONE = 0;
        public static final int CW = 1;
        public static final int CCW = 2;

        private RotateTextIcon() {
        }
    }

    private static enum FirstIconAlignment {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

