/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionEvent;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionListener;

public abstract class SidePanel
extends JPanel
implements DesignerContextComponent {
    private ReportDesignerContext reportDesignerContext;
    private ActiveContextChangeHandler contextChangeHandler = new ActiveContextChangeHandler();
    private SelectionHandler selectionHandler = new SelectionHandler();

    protected SidePanel() {
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        ReportDesignerContext oldContext = this.reportDesignerContext;
        this.reportDesignerContext = reportDesignerContext;
        this.updateDesignerContext(oldContext, reportDesignerContext);
    }

    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        ReportDocumentContext newRenderContext;
        ReportDocumentContext oldRenderContext;
        if (oldContext != null) {
            oldContext.removePropertyChangeListener("activeContext", this.contextChangeHandler);
            oldRenderContext = oldContext.getActiveContext();
        } else {
            oldRenderContext = null;
        }
        if (newContext != null) {
            newContext.addPropertyChangeListener("activeContext", this.contextChangeHandler);
            newRenderContext = newContext.getActiveContext();
        } else {
            newRenderContext = null;
        }
        this.updateActiveContext(oldRenderContext, newRenderContext);
    }

    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        if (oldContext != null) {
            oldContext.getSelectionModel().removeReportSelectionListener(this.selectionHandler);
        }
        if (newContext != null) {
            newContext.getSelectionModel().addReportSelectionListener(this.selectionHandler);
            this.updateSelection(newContext.getSelectionModel());
        }
        this.setEnabled(newContext != null);
    }

    protected void updateSelection(DocumentContextSelectionModel model) {
    }

    private class SelectionHandler
    implements ReportSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void selectionAdded(ReportSelectionEvent event) {
            SidePanel.this.updateSelection(event.getModel());
        }

        @Override
        public void selectionRemoved(ReportSelectionEvent event) {
            SidePanel.this.updateSelection(event.getModel());
        }

        @Override
        public void leadSelectionChanged(ReportSelectionEvent event) {
        }
    }

    private class ActiveContextChangeHandler
    implements PropertyChangeListener {
        private ActiveContextChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SidePanel.this.updateActiveContext((ReportDocumentContext)evt.getOldValue(), (ReportDocumentContext)evt.getNewValue());
        }
    }
}

