/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Color;
import java.util.LinkedHashSet;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorSchema;

public class ReportColorSchema
implements ColorSchema {
    private LinkedHashSet<Color> colors = new LinkedHashSet();

    public ReportColorSchema(AbstractReportDefinition reportDefinition) {
        this.collectColors(reportDefinition);
    }

    private void collectColors(AbstractReportDefinition def) {
        Expression[] expressions;
        for (Expression expression : expressions = def.getExpressions().getExpressions()) {
            this.collectColorFromExpressions(expression);
        }
        this.collectColorFromSection((Section)def);
    }

    private void collectColorFromExpressions(Expression expression) {
        try {
            BeanUtility beanUtility = new BeanUtility((Object)expression);
            String[] propertyNames = beanUtility.getProperties();
            for (int i = 0; i < propertyNames.length; ++i) {
                try {
                    Object property;
                    String key = propertyNames[i];
                    Class propertyType = beanUtility.getPropertyType(key);
                    if (!Color.class.isAssignableFrom(propertyType) || !((property = beanUtility.getProperty(key)) instanceof Color)) continue;
                    this.colors.add((Color)property);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void collectColorFromSection(Section section) {
        this.collectColorFromElement((ReportElement)section);
        for (ReportElement element : section) {
            if (element instanceof Section) {
                this.collectColorFromSection((Section)element);
                continue;
            }
            this.collectColorFromElement(element);
        }
        if (section instanceof RootLevelBand) {
            SubReport[] subReports;
            RootLevelBand b = (RootLevelBand)section;
            for (SubReport subReport : subReports = b.getSubReports()) {
                this.collectColorFromSection((Section)subReport);
            }
        }
    }

    private void collectColorFromElement(ReportElement element) {
        AttributeMetaData[] attributeDescriptions;
        StyleKey[] propertyKeys;
        ElementStyleSheet style = element.getStyle();
        for (StyleKey propertyKey : propertyKeys = style.getPropertyKeys()) {
            Expression styleExpression;
            if (!Color.class.isAssignableFrom(propertyKey.getValueType())) continue;
            Color styleProperty = (Color)style.getStyleProperty(propertyKey);
            if (styleProperty != null) {
                this.colors.add(styleProperty);
            }
            if ((styleExpression = element.getStyleExpression(propertyKey)) == null) continue;
            this.collectColorFromExpressions(styleExpression);
        }
        for (AttributeMetaData attributeMetaData : attributeDescriptions = element.getMetaData().getAttributeDescriptions()) {
            Color styleProperty;
            Class targetType = attributeMetaData.getTargetType();
            if (Color.class.isAssignableFrom(targetType)) {
                Expression styleExpression;
                styleProperty = (Color)element.getAttribute(attributeMetaData.getNameSpace(), attributeMetaData.getName());
                if (styleProperty != null) {
                    this.colors.add(styleProperty);
                }
                if ((styleExpression = element.getAttributeExpression(attributeMetaData.getNameSpace(), attributeMetaData.getName())) == null) continue;
                this.collectColorFromExpressions(styleExpression);
                continue;
            }
            if (!Expression.class.isAssignableFrom(targetType) || (styleProperty = (Expression)element.getAttribute(attributeMetaData.getNameSpace(), attributeMetaData.getName())) == null) continue;
            this.collectColorFromExpressions((Expression)styleProperty);
        }
    }

    public Color[] getColors() {
        return this.colors.toArray(new Color[this.colors.size()]);
    }

    public String getName() {
        return UtilMessages.getInstance().getString("ReportColorSchema.Title");
    }
}

