/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ExpressionComboBoxEditor
implements ComboBoxEditor {
    private EventListenerList listenerList = new EventListenerList();
    private JTextField textField;
    private Object value;
    private String orginalText;

    public ExpressionComboBoxEditor() {
        this(false);
    }

    public ExpressionComboBoxEditor(boolean withBorder) {
        this.textField = withBorder ? new JTextField() : new BorderlessTextField();
        this.textField.setDisabledTextColor(this.textField.getForeground());
    }

    @Override
    public Component getEditorComponent() {
        return this.textField;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject instanceof FormulaExpression) {
            FormulaExpression fe = (FormulaExpression)anObject;
            this.value = fe;
            this.textField.setEnabled(true);
            this.textField.setText(fe.getFormula());
        } else if (anObject instanceof Expression) {
            this.value = anObject;
            this.textField.setEnabled(false);
            if (ExpressionRegistry.getInstance().isExpressionRegistered(this.value.getClass().getName())) {
                ExpressionMetaData data = ExpressionRegistry.getInstance().getExpressionMetaData(this.value.getClass().getName());
                this.textField.setText(data.getDisplayName(Locale.getDefault()));
            } else {
                this.textField.setText(this.value.getClass().getName());
            }
        } else if (anObject instanceof ExpressionMetaData) {
            ExpressionMetaData emd = (ExpressionMetaData)anObject;
            this.value = anObject;
            this.textField.setEnabled(false);
            this.textField.setText(emd.getDisplayName(Locale.getDefault()));
        } else if (anObject != null) {
            DebugLog.log((Object)("ExpressionComboBoxEditor: Invalid object encountered: " + anObject));
            this.value = null;
            this.textField.setEnabled(false);
            this.textField.setText("");
        } else {
            this.value = new FormulaExpression();
            this.textField.setEnabled(true);
            this.textField.setText("");
        }
        this.orginalText = this.textField.getText();
    }

    @Override
    public Object getItem() {
        if (this.value instanceof FormulaExpression) {
            String editorText = this.textField.getText();
            if (editorText.trim().length() == 0) {
                return null;
            }
            if (ObjectUtilities.equal((Object)this.orginalText, (Object)editorText)) {
                return this.value;
            }
            FormulaExpression ofe = (FormulaExpression)this.value;
            FormulaExpression fe = (FormulaExpression)ofe.getInstance();
            fe.setFormula(editorText);
            return fe;
        }
        return this.value;
    }

    @Override
    public void selectAll() {
        this.textField.requestFocus();
        this.textField.select(0, this.textField.getText().length());
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private static class BorderlessTextField
    extends JTextField {
        private BorderlessTextField() {
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public void setBorder(Border b) {
        }
    }
}

