/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.status.ExceptionDialog;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionModelListener;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ExceptionStatusGadget
extends JLabel
implements UncaughtExceptionModelListener {
    private boolean firstTime = true;
    private ExceptionDialog exceptionDialog;
    private ImageIcon errorIcon = IconLoader.getInstance().getErrorIcon();
    private ImageIcon noErrorIcon = IconLoader.getInstance().getNoErrorIcon();

    public ExceptionStatusGadget() {
        this.setHorizontalAlignment(0);
        this.setIcon(this.noErrorIcon);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseSelectionHandler());
        Window parent = LibSwingUtil.getWindowAncestor((Component)this);
        this.exceptionDialog = parent instanceof Frame ? new ExceptionDialog((Frame)parent) : (parent instanceof Dialog ? new ExceptionDialog((Dialog)parent) : new ExceptionDialog());
        UncaughtExceptionsModel.getInstance().addUncaughtExceptionModelListener(this);
    }

    protected void handleExceptionClick() {
        this.setIcon(IconLoader.getInstance().getNoErrorIcon());
        UncaughtExceptionsModel.getInstance().exceptionsViewed();
        this.exceptionDialog.showDialog();
    }

    @Override
    public void exceptionCaught(Throwable throwable) {
        if (this.firstTime) {
            Container rootPane;
            this.firstTime = false;
            for (rootPane = this.getParent(); rootPane != null && !(rootPane instanceof JRootPane); rootPane = rootPane.getParent()) {
            }
            if (rootPane != null) {
                JRootPane jRootPane = (JRootPane)rootPane;
                JLabel errorPopup = this.createPopup();
                jRootPane.getLayeredPane().add((Component)errorPopup, JLayeredPane.POPUP_LAYER);
                Rectangle rectangle = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), jRootPane.getLayeredPane());
                Dimension size = errorPopup.getPreferredSize();
                errorPopup.setBounds((int)(rectangle.getX() - (double)size.width), (int)(rectangle.getY() - (double)size.height), size.width, size.height);
                jRootPane.getLayeredPane().revalidate();
                jRootPane.getLayeredPane().repaint();
            }
        }
        if (this.getIcon() == this.noErrorIcon) {
            this.setIcon(this.errorIcon);
        }
        this.repaint();
    }

    private JLabel createPopup() {
        JLabel label = new JLabel(Messages.getString("StatusBar.InternalError.Message", new Object[0]));
        label.setForeground(new Color(120, 0, 0));
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        label.setBackground(new Color(255, 0, 0, 125));
        label.setOpaque(true);
        Timer t = new Timer(5000, new ClearErrorMessageAction(label));
        t.setRepeats(false);
        t.start();
        return label;
    }

    @Override
    public void exceptionsCleared() {
        this.firstTime = true;
        this.setIcon(IconLoader.getInstance().getNoErrorIcon());
    }

    @Override
    public void exceptionsViewed() {
        this.setIcon(IconLoader.getInstance().getNoErrorIcon());
    }

    private class MouseSelectionHandler
    extends MouseAdapter {
        private MouseSelectionHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent ex) {
            ExceptionStatusGadget.this.handleExceptionClick();
        }
    }

    private static class ClearErrorMessageAction
    implements ActionListener {
        private final JLabel label;

        private ClearErrorMessageAction(JLabel label) {
            this.label = label;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container container = this.label.getParent();
            if (container != null) {
                container.remove(this.label);
                container.repaint();
            }
        }
    }
}

