/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.prefs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public class BinaryPreferences
extends AbstractPreferences {
    private static final Log logger = LogFactory.getLog(BinaryPreferences.class);
    private Properties properties;
    private BinaryPreferences parent;
    private long lastModificationTime;
    private String rootPath;

    public BinaryPreferences(String rootPath) {
        super(null, "");
        this.rootPath = rootPath;
    }

    public BinaryPreferences(BinaryPreferences parent, String name) {
        super(parent, name);
        this.parent = parent;
        this.properties = new Properties();
    }

    @Override
    protected void putSpi(String key, String value) {
        block3: {
            this.initCache();
            this.properties.setProperty(key, value);
            this.lastModificationTime = Math.max(this.lastModificationTime + 1L, System.currentTimeMillis());
            try {
                this.flush();
            }
            catch (BackingStoreException e) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Failed to flush configuration changes");
                }
                if (!logger.isDebugEnabled()) break block3;
                logger.info((Object)"Failed to flush configuration changes", (Throwable)e);
            }
        }
    }

    private void initCache() {
        if (this.lastModificationTime == 0L) {
            File pathForNode = new File(this.getPathForNode());
            try {
                this.load(pathForNode);
            }
            catch (BackingStoreException e) {
                logger.warn((Object)"Failed to load data", (Throwable)e);
            }
        }
    }

    @Override
    protected String getSpi(String key) {
        this.initCache();
        return this.properties.getProperty(key);
    }

    @Override
    protected void removeSpi(String key) {
        block3: {
            this.initCache();
            this.properties.remove(key);
            this.lastModificationTime = Math.max(this.lastModificationTime + 1L, System.currentTimeMillis());
            try {
                this.flush();
            }
            catch (BackingStoreException e) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Failed to flush configuration changes");
                }
                if (!logger.isDebugEnabled()) break block3;
                logger.info((Object)"Failed to flush configuration changes", (Throwable)e);
            }
        }
    }

    public long getLastModificationTime() {
        return this.lastModificationTime;
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        this.initCache();
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        ArrayList<String> result = new ArrayList<String>();
        File pathForNode = new File(this.getPathForNode());
        File[] dirContents = pathForNode.listFiles();
        if (dirContents != null) {
            for (int i = 0; i < dirContents.length; ++i) {
                if (!dirContents[i].isDirectory()) continue;
                result.add(BinaryPreferences.decodePath(dirContents[i].getName()));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        return new BinaryPreferences(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        File pathForNode = new File(this.getPathForNode());
        if (!pathForNode.exists() && this.properties.isEmpty()) {
            return;
        }
        this.load(pathForNode);
        if (!pathForNode.exists() && !pathForNode.mkdirs()) {
            throw new BackingStoreException("Failed to write config " + pathForNode);
        }
        File target = new File(pathForNode, "prefs.properties");
        if (!target.exists() || target.lastModified() < this.lastModificationTime) {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));){
                this.properties.store(out, "");
            }
            catch (Exception e) {
                throw new BackingStoreException("Failed to write config " + target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File pathForNode) throws BackingStoreException {
        File target;
        if (pathForNode.exists() && (target = new File(pathForNode, "prefs.properties")).lastModified() > this.lastModificationTime && target.exists()) {
            try (BufferedInputStream out = new BufferedInputStream(new FileInputStream(target));){
                this.properties.clear();
                this.properties.load(out);
                this.lastModificationTime = Math.max(this.lastModificationTime + 1L, System.currentTimeMillis());
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
                throw new BackingStoreException("Failed to write config " + target);
            }
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        this.syncSpi();
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        File pathForNode = new File(this.getPathForNode());
        if (pathForNode.exists()) {
            File target = new File(pathForNode, "prefs.properties");
            if (!target.delete()) {
                throw new BackingStoreException("Unable to delete node-backend");
            }
            if (!pathForNode.delete()) {
                throw new BackingStoreException("Unable to delete node-backend");
            }
        }
    }

    private String getPathForNode() {
        if (this.parent != null) {
            return this.parent.getPathForNode() + File.separatorChar + BinaryPreferences.encodePath(this.name());
        }
        return this.rootPath;
    }

    private static String decodePath(String path) throws BackingStoreException {
        try {
            char[] data = path.toCharArray();
            StringBuffer encoded = new StringBuffer(path.length());
            int seenDollarIndex = -1;
            for (int i = 0; i < data.length; ++i) {
                if (seenDollarIndex > -1) {
                    if (data[i] == '$') {
                        encoded.append('$');
                        seenDollarIndex = -1;
                        continue;
                    }
                    if (i - seenDollarIndex != 4) continue;
                    int c = Integer.parseInt(path.substring(seenDollarIndex + 1, i + 1), 16);
                    encoded.append((char)c);
                    seenDollarIndex = -1;
                    continue;
                }
                if (data[i] == '$') {
                    seenDollarIndex = i;
                    continue;
                }
                encoded.append(data[i]);
            }
            return encoded.toString();
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            throw new BackingStoreException("Failed to decode name: " + path);
        }
    }

    private static String encodePath(String path) {
        char[] data = path.toCharArray();
        StringBuffer encoded = new StringBuffer(path.length());
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == '$') {
                encoded.append('$');
                encoded.append('$');
                continue;
            }
            if (!Character.isJavaIdentifierPart(data[i])) {
                encoded.append('$');
                String hex = Integer.toHexString(data[i]);
                for (int x = hex.length(); x < 4; ++x) {
                    encoded.append('0');
                }
                encoded.append(hex);
                continue;
            }
            encoded.append(data[i]);
        }
        return encoded.toString();
    }
}

