/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.EventListener;
import java.util.Locale;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.util.DrawSelectionType;
import org.pentaho.reporting.designer.core.util.Unit;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.WeakEventListenerList;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class WorkspaceSettings
implements LocaleSettings {
    private static final String SHOW_LAUNCHER_KEY = "ShowLauncher";
    private static WorkspaceSettings instance;
    private static final String GRID_DIVISIONS_KEY = "GridDivisions";
    private static final String USE_VERSION_CHECKER_KEY = "UseVersionChecker";
    private static final String REPORT_DESIGNER_BOUNDS_KEY = "ReportDesignerBounds";
    private static final String FIELD_PALETTE_BOUNDS_KEY = "FieldPaletteBounds";
    private static final String LNF_KEY = "lnf";
    private static final String SNAP_TO_GRID_KEY = "SnapToGrid";
    private static final String SHOW_GRID_KEY = "ShowGrid";
    private static final String ALWAYS_DRAW_ELEMENT_BORDER_KEY = "AlwaysDrawElementBorder";
    private static final String NOTIFY_FOR_ALL_BUILDS_KEY = "NotifyForAllBuilds";
    private static final String LAST_PROMPTED_VERSION_UPDATE_KEY = "LastPromptedVersionUpdate";
    private static final String GRID_SIZE_KEY = "GridSize";
    private static final String UNIT_KEY = "Unit";
    private static final String OFFLINE_MODE_KEY = "OfflineMode";
    private static final String SPLASH_SCREEN_VISIBLE = "SplashScreenVisible";
    private static final String EXPERIMENTAL_FEATURES_KEY = "ExperimentalFeatures";
    private static final String NON_CORE_FEATURES_KEY = "NonCoreFeatures";
    private static final String DEBUG_FEATURES_KEY = "DebugFeatures";
    private static final String MATURITY_LEVEL_KEY = "MaturityLevel";
    private static final String FIELD_SELECTOR_VISIBLE_KEY = "FieldSelectorVisible";
    private static final String DRAW_SELECTION_TYPE_KEY = "DrawSelectionType";
    private static final String SNAP_TO_GUIDE_LINES_KEY = "SnapToGuideLines";
    private static final String SNAP_TO_ELEMENTS_KEY = "SnapToElements";
    private static final String SHOW_ELEMENT_ALIGNMENT_HINTS_KEY = "ShowElementAlignmentHints";
    private static final String OVERLAPPING_ELEMENT_HIGHLIGHT_KEY = "Overlapping-Element-Highlight";
    private static final String ELEMENT_DISPLAY_STYLE_KEY = "ElementDisplayStyle";
    private static final String DISPLAY_STYLE_NAMES = "Names";
    private static final String DISPLAY_STYLE_VALUES = "Values";
    private static final String DATE_FORMAT_PATTERN = "DateFormatPattern";
    private static final String TIME_FORMAT_PATTERN = "TimeFormatPattern";
    private static final String DATETIME_FORMAT_PATTERN = "DatetimeFormatPattern";
    public static final String DATETIME_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss.SSSS";
    public static final String TIME_FORMAT_DEFAULT = "HH:mm:ss.SSSS";
    public static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
    private static final String STORE_PASSWORDS = "StorePasswords";
    private static final String CONNECTION_TIMEOUT = "ConnectionTimeout";
    private static final String SHOW_INDEX_COLUMNS = "ShowIndexColumns";
    private static final String SHOW_DEPRECATED_ITEMS = "ShowDeprecatedItems";
    private static final String SHOW_EXPERT_ITEMS = "ShowExpertItems";
    private static final String REOPEN_LAST_REPORT = "ReopenLastReport";
    private static final String SNAP_THRESHOLD = "SnapThreshold";
    private static final String GRID_COLOR = "GridColor";
    private static final String GUIDE_COLOR = "GuideColor";
    private static final String ALIGNMENT_HINT_COLOR = "AlignmentHintColor";
    private static final String OVERLAP_HINT_COLOR = "OverlapErrorColor";
    private static final Color GRID_COLOR_DEFAULT;
    private static final Color GUIDE_COLOR_DEFAULT;
    private static final Color ALIGNMENT_HINT_COLOR_DEFAULT;
    private static final Color OVERLAP_HINT_COLOR_DEFAULT;
    private Preferences properties = Preferences.userRoot().node("org/pentaho/reporting/designer/workspace-settings");
    private WeakEventListenerList settingsListeners = new WeakEventListenerList();

    public static synchronized WorkspaceSettings getInstance() {
        if (instance == null) {
            instance = new WorkspaceSettings();
        }
        return instance;
    }

    private WorkspaceSettings() {
    }

    public void flush() {
        try {
            this.properties.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private void put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
        this.fireSettingsChanged();
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        String value = this.properties.get(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private String getString(String key) {
        return this.properties.get(key, null);
    }

    public void addSettingsListener(SettingsListener listener) {
        this.settingsListeners.add(SettingsListener.class, (EventListener)listener);
    }

    public void removeSettingsListener(SettingsListener listener) {
        this.settingsListeners.remove(SettingsListener.class, (EventListener)listener);
    }

    public void fireSettingsChanged() {
        SettingsListener[] listeners = (SettingsListener[])this.settingsListeners.getListeners(SettingsListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            SettingsListener listener = listeners[i];
            listener.settingsChanged();
        }
    }

    public boolean isReopenLastReport() {
        return this.getBoolean(REOPEN_LAST_REPORT, false);
    }

    public void setReopenLastReport(boolean b) {
        this.put(REOPEN_LAST_REPORT, String.valueOf(b));
    }

    public boolean isShowExpertItems() {
        return this.getBoolean(SHOW_EXPERT_ITEMS, true);
    }

    public void setShowExpertItems(boolean b) {
        this.put(SHOW_EXPERT_ITEMS, String.valueOf(b));
    }

    public boolean isSplashScreenVisible() {
        return this.getBoolean(SPLASH_SCREEN_VISIBLE, true);
    }

    public void setSplashScreenVisible(boolean b) {
        this.put(SPLASH_SCREEN_VISIBLE, String.valueOf(b));
    }

    public boolean isShowDeprecatedItems() {
        return this.getBoolean(SHOW_DEPRECATED_ITEMS, false);
    }

    public void setShowDeprecatedItems(boolean b) {
        this.put(SHOW_DEPRECATED_ITEMS, String.valueOf(b));
    }

    public boolean isShowOverlappingElements() {
        return this.getBoolean(OVERLAPPING_ELEMENT_HIGHLIGHT_KEY, true);
    }

    public void setShowOverlappingElements(boolean b) {
        this.put(OVERLAPPING_ELEMENT_HIGHLIGHT_KEY, String.valueOf(b));
    }

    public boolean isShowElementAlignmentHints() {
        return this.properties.getBoolean(SHOW_ELEMENT_ALIGNMENT_HINTS_KEY, false);
    }

    public void setShowElementAlignmentHints(boolean showElementAlignmentHints) {
        this.properties.put(SHOW_ELEMENT_ALIGNMENT_HINTS_KEY, String.valueOf(showElementAlignmentHints));
        this.fireSettingsChanged();
    }

    public boolean isSnapToElements() {
        return this.properties.getBoolean(SNAP_TO_ELEMENTS_KEY, true);
    }

    public void setSnapToElements(boolean snapToElements) {
        this.properties.put(SNAP_TO_ELEMENTS_KEY, String.valueOf(snapToElements));
        this.fireSettingsChanged();
    }

    public boolean isSnapToGuideLines() {
        return this.properties.getBoolean(SNAP_TO_GUIDE_LINES_KEY, false);
    }

    public void setSnapToGuideLines(boolean snapToElements) {
        this.properties.put(SNAP_TO_GUIDE_LINES_KEY, String.valueOf(snapToElements));
        this.fireSettingsChanged();
    }

    public DrawSelectionType getDrawSelectionType() {
        String unitText = this.properties.get(DRAW_SELECTION_TYPE_KEY, DrawSelectionType.OUTLINE.toString());
        try {
            return DrawSelectionType.valueOf(unitText);
        }
        catch (Exception e) {
            return DrawSelectionType.OUTLINE;
        }
    }

    public void setDrawSelectionType(DrawSelectionType unit) {
        if (unit == null) {
            throw new IllegalArgumentException("DrawSelectionType must not be null");
        }
        this.properties.put(DRAW_SELECTION_TYPE_KEY, String.valueOf((Object)unit));
        this.fireSettingsChanged();
    }

    public boolean isUseVersionChecker() {
        return this.properties.getBoolean(USE_VERSION_CHECKER_KEY, true);
    }

    public boolean isInitialVersionCheck() {
        return this.properties.get(USE_VERSION_CHECKER_KEY, null) == null;
    }

    public void setUseVersionChecker(boolean useVersionChecker) {
        this.properties.putBoolean(USE_VERSION_CHECKER_KEY, useVersionChecker);
        this.fireSettingsChanged();
    }

    public void setBounds(Rectangle rectangle) {
        String value = LibSwingUtil.rectangleToString((Rectangle)rectangle);
        this.properties.put(REPORT_DESIGNER_BOUNDS_KEY, value);
    }

    public Rectangle getBounds() {
        String boundsAsText = this.properties.get(REPORT_DESIGNER_BOUNDS_KEY, "");
        return LibSwingUtil.parseRectangle((String)boundsAsText);
    }

    public void setFieldPaletteBounds(Rectangle rectangle) {
        String value = LibSwingUtil.rectangleToString((Rectangle)rectangle);
        this.properties.put(FIELD_PALETTE_BOUNDS_KEY, value);
    }

    public Rectangle getFieldPaletteBounds() {
        String theReportDesignerBounds = this.properties.get(FIELD_PALETTE_BOUNDS_KEY, "");
        return LibSwingUtil.parseRectangle((String)theReportDesignerBounds);
    }

    public void setLNF(String lnf) {
        this.properties.put(LNF_KEY, lnf);
        this.fireSettingsChanged();
        this.flush();
    }

    public String getLNF() {
        return this.properties.get(LNF_KEY, null);
    }

    public boolean isSnapToGrid() {
        return this.properties.getBoolean(SNAP_TO_GRID_KEY, false);
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.properties.put(SNAP_TO_GRID_KEY, String.valueOf(snapToGrid));
        this.fireSettingsChanged();
    }

    public boolean isShowGrid() {
        return this.properties.getBoolean(SHOW_GRID_KEY, true);
    }

    public void setShowGrid(boolean showGrid) {
        this.properties.put(SHOW_GRID_KEY, String.valueOf(showGrid));
        this.fireSettingsChanged();
    }

    public boolean isAlwaysDrawElementFrames() {
        return this.properties.getBoolean(ALWAYS_DRAW_ELEMENT_BORDER_KEY, false);
    }

    public void setAlwaysDrawElementFrames(boolean alwaysDrawElementFrames) {
        this.properties.put(ALWAYS_DRAW_ELEMENT_BORDER_KEY, String.valueOf(alwaysDrawElementFrames));
        this.fireSettingsChanged();
    }

    public boolean isNotifyForAllBuilds() {
        return this.properties.getBoolean(NOTIFY_FOR_ALL_BUILDS_KEY, false);
    }

    public void setNotifyForAllBuilds(boolean notifyForAllBuilds) {
        this.properties.put(NOTIFY_FOR_ALL_BUILDS_KEY, String.valueOf(notifyForAllBuilds));
        this.fireSettingsChanged();
    }

    public String getLastPromptedVersionUpdate() {
        return this.properties.get(LAST_PROMPTED_VERSION_UPDATE_KEY, null);
    }

    public void setLastPromptedVersionUpdate(String lastPromptedVersionUpdate) {
        this.properties.put(LAST_PROMPTED_VERSION_UPDATE_KEY, lastPromptedVersionUpdate);
        this.fireSettingsChanged();
    }

    public double getGridSize() {
        String gridSizeStr = this.properties.get(GRID_SIZE_KEY, null);
        return ParserUtil.parseFloat((String)gridSizeStr, (float)5.0f);
    }

    public void setGridSize(double gridSize) {
        this.properties.put(GRID_SIZE_KEY, String.valueOf(gridSize));
        this.fireSettingsChanged();
    }

    public int getGridDivisions() {
        String gridDivisionStr = this.properties.get(GRID_DIVISIONS_KEY, null);
        return ParserUtil.parseInt((String)gridDivisionStr, (int)10);
    }

    public void setGridDivisions(int gridDivisions) {
        this.properties.put(GRID_DIVISIONS_KEY, String.valueOf(gridDivisions));
        this.fireSettingsChanged();
    }

    public Unit getUnit() {
        String unitText = this.properties.get(UNIT_KEY, Unit.INCH.toString());
        try {
            return Unit.valueOf(unitText);
        }
        catch (Exception e) {
            return Unit.INCH;
        }
    }

    public void setUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("unit must not be null");
        }
        this.properties.put(UNIT_KEY, String.valueOf((Object)unit));
        this.fireSettingsChanged();
    }

    public boolean isOfflineMode() {
        return this.properties.getBoolean(OFFLINE_MODE_KEY, false);
    }

    public void setOfflineMode(boolean snapToGrid) {
        this.properties.put(OFFLINE_MODE_KEY, String.valueOf(snapToGrid));
        this.fireSettingsChanged();
    }

    public boolean isExperimentalFeaturesVisible() {
        return this.getMaturityLevel().isExperimental();
    }

    public MaturityLevel getMaturityLevel() {
        MaturityLevel ml = MaturityLevel.Production;
        try {
            String matLevel = ReportDesignerBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.designer.core.settings.MaturityLevel");
            if (matLevel != null) {
                ml = MaturityLevel.valueOf((String)matLevel);
            }
        }
        catch (IllegalArgumentException e) {
            ml = MaturityLevel.Production;
        }
        String defaultValue = this.properties.getBoolean(EXPERIMENTAL_FEATURES_KEY, false) ? MaturityLevel.Development.toString() : ml.toString();
        try {
            String s = this.properties.get(MATURITY_LEVEL_KEY, defaultValue);
            if (s != null) {
                return MaturityLevel.valueOf((String)s);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return MaturityLevel.Production;
    }

    public boolean isMatureFeature(MaturityLevel ml) {
        return this.getMaturityLevel().isMature(ml);
    }

    public boolean isMatureFeature(MetaData ml) {
        if (ml == null) {
            return false;
        }
        return this.getMaturityLevel().isMature(ml.getFeatureMaturityLevel());
    }

    public boolean isVisible(MetaData ml) {
        if (ml == null) {
            return false;
        }
        if (!this.isMatureFeature(ml)) {
            return false;
        }
        if (!this.isShowExpertItems() && ml.isExpert()) {
            return false;
        }
        return this.isShowDeprecatedItems() || !ml.isDeprecated();
    }

    public void setMaturityLevel(MaturityLevel ml) {
        if (ml == null) {
            this.properties.remove(MATURITY_LEVEL_KEY);
        } else {
            this.properties.put(MATURITY_LEVEL_KEY, ml.toString());
        }
        this.fireSettingsChanged();
    }

    @Deprecated
    public void setExperimentalFeaturesVisible(boolean snapToGrid) {
        this.properties.put(EXPERIMENTAL_FEATURES_KEY, String.valueOf(snapToGrid));
        this.fireSettingsChanged();
    }

    public boolean isDebugFeaturesVisible() {
        return this.properties.getBoolean(DEBUG_FEATURES_KEY, false);
    }

    public void setDebugFeaturesVisible(boolean snapToGrid) {
        this.properties.put(DEBUG_FEATURES_KEY, String.valueOf(snapToGrid));
        this.fireSettingsChanged();
    }

    @Deprecated
    public boolean isNonCoreFeaturesVisible() {
        return this.properties.getBoolean(NON_CORE_FEATURES_KEY, false);
    }

    @Deprecated
    public void setNonCoreFeaturesVisible(boolean snapToGrid) {
        this.properties.put(NON_CORE_FEATURES_KEY, String.valueOf(snapToGrid));
        this.fireSettingsChanged();
    }

    public boolean isFieldSelectorVisible() {
        return this.properties.getBoolean(FIELD_SELECTOR_VISIBLE_KEY, false);
    }

    public void setFieldSelectorVisible(boolean snapToGrid) {
        this.properties.put(FIELD_SELECTOR_VISIBLE_KEY, String.valueOf(snapToGrid));
        this.fireSettingsChanged();
    }

    public void setShowLauncher(boolean flag) {
        this.properties.put(SHOW_LAUNCHER_KEY, String.valueOf(flag));
        this.fireSettingsChanged();
    }

    public boolean isShowLauncher() {
        return this.properties.getBoolean(SHOW_LAUNCHER_KEY, true);
    }

    public boolean isElementsDisplayNames() {
        return DISPLAY_STYLE_NAMES.equals(this.getString(ELEMENT_DISPLAY_STYLE_KEY));
    }

    public boolean isElementsDisplayValues() {
        String object = this.getString(ELEMENT_DISPLAY_STYLE_KEY);
        return object == null || DISPLAY_STYLE_VALUES.equals(object);
    }

    public void setElementsDisplayNames() {
        this.put(ELEMENT_DISPLAY_STYLE_KEY, DISPLAY_STYLE_NAMES);
    }

    public void setElementsDisplayValues() {
        this.put(ELEMENT_DISPLAY_STYLE_KEY, DISPLAY_STYLE_VALUES);
    }

    public String getDateFormatPattern() {
        String s = this.getString(DATE_FORMAT_PATTERN);
        if (StringUtils.isEmpty((String)s)) {
            return DATE_FORMAT_DEFAULT;
        }
        return s;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.put(DATE_FORMAT_PATTERN, dateFormatPattern);
    }

    public String getTimeFormatPattern() {
        String s = this.getString(TIME_FORMAT_PATTERN);
        if (StringUtils.isEmpty((String)s)) {
            return TIME_FORMAT_DEFAULT;
        }
        return s;
    }

    public void setTimeFormatPattern(String timeFormatPattern) {
        this.put(TIME_FORMAT_PATTERN, timeFormatPattern);
    }

    public String getDatetimeFormatPattern() {
        String s = this.getString(DATETIME_FORMAT_PATTERN);
        if (StringUtils.isEmpty((String)s)) {
            return DATETIME_FORMAT_DEFAULT;
        }
        return s;
    }

    public void setDatetimeFormatPattern(String datetimeFormatPattern) {
        this.put(DATETIME_FORMAT_PATTERN, datetimeFormatPattern);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public boolean isRememberPasswords() {
        return this.getBoolean(STORE_PASSWORDS, true);
    }

    public void setRememberPasswords(boolean flag) {
        this.put(STORE_PASSWORDS, String.valueOf(flag));
    }

    public int getConnectionTimeout() {
        String connectionTimeoutStr = this.properties.get(CONNECTION_TIMEOUT, null);
        return ParserUtil.parseInt((String)connectionTimeoutStr, (int)30);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.put(CONNECTION_TIMEOUT, String.valueOf(connectionTimeout));
    }

    public boolean isShowIndexColumns() {
        return this.getBoolean(SHOW_INDEX_COLUMNS, false);
    }

    public void setShowIndexColumns(boolean flag) {
        this.put(SHOW_INDEX_COLUMNS, String.valueOf(flag));
    }

    public long getSnapThreshold() {
        String snapThresholdStr = this.properties.get(SNAP_THRESHOLD, null);
        return StrictGeomUtility.toInternalValue((double)ParserUtil.parseInt((String)snapThresholdStr, (int)5));
    }

    public Color getGridColor() {
        return this.getColor(GRID_COLOR, GRID_COLOR_DEFAULT);
    }

    public void setGridColor(Color value) {
        String text = ColorUtility.toAttributeValue((Color)value);
        if (text == null) {
            this.properties.remove(GRID_COLOR);
        } else {
            this.properties.put(GRID_COLOR, text);
        }
    }

    public Color getGuideColor() {
        return this.getColor(GUIDE_COLOR, GUIDE_COLOR_DEFAULT);
    }

    public void setGuideColor(Color value) {
        String text = ColorUtility.toAttributeValue((Color)value);
        if (text == null) {
            this.properties.remove(GUIDE_COLOR);
        } else {
            this.properties.put(GUIDE_COLOR, text);
        }
    }

    public Color getAlignmentHintColor() {
        return this.getColor(ALIGNMENT_HINT_COLOR, ALIGNMENT_HINT_COLOR_DEFAULT);
    }

    public void setAlignmentHintColor(Color value) {
        String text = ColorUtility.toAttributeValue((Color)value);
        if (text == null) {
            this.properties.remove(ALIGNMENT_HINT_COLOR);
        } else {
            this.properties.put(ALIGNMENT_HINT_COLOR, text);
        }
    }

    public Color getOverlapErrorColor() {
        return this.getColor(OVERLAP_HINT_COLOR, OVERLAP_HINT_COLOR_DEFAULT);
    }

    public void setOverlapErrorColor(Color value) {
        String text = ColorUtility.toAttributeValue((Color)value);
        if (text == null) {
            this.properties.remove(OVERLAP_HINT_COLOR);
        } else {
            this.properties.put(OVERLAP_HINT_COLOR, text);
        }
    }

    private Color getColor(String property, Color defaultValue) {
        String gridColorStr = this.properties.get(property, null);
        if (gridColorStr == null) {
            return defaultValue;
        }
        try {
            Color color = ColorUtility.toPropertyValue((String)gridColorStr);
            if (color == null) {
                return defaultValue;
            }
            return color;
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    static {
        GRID_COLOR_DEFAULT = new Color(228, 228, 228);
        GUIDE_COLOR_DEFAULT = new Color(0, 139, 237);
        ALIGNMENT_HINT_COLOR_DEFAULT = new Color(228, 228, 228);
        OVERLAP_HINT_COLOR_DEFAULT = new Color(255, 128, 128);
    }
}

