/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ExternalToolSettings {
    private static ExternalToolSettings instance;
    private static final String USE_DEFAULT_PDFVIEWER_KEY = "UseDefaultPDFViewer";
    private static final String CUSTOM_PDFVIEWER_EXECUTABLE_KEY = "CustomPDFViewerExecutable";
    private static final String CUSTOM_PDFVIEWER_PARAMETERS_KEY = "CustomPDFViewerParameters";
    private static final String USE_DEFAULT_RTFVIEWER_KEY = "UseDefaultRTFViewer";
    private static final String CUSTOM_RTFVIEWER_PARAMETERS_KEY = "CustomRTFViewerParameters";
    private static final String CUSTOM_RTFVIEWER_EXECUTABLE_KEY = "CustomRTFViewerExecutable";
    private static final String USE_DEFAULT_XLSVIEWER_KEY = "UseDefaultXLSViewer";
    private static final String CUSTOM_XLSVIEWER_EXECUTABLE_KEY = "CustomXLSViewerExecutable";
    private static final String CUSTOM_XLSVIEWER_PARAMETERS_KEY = "CustomXLSViewerParameters";
    private static final String USE_DEFAULT_CSVVIEWER_KEY = "UseDefaultCSVViewer";
    private static final String CUSTOM_CSVVIEWER_EXECUTABLE_KEY = "CustomCSVViewerExecutable";
    private static final String CUSTOM_CSVVIEWER_PARAMETERS_KEY = "CustomCSVViewerParameters";
    private static final String USE_DEFAULT_BROWSER_KEY = "UseDefaultBrowser";
    private static final String CUSTOM_BROWSER_EXECUTABLE_KEY = "CustomBrowserExecutable";
    private static final String CUSTOM_BROWSER_PARAMETERS_KEY = "CustomBrowserParameters";
    private Preferences preferences = Preferences.userRoot().node("org/pentaho/reporting/designer/application-settings/external-tools-settings");

    public static synchronized ExternalToolSettings getInstance() {
        if (instance == null) {
            instance = new ExternalToolSettings();
        }
        return instance;
    }

    public boolean isUseDefaultBrowser() {
        return this.preferences.getBoolean(USE_DEFAULT_BROWSER_KEY, true);
    }

    public void setUseDefaultBrowser(boolean useDefaultBrowser) {
        this.preferences.put(USE_DEFAULT_BROWSER_KEY, String.valueOf(useDefaultBrowser));
    }

    public String getCustomBrowserExecutable() {
        return this.preferences.get(CUSTOM_BROWSER_EXECUTABLE_KEY, null);
    }

    public void setCustomBrowserExecutable(String customBrowserExecutable) {
        this.preferences.put(CUSTOM_BROWSER_EXECUTABLE_KEY, String.valueOf(customBrowserExecutable));
    }

    public String getCustomBrowserParameters() {
        return this.preferences.get(CUSTOM_BROWSER_PARAMETERS_KEY, "{0}");
    }

    public void setCustomBrowserParameters(String customBrowserParameters) {
        this.preferences.put(CUSTOM_BROWSER_PARAMETERS_KEY, String.valueOf(customBrowserParameters));
    }

    public boolean isUseDefaultPDFViewer() {
        return this.preferences.getBoolean(USE_DEFAULT_PDFVIEWER_KEY, true);
    }

    public void setUseDefaultPDFViewer(boolean useDefaultPDFViewer) {
        this.preferences.putBoolean(USE_DEFAULT_PDFVIEWER_KEY, useDefaultPDFViewer);
    }

    public String getCustomPDFViewerExecutable() {
        return this.preferences.get(CUSTOM_PDFVIEWER_EXECUTABLE_KEY, null);
    }

    public void setCustomPDFViewerExecutable(String customPDFViewerExecutable) {
        this.preferences.put(CUSTOM_PDFVIEWER_EXECUTABLE_KEY, customPDFViewerExecutable);
    }

    public String getCustomPDFViewerParameters() {
        return this.preferences.get(CUSTOM_PDFVIEWER_PARAMETERS_KEY, "{0}");
    }

    public void setCustomPDFViewerParameters(String customPDFViewerParameters) {
        this.preferences.put(CUSTOM_PDFVIEWER_PARAMETERS_KEY, customPDFViewerParameters);
    }

    public boolean isUseDefaultRTFViewer() {
        return this.preferences.getBoolean(USE_DEFAULT_RTFVIEWER_KEY, true);
    }

    public void setUseDefaultRTFViewer(boolean useDefaultRTFViewer) {
        this.preferences.putBoolean(USE_DEFAULT_RTFVIEWER_KEY, useDefaultRTFViewer);
    }

    public String getCustomRTFViewerExecutable() {
        return this.preferences.get(CUSTOM_RTFVIEWER_EXECUTABLE_KEY, null);
    }

    public void setCustomRTFViewerExecutable(String customRTFViewerExecutable) {
        this.preferences.put(CUSTOM_RTFVIEWER_EXECUTABLE_KEY, customRTFViewerExecutable);
    }

    public String getCustomRTFViewerParameters() {
        return this.preferences.get(CUSTOM_RTFVIEWER_PARAMETERS_KEY, "{0}");
    }

    public void setCustomRTFViewerParameters(String customRTFViewerParameters) {
        this.preferences.put(CUSTOM_RTFVIEWER_PARAMETERS_KEY, customRTFViewerParameters);
    }

    public boolean isUseDefaultXLSViewer() {
        return this.preferences.getBoolean(USE_DEFAULT_XLSVIEWER_KEY, true);
    }

    public void setUseDefaultXLSViewer(boolean useDefaultXLSViewer) {
        this.preferences.putBoolean(USE_DEFAULT_XLSVIEWER_KEY, useDefaultXLSViewer);
    }

    public String getCustomXLSViewerExecutable() {
        return this.preferences.get(CUSTOM_XLSVIEWER_EXECUTABLE_KEY, null);
    }

    public void setCustomXLSViewerExecutable(String customXLSViewerExecutable) {
        this.preferences.put(CUSTOM_XLSVIEWER_EXECUTABLE_KEY, customXLSViewerExecutable);
    }

    public String getCustomXLSViewerParameters() {
        return this.preferences.get(CUSTOM_XLSVIEWER_PARAMETERS_KEY, "{0}");
    }

    public void setCustomXLSViewerParameters(String customXLSViewerParameters) {
        this.preferences.put(CUSTOM_XLSVIEWER_PARAMETERS_KEY, customXLSViewerParameters);
    }

    public boolean isUseDefaultCSVViewer() {
        return this.preferences.getBoolean(USE_DEFAULT_CSVVIEWER_KEY, true);
    }

    public void setUseDefaultCSVViewer(boolean useDefaultCSVViewer) {
        this.preferences.putBoolean(USE_DEFAULT_CSVVIEWER_KEY, useDefaultCSVViewer);
    }

    public String getCustomCSVViewerExecutable() {
        return this.preferences.get(CUSTOM_CSVVIEWER_EXECUTABLE_KEY, null);
    }

    public void setCustomCSVViewerExecutable(String customCSVViewerExecutable) {
        this.preferences.put(CUSTOM_CSVVIEWER_EXECUTABLE_KEY, customCSVViewerExecutable);
    }

    public String getCustomCSVViewerParameters() {
        return this.preferences.get(CUSTOM_CSVVIEWER_PARAMETERS_KEY, "{0}");
    }

    public void setCustomCSVViewerParameters(String customCSVViewerParameters) {
        this.preferences.put(CUSTOM_CSVVIEWER_PARAMETERS_KEY, customCSVViewerParameters);
    }

    public void flush() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

