/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model.data;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.model.ReportDataSchemaModel;
import org.pentaho.reporting.designer.core.model.data.DataSchemaManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.DefaultDesignTimeDataSchemaModelChangeTracker;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;

public class SynchronousDataSchemaManager
implements DataSchemaManager,
ReportModelListener {
    private final MasterReport masterReport;
    private final AbstractReportDefinition report;
    private final ArrayList<ChangeListener> listeners;
    private ContextAwareDataSchemaModel model;
    private DefaultDesignTimeDataSchemaModelChangeTracker changeTracker;
    private boolean isHandlingChange;

    public SynchronousDataSchemaManager(MasterReport masterReport, AbstractReportDefinition report) {
        ArgumentNullException.validate((String)"masterReport", (Object)masterReport);
        ArgumentNullException.validate((String)"report", (Object)report);
        this.listeners = new ArrayList();
        this.masterReport = masterReport;
        this.report = report;
        this.report.addReportModelListener((ReportModelListener)this);
        this.changeTracker = new DefaultDesignTimeDataSchemaModelChangeTracker(report);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        ArgumentNullException.validate((String)"l", (Object)l);
        this.listeners.add(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        ArgumentNullException.validate((String)"l", (Object)l);
        this.listeners.remove(l);
    }

    @Override
    public void close() {
    }

    public synchronized void nodeChanged(ReportModelEvent event) {
        if (this.isHandlingChange) {
            return;
        }
        if (this.changeTracker.isReportChanged()) {
            try {
                this.fireChangeEvent();
            }
            finally {
                this.changeTracker.updateChangeTrackers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        try {
            this.isHandlingChange = true;
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(event);
            }
        }
        finally {
            this.isHandlingChange = false;
        }
    }

    @Override
    public ContextAwareDataSchemaModel getModel() {
        if (this.model == null) {
            this.model = new ReportDataSchemaModel(this.masterReport, this.report);
        }
        return this.model;
    }
}

