/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.AlignmentUtilities;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class AlignmentOptionsDialog
extends CommonDialog {
    private PageDefinition pageDefinition;
    private ReportDocumentContext context;
    private JRadioButton leftButton;
    private JRadioButton centerButton;
    private JRadioButton rightButton;
    private JRadioButton proportionalButton;
    private JRadioButton noneButton;

    public AlignmentOptionsDialog(ReportDocumentContext context, PageDefinition pageDefinition) {
        this.init(context, pageDefinition);
    }

    public AlignmentOptionsDialog(Dialog parent, ReportDocumentContext context, PageDefinition pageDefinition) {
        super(parent);
        this.init(context, pageDefinition);
    }

    public AlignmentOptionsDialog(Frame parent, ReportDocumentContext context, PageDefinition pageDefinition) {
        super(parent);
        this.init(context, pageDefinition);
    }

    private void init(ReportDocumentContext reportRenderContext, PageDefinition pageDefinition) {
        if (reportRenderContext == null) {
            throw new NullPointerException();
        }
        if (pageDefinition == null) {
            throw new NullPointerException();
        }
        this.context = reportRenderContext;
        this.pageDefinition = pageDefinition;
        this.setTitle(Messages.getString("ResizeReportOptionPane.Title", new Object[0]));
        this.leftButton = new JRadioButton(Messages.getString("ResizeReportOptionPane.OptionAlignLeft", new Object[0]), false);
        this.centerButton = new JRadioButton(Messages.getString("ResizeReportOptionPane.OptionAlignCenter", new Object[0]), false);
        this.rightButton = new JRadioButton(Messages.getString("ResizeReportOptionPane.OptionAlignRight", new Object[0]), false);
        this.proportionalButton = new JRadioButton(Messages.getString("ResizeReportOptionPane.OptionResizeProportional", new Object[0]), false);
        this.noneButton = new JRadioButton(Messages.getString("ResizeReportOptionPane.OptionAlignNone", new Object[0]), true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.leftButton);
        buttonGroup.add(this.centerButton);
        buttonGroup.add(this.rightButton);
        buttonGroup.add(this.proportionalButton);
        buttonGroup.add(this.noneButton);
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.AlignmentOptions";
    }

    protected Component createContentPane() {
        JLabel resizeLabel = new JLabel(Messages.getString("ResizeReportOptionPane.Message", new Object[0]));
        resizeLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
        JPanel optionsPane = new JPanel(new GridLayout(5, 1));
        optionsPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        optionsPane.add(this.leftButton);
        optionsPane.add(this.centerButton);
        optionsPane.add(this.rightButton);
        optionsPane.add(this.proportionalButton);
        optionsPane.add(this.noneButton);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)resizeLabel, "North");
        contentPane.add((Component)optionsPane, "Center");
        return contentPane;
    }

    public boolean performEdit() {
        if (super.performEdit()) {
            AlignmentUtilities theAlignmentUtil = new AlignmentUtilities(this.context, this.pageDefinition);
            if (this.leftButton.isSelected()) {
                theAlignmentUtil.alignLeft();
            }
            if (this.centerButton.isSelected()) {
                theAlignmentUtil.alignCenter();
            }
            if (this.rightButton.isSelected()) {
                theAlignmentUtil.alignRight();
            }
            if (this.proportionalButton.isSelected()) {
                theAlignmentUtil.resizeProportional();
            }
            return true;
        }
        return false;
    }
}

