/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Map;
import java.util.Set;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class OverlappingElementsInspection
extends AbstractStructureInspection {
    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        if (!(element instanceof Element)) {
            return;
        }
        CachedLayoutData data = ModelUtility.getCachedLayoutData((Element)element);
        if (data.isConflictsInTableMode()) {
            String message;
            Map<InstanceID, Set<InstanceID>> conflicts = reportRenderContext.getSharedRenderer().getConflicts();
            Set<InstanceID> instanceIDs = conflicts.get(element.getObjectID());
            if (instanceIDs == null || instanceIDs.isEmpty()) {
                message = Messages.getString("OverlappingElementsInspection.ElementConflictsInTableMode", element.getName());
            } else {
                String elementName = this.computeConflictingElementName(reportRenderContext, instanceIDs);
                message = instanceIDs.size() == 1 ? Messages.getString("OverlappingElementsInspection.ElementConflictsInTableModeSingle", element.getName(), elementName) : Messages.getString("OverlappingElementsInspection.ElementConflictsInTableModeMultiples", element.getName(), elementName, instanceIDs.size());
            }
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, message, new LocationInfo(element)));
        }
    }

    private String computeConflictingElementName(ReportDocumentContext reportRenderContext, Set<InstanceID> instanceIDs) {
        InstanceID firstElement;
        Map<InstanceID, Element> elementsById = reportRenderContext.getSharedRenderer().getElementsById();
        Element conflictingElement = elementsById.get(firstElement = instanceIDs.iterator().next());
        if (conflictingElement == null) {
            return Messages.getString("OverlappingElementsInspection.UnidentifiedElement", new Object[0]);
        }
        return conflictingElement.getName();
    }

    @Override
    public boolean isInlineInspection() {
        return true;
    }
}

