/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Locale;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;

public class MandatoryAttributeMissingInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        ElementMetaData metaData = element.getMetaData();
        AttributeMetaData[] attributeDescriptions = metaData.getAttributeDescriptions();
        for (int i = 0; i < attributeDescriptions.length; ++i) {
            AttributeMetaData attributeMetaData = attributeDescriptions[i];
            Object value = element.getAttribute(attributeMetaData.getNameSpace(), attributeMetaData.getName());
            if (value != null) {
                if (!attributeMetaData.getTargetType().isInstance(value)) {
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("MandatoryAttributeMissingInspection.AttributeValueHasInvalidType", element.getName(), attributeMetaData.getDisplayName(Locale.getDefault()), attributeMetaData.getTargetType().getName(), value.getClass().getName()), new AttributeLocationInfo(element, attributeMetaData.getNameSpace(), attributeMetaData.getName(), false)));
                }
                if (!attributeMetaData.isDesignTimeValue() || element.getAttributeExpression(attributeMetaData.getNameSpace(), attributeMetaData.getName()) == null) continue;
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("MandatoryAttributeMissingInspection.DesignTimeAttributeWithExpression", element.getName(), attributeMetaData.getDisplayName(Locale.getDefault())), new AttributeLocationInfo(element, attributeMetaData.getNameSpace(), attributeMetaData.getName(), false)));
                continue;
            }
            if (!attributeMetaData.isMandatory()) continue;
            if (!attributeMetaData.isDesignTimeValue()) {
                if (element.getAttributeExpression(attributeMetaData.getNameSpace(), attributeMetaData.getName()) != null) continue;
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("MandatoryAttributeMissingInspection.MandatoryAttributeWithoutValueOrExpression", element.getName(), attributeMetaData.getDisplayName(Locale.getDefault())), new AttributeLocationInfo(element, attributeMetaData.getNameSpace(), attributeMetaData.getName(), false)));
                continue;
            }
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("MandatoryAttributeMissingInspection.MandatoryAttributeWithoutValue", element.getName(), attributeMetaData.getDisplayName(Locale.getDefault())), new AttributeLocationInfo(element, attributeMetaData.getNameSpace(), attributeMetaData.getName(), false)));
        }
    }
}

