/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Map;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;

public abstract class AbstractStructureInspection
implements Inspection {
    protected AbstractStructureInspection() {
    }

    @Override
    public void inspect(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler) throws ReportDataFactoryException {
        AbstractReportDefinition reportDefinition = reportRenderContext.getReportDefinition();
        ContextAwareDataSchemaModel model = reportRenderContext.getReportDataSchemaModel();
        String[] columnNames = model.getColumnNames();
        if (reportDefinition instanceof MasterReport) {
            MasterReport mr = (MasterReport)reportDefinition;
            ReportParameterDefinition parameters = mr.getParameterDefinition();
            ParameterDefinitionEntry[] entries = parameters.getParameterDefinitions();
            for (int i = 0; i < entries.length; ++i) {
                ParameterDefinitionEntry entry = entries[i];
                this.inspectParameter(designerContext, reportRenderContext, resultHandler, columnNames, parameters, entry);
            }
        }
        CompoundDataFactory dataFactory = CompoundDataFactory.normalize((DataFactory)reportDefinition.getDataFactory());
        int size = dataFactory.size();
        for (int i = 0; i < size; ++i) {
            this.inspectDataSource(designerContext, reportRenderContext, resultHandler, columnNames, (DataFactory)dataFactory);
        }
        ExpressionCollection expressions = reportDefinition.getExpressions();
        Expression[] expressionsArray = expressions.getExpressions();
        for (int i = 0; i < expressionsArray.length; ++i) {
            Expression expression = expressionsArray[i];
            this.inspectExpression(designerContext, reportRenderContext, resultHandler, columnNames, expression);
        }
        this.inspectElement(designerContext, reportRenderContext, resultHandler, columnNames, (ReportElement)reportDefinition);
        this.traverseSection(designerContext, reportRenderContext, resultHandler, columnNames, (Section)reportDefinition);
    }

    public void traverseSection(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Section section) {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = section.getElement(i);
            this.inspectElement(designerContext, reportRenderContext, resultHandler, columnNames, (ReportElement)element);
            if (element instanceof SubReport && reportRenderContext.getReportDefinition() != element || !(element instanceof Section)) continue;
            this.traverseSection(designerContext, reportRenderContext, resultHandler, columnNames, (Section)element);
        }
    }

    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
    }

    protected void traverseAttributeExpressions(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        String[] attrExprNamespaces = element.getAttributeExpressionNamespaces();
        for (int i = 0; i < attrExprNamespaces.length; ++i) {
            String attrExprNamespace = attrExprNamespaces[i];
            String[] names = element.getAttributeExpressionNames(attrExprNamespace);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Expression expression = element.getAttributeExpression(attrExprNamespace, name);
                if (expression == null) continue;
                String expressionName = expression.getClass().getName();
                if (!ExpressionRegistry.getInstance().isExpressionRegistered(expressionName)) {
                    this.inspectAttributeExpression(designerContext, reportRenderContext, resultHandler, columnNames, element, attrExprNamespace, name, expression, null);
                    continue;
                }
                ExpressionMetaData metaData = ExpressionRegistry.getInstance().getExpressionMetaData(expressionName);
                this.inspectAttributeExpression(designerContext, reportRenderContext, resultHandler, columnNames, element, attrExprNamespace, name, expression, metaData);
            }
        }
    }

    protected void inspectAttributeExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
    }

    protected void traverseStyleExpressions(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        Map map = element.getStyleExpressions();
        for (Map.Entry entry : map.entrySet()) {
            StyleKey styleKey = (StyleKey)entry.getKey();
            Expression expression = (Expression)entry.getValue();
            if (expression == null) continue;
            String expressionName = expression.getClass().getName();
            if (!ExpressionRegistry.getInstance().isExpressionRegistered(expressionName)) {
                this.inspectStyleExpression(designerContext, reportRenderContext, resultHandler, columnNames, element, styleKey, expression, null);
                continue;
            }
            ExpressionMetaData metaData = ExpressionRegistry.getInstance().getExpressionMetaData(expressionName);
            this.inspectStyleExpression(designerContext, reportRenderContext, resultHandler, columnNames, element, styleKey, expression, metaData);
        }
    }

    protected void inspectStyleExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
    }

    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression) {
        String expressionName = expression.getClass().getName();
        if (!ExpressionRegistry.getInstance().isExpressionRegistered(expressionName)) {
            this.inspectExpression(designerContext, reportRenderContext, resultHandler, columnNames, expression, null);
        } else {
            ExpressionMetaData metaData = ExpressionRegistry.getInstance().getExpressionMetaData(expressionName);
            this.inspectExpression(designerContext, reportRenderContext, resultHandler, columnNames, expression, metaData);
        }
    }

    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
    }

    protected void inspectParameter(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportParameterDefinition definition, ParameterDefinitionEntry parameter) {
    }

    protected void inspectDataSource(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, DataFactory dataFactory) {
    }
}

