/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultTable;
import org.pentaho.reporting.designer.core.inspections.InspectionResultTableModel;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class InspectionsMessageDialog
extends CommonDialog {
    private InspectionResultTableModel dataModel;
    private InspectionResultTable table;
    private ReportDesignerContext designerContext;

    public InspectionsMessageDialog() {
    }

    public InspectionsMessageDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public InspectionsMessageDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.dataModel = new InspectionResultTableModel();
        this.table = new InspectionResultTable();
        this.table.setModel(this.dataModel);
        this.table.addKeyListener(new InspectionSelectionHandler());
        this.table.addMouseListener(new InspectionSelectionHandler());
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.InspectionsMessage";
    }

    protected boolean hasCancelButton() {
        return false;
    }

    private void performSelection(InspectionResult inspectionResult) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performShowResult(ReportDesignerContext context, InspectionResult[] results) {
        this.designerContext = context;
        try {
            this.dataModel.clear();
            for (int i = 0; i < results.length; ++i) {
                InspectionResult result = results[i];
                this.dataModel.add(result);
            }
            this.performEdit();
        }
        finally {
            this.designerContext = null;
        }
    }

    protected Component createContentPane() {
        return new JScrollPane(this.table);
    }

    private class InspectionSelectionHandler
    extends MouseAdapter
    implements KeyListener {
        private InspectionSelectionHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2 || e.getButton() != 1) {
                return;
            }
            int row = InspectionsMessageDialog.this.table.rowAtPoint(e.getPoint());
            if (row != -1) {
                InspectionsMessageDialog.this.performSelection(InspectionsMessageDialog.this.dataModel.getInspectionResult(row));
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyCode() != 10) {
                return;
            }
            int selectedRow = InspectionsMessageDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            InspectionResult inspectionResult = InspectionsMessageDialog.this.dataModel.getInspectionResult(selectedRow);
            InspectionsMessageDialog.this.performSelection(inspectionResult);
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

