/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections;

import java.util.Arrays;
import javax.swing.Action;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;

public class InspectionResult {
    private Inspection source;
    private LocationInfo[] locationInfos;
    private Severity severity;
    private String description;
    private Action quickFix;

    public InspectionResult(Inspection source, Severity severity, String description, LocationInfo locationInfos, Action quickFix) {
        this(source, severity, description, new LocationInfo[]{locationInfos});
        this.quickFix = quickFix;
    }

    public InspectionResult(Inspection source, Severity severity, String description, LocationInfo locationInfos) {
        this(source, severity, description, new LocationInfo[]{locationInfos});
    }

    public InspectionResult(Inspection source, Severity severity, String description, LocationInfo[] locationInfos) {
        if (severity == null) {
            throw new IllegalArgumentException("severity must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        if (locationInfos == null) {
            throw new IllegalArgumentException("locationInfos must not be null");
        }
        this.severity = severity;
        this.description = description;
        this.locationInfos = (LocationInfo[])locationInfos.clone();
        this.source = source;
    }

    public Inspection getSource() {
        return this.source;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public LocationInfo[] getLocationInfos() {
        return (LocationInfo[])this.locationInfos.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectionResult that = (InspectionResult)o;
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!Arrays.equals(this.locationInfos, that.locationInfos)) {
            return false;
        }
        return this.severity == that.severity;
    }

    public int hashCode() {
        int result = this.severity.hashCode();
        result = 29 * result + this.description.hashCode();
        result = 29 * result + Arrays.hashCode(this.locationInfos);
        return result;
    }

    public Action getQuickFix() {
        return this.quickFix;
    }

    public String toString() {
        return (Object)((Object)this.severity) + ": " + this.description;
    }

    public static enum Severity {
        HINT,
        WARNING,
        ERROR;

    }
}

