/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles.styleeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.styles.Messages;
import org.pentaho.reporting.designer.core.editor.styles.SimpleStyleEditorPanel;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.AddStyleRuleAction;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.ElementStyleDefinitionChangeEvent;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.ElementStyleDefinitionChangeListener;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.OpenAction;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.RemoveStyleRuleAction;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.SaveAction;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.SaveAsAction;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.StyleDefinitionEditorContext;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.css.CSSParseException;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleRule;
import org.pentaho.reporting.engine.classic.core.style.css.StyleSheetParserUtil;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.pentaho.reporting.engine.classic.core.style.css.selector.CSSSelector;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.w3c.css.sac.SelectorList;

public class StyleDefinitionEditorDialog
extends CommonDialog {
    private JXTaskPaneContainer taskPaneContainer;
    private HashMap<ElementStyleRule, JXTaskPane> taskPanes;
    private JXTaskPane taskPane;
    private boolean standalone;
    private JMenuBar standaloneMenuBar;
    private JMenuBar inlineMenuBar;
    private StyleDefinitionEditorContext editorContext;

    public StyleDefinitionEditorDialog(ReportDesignerContext designerContext) {
        this.init(designerContext);
    }

    public StyleDefinitionEditorDialog(Frame owner, ReportDesignerContext designerContext) throws HeadlessException {
        super(owner);
        this.init(designerContext);
    }

    public StyleDefinitionEditorDialog(Dialog owner, ReportDesignerContext designerContext) throws HeadlessException {
        super(owner);
        this.init(designerContext);
    }

    protected void init(ReportDesignerContext designerContext) {
        this.taskPanes = new HashMap();
        this.editorContext = new StyleDefinitionEditorContext(designerContext, (Component)((Object)this), new ElementStyleDefinition());
        this.editorContext.addPropertyChangeListener("source", new FileSourceChangeHandler());
        this.setTitle(Messages.getString("StyleDefinitionEditorDialog.InlineTitle", new Object[0]));
        JMenu fileMenu = new JMenu(Messages.getString("StyleDefinitionEditorDialog.Menu.File.Label", new Object[0]));
        fileMenu.setMnemonic(Messages.getMnemonic("StyleDefinitionEditorDialog.Menu.File.Mnemonic"));
        fileMenu.add(new OpenAction(this.editorContext));
        fileMenu.add(new SaveAction(this.editorContext));
        fileMenu.add(new SaveAsAction(this.editorContext));
        fileMenu.addSeparator();
        fileMenu.add(new CloseAction());
        this.standaloneMenuBar = new JMenuBar();
        this.standaloneMenuBar.add(fileMenu);
        JMenu inlineMenu = new JMenu(Messages.getString("StyleDefinitionEditorDialog.Menu.File.Label", new Object[0]));
        inlineMenu.setMnemonic(Messages.getMnemonic("StyleDefinitionEditorDialog.Menu.File.Mnemonic"));
        inlineMenu.add(new OpenAction(this.editorContext));
        inlineMenu.add(new SaveAction(this.editorContext));
        inlineMenu.add(new SaveAsAction(this.editorContext));
        this.inlineMenuBar = new JMenuBar();
        this.inlineMenuBar.add(inlineMenu);
        this.setJMenuBar(this.inlineMenuBar);
        super.init();
        this.editorContext.addElementStyleDefinitionChangeListener(new ElementStyleDefinitionChangeHandler());
    }

    protected void performInitialResize() {
        this.setSize(800, 600);
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.StyleDefinitionEditor";
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
        if (standalone) {
            this.setJMenuBar(this.standaloneMenuBar);
            this.setButtonPaneVisible(false);
            this.setTitle(Messages.getString("StyleDefinitionEditorDialog.Title", new Object[0]));
        } else {
            this.setJMenuBar(this.inlineMenuBar);
            this.setButtonPaneVisible(true);
            this.setTitle(Messages.getString("StyleDefinitionEditorDialog.InlineTitle", new Object[0]));
        }
    }

    protected Component createContentPane() {
        this.taskPane = new JXTaskPane();
        this.taskPane.setSpecial(true);
        this.taskPane.setCollapsed(false);
        this.taskPane.setTitle(Messages.getString("StyleDefinitionEditorDialog.TaskTitle", new Object[0]));
        this.taskPane.add((Action)new AddStyleRuleAction(this.editorContext));
        this.taskPaneContainer = new JXTaskPaneContainer();
        this.taskPaneContainer.add(this.taskPane);
        return new JScrollPane((Component)this.taskPaneContainer);
    }

    private void rebuildPanes() {
        this.taskPanes.clear();
        this.taskPaneContainer.removeAll();
        this.taskPaneContainer.add(this.taskPane);
        ElementStyleDefinition existing = this.editorContext.getStyleDefinition();
        for (int i = 0; i < existing.getRuleCount(); ++i) {
            ElementStyleSheet maybeRule = existing.getRule(i);
            if (!(maybeRule instanceof ElementStyleRule)) continue;
            ElementStyleRule rule = (ElementStyleRule)maybeRule;
            this.addRulePane(rule);
        }
    }

    private void addRulePane(ElementStyleRule rule) {
        String selectorText = this.convertSelectorText(rule);
        JTextField selector = new JTextField();
        selector.setText(selectorText);
        JXTaskPane pane = new JXTaskPane();
        pane.setTitle(Messages.getString("StyleDefinitionEditorDialog.RuleTitle", selectorText));
        pane.add((Action)new RemoveStyleRuleAction(this.editorContext, rule));
        pane.add((Component)selector);
        SimpleStyleEditorPanel comp = new SimpleStyleEditorPanel(this.editorContext);
        comp.setReportDesignerContext(this.editorContext.getDesignerContext());
        comp.setData((ElementStyleSheet)rule);
        pane.add((Component)comp);
        selector.getDocument().addDocumentListener((DocumentListener)((Object)new SelectorUpdateHandler(selector, rule, pane)));
        this.taskPanes.put(rule, pane);
        this.taskPaneContainer.add(pane);
        this.taskPaneContainer.revalidate();
        this.taskPaneContainer.repaint();
    }

    private void removeRulePane(ElementStyleRule rule) {
        JXTaskPane jxTaskPane = this.taskPanes.get(rule);
        if (jxTaskPane != null) {
            this.taskPaneContainer.remove(jxTaskPane);
            this.taskPanes.remove(rule);
            this.taskPaneContainer.revalidate();
            this.taskPaneContainer.repaint();
        }
    }

    private String convertSelectorText(ElementStyleRule rule) {
        NamespaceCollection nc = StyleSheetParserUtil.getInstance().getNamespaceCollection();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < rule.getSelectorCount(); ++i) {
            if (i != 0) {
                b.append(", ");
            }
            CSSSelector selector = rule.getSelector(i);
            b.append(selector.print(nc));
        }
        return b.toString();
    }

    public ElementStyleDefinition performEdit(ElementStyleDefinition existing) {
        this.editorContext.setStyleDefinition(existing);
        if (!super.performEdit()) {
            return existing;
        }
        return this.editorContext.getStyleDefinition().clone();
    }

    public static StyleDefinitionEditorDialog createDialog(Component parent, ReportDesignerContext context) {
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        StyleDefinitionEditorDialog exceptionDialog = window instanceof Dialog ? new StyleDefinitionEditorDialog((Dialog)window, context) : (window instanceof Frame ? new StyleDefinitionEditorDialog((Frame)window, context) : new StyleDefinitionEditorDialog(context));
        return exceptionDialog;
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        ReportDesignerBoot.getInstance().start();
        StyleDefinitionEditorDialog dialog = new StyleDefinitionEditorDialog(null);
        dialog.setStandalone(true);
        dialog.setVisible(true);
    }

    private class FileSourceChangeHandler
    implements PropertyChangeListener {
        private FileSourceChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StyleDefinitionEditorDialog.this.editorContext.getSource() == null) {
                StyleDefinitionEditorDialog.this.setTitle(Messages.getString("StyleDefinitionEditorDialog.Title", new Object[0]));
            } else {
                StyleDefinitionEditorDialog.this.setTitle(Messages.getString("StyleDefinitionEditorDialog.TitleFile", StyleDefinitionEditorDialog.this.editorContext.getSource()));
            }
        }
    }

    private class ElementStyleDefinitionChangeHandler
    implements ElementStyleDefinitionChangeListener {
        private ElementStyleDefinitionChangeHandler() {
        }

        @Override
        public void styleRuleAdded(ElementStyleDefinitionChangeEvent event) {
            StyleDefinitionEditorDialog.this.addRulePane(event.getStyleRule());
        }

        @Override
        public void styleRuleRemoved(ElementStyleDefinitionChangeEvent event) {
            StyleDefinitionEditorDialog.this.removeRulePane(event.getStyleRule());
        }

        @Override
        public void styleRulesChanged(ElementStyleDefinitionChangeEvent event) {
            StyleDefinitionEditorDialog.this.rebuildPanes();
        }
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
            this.putValue("Name", Messages.getString("StyleDefinitionEditorDialog.Close.Text", new Object[0]));
            this.putValue("ShortDescription", Messages.getString("StyleDefinitionEditorDialog.Close.Description", new Object[0]));
            this.putValue("MnemonicKey", Messages.getOptionalMnemonic("StyleDefinitionEditorDialog.Close.Mnemonic"));
            this.putValue("AcceleratorKey", Messages.getOptionalKeyStroke("StyleDefinitionEditorDialog.Close.Accelerator"));
            this.putValue("SmallIcon", IconLoader.getInstance().getEmptyIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StyleDefinitionEditorDialog.this.getCancelAction().actionPerformed(e);
        }
    }

    private class SelectorUpdateHandler
    extends DocumentChangeHandler {
        private JTextField textField;
        private ElementStyleRule styleRule;
        private JXTaskPane pane;
        private Color color;
        private Color errorColor;

        private SelectorUpdateHandler(JTextField textField, ElementStyleRule styleRule, JXTaskPane pane) {
            this.textField = textField;
            this.styleRule = styleRule;
            this.pane = pane;
            this.color = textField.getBackground();
            this.errorColor = new Color(1.0f, 0.75f, 0.75f);
        }

        protected void handleChange(DocumentEvent e) {
            try {
                NamespaceCollection nc = StyleSheetParserUtil.getInstance().getNamespaceCollection();
                String selectorText = this.textField.getText();
                SelectorList list = StyleSheetParserUtil.getInstance().parseSelector(nc, selectorText);
                this.styleRule.clearSelectors();
                this.textField.setBackground(this.color);
                for (int i = 0; i < list.getLength(); ++i) {
                    CSSSelector selector = (CSSSelector)list.item(i);
                    this.styleRule.addSelector(selector);
                }
                this.pane.setTitle(Messages.getString("StyleDefinitionEditorDialog.RuleTitle", selectorText));
            }
            catch (CSSParseException e1) {
                this.textField.setBackground(this.errorColor);
            }
        }
    }
}

