/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles.styleeditor;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.ElementStyleDefinitionChangeEvent;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.ElementStyleDefinitionChangeListener;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleRule;

public class StyleDefinitionEditorContext {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private EventListenerList listeners = new EventListenerList();
    private Component parent;
    private ReportDesignerContext designerContext;
    private ElementStyleDefinition styleDefinition;
    private File source;

    public StyleDefinitionEditorContext(ReportDesignerContext designerContext, Component parent, ElementStyleDefinition styleDefinition) {
        this.designerContext = designerContext;
        this.parent = parent;
        this.styleDefinition = styleDefinition;
    }

    public void addElementStyleDefinitionChangeListener(ElementStyleDefinitionChangeListener listener) {
        this.listeners.add(ElementStyleDefinitionChangeListener.class, listener);
    }

    public void removeElementStyleDefinitionChangeListener(ElementStyleDefinitionChangeListener listener) {
        this.listeners.remove(ElementStyleDefinitionChangeListener.class, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void fireChange() {
        ElementStyleDefinitionChangeEvent event = new ElementStyleDefinitionChangeEvent(this, this.styleDefinition, null);
        ElementStyleDefinitionChangeListener[] changeListeners = (ElementStyleDefinitionChangeListener[])this.listeners.getListeners(ElementStyleDefinitionChangeListener.class);
        for (int i = changeListeners.length - 1; i >= 0; --i) {
            ElementStyleDefinitionChangeListener changeListener = changeListeners[i];
            changeListener.styleRulesChanged(event);
        }
    }

    public void fireRuleAdded(ElementStyleRule rule) {
        ElementStyleDefinitionChangeEvent event = new ElementStyleDefinitionChangeEvent(this, this.styleDefinition, rule);
        ElementStyleDefinitionChangeListener[] changeListeners = (ElementStyleDefinitionChangeListener[])this.listeners.getListeners(ElementStyleDefinitionChangeListener.class);
        for (int i = changeListeners.length - 1; i >= 0; --i) {
            ElementStyleDefinitionChangeListener changeListener = changeListeners[i];
            changeListener.styleRuleAdded(event);
        }
    }

    public void fireRuleRemoved(ElementStyleRule rule) {
        ElementStyleDefinitionChangeEvent event = new ElementStyleDefinitionChangeEvent(this, this.styleDefinition, rule);
        ElementStyleDefinitionChangeListener[] changeListeners = (ElementStyleDefinitionChangeListener[])this.listeners.getListeners(ElementStyleDefinitionChangeListener.class);
        for (int i = changeListeners.length - 1; i >= 0; --i) {
            ElementStyleDefinitionChangeListener changeListener = changeListeners[i];
            changeListener.styleRuleRemoved(event);
        }
    }

    public void addStyleRule(ElementStyleRule rule) {
        for (int i = 0; i < this.styleDefinition.getRuleCount(); ++i) {
            if (this.styleDefinition.getRule(i) != rule) continue;
            return;
        }
        this.styleDefinition.addRule((ElementStyleSheet)rule);
        this.fireRuleAdded(rule);
    }

    public void removeStyleRule(ElementStyleRule rule) {
        for (int i = 0; i < this.styleDefinition.getRuleCount(); ++i) {
            if (!this.styleDefinition.getRule(i).equals(rule)) continue;
            this.styleDefinition.removeRule((ElementStyleSheet)rule);
            this.fireRuleRemoved(rule);
            return;
        }
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        File oldFile = this.source;
        this.source = source;
        this.propertyChangeSupport.firePropertyChange("source", oldFile, source);
    }

    public Component getParent() {
        return this.parent;
    }

    public ReportDesignerContext getDesignerContext() {
        return this.designerContext;
    }

    public ElementStyleDefinition getStyleDefinition() {
        return this.styleDefinition;
    }

    public void setStyleDefinition(ElementStyleDefinition styleDefinition) {
        this.styleDefinition.clearRules();
        if (styleDefinition != null) {
            for (int i = 0; i < styleDefinition.getRuleCount(); ++i) {
                this.styleDefinition.addRule(styleDefinition.getRule(i));
            }
        }
        this.fireChange();
    }
}

