/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.styles.AbstractStyleDataBackend;
import org.pentaho.reporting.designer.core.editor.styles.AbstractStyleTableModel;
import org.pentaho.reporting.designer.core.editor.styles.Messages;
import org.pentaho.reporting.designer.core.editor.styles.StyleDataBackend;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.StyleEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.StyleExpressionEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.PlainMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.resolver.SimpleStyleResolver;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class StyleTableModel
extends AbstractStyleTableModel<DefaultStyleDataBackend> {
    private static final Log logger = LogFactory.getLog(StyleTableModel.class);
    private static final Object NULL_INDICATOR = new Object();
    private static final Element[] EMPTY_ELEMENTS = new Element[0];
    private static final ElementType[] EMPTY_ELEMENT_TYPES = new ElementType[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private Executor pool;
    private DefaultStyleDataBackend oldDataBackend;
    private ReportDocumentContext reportRenderContext;

    public StyleTableModel() {
        this(Executors.newSingleThreadExecutor());
    }

    public StyleTableModel(Executor pool) {
        if (pool == null) {
            throw new NullPointerException();
        }
        this.pool = pool;
        super.setDataBackend(new DefaultStyleDataBackend());
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
        super.setTableStyle(tableStyle);
        this.pool.execute(new UpdateDataTask(this.getData(), this.isSynchronous()));
    }

    @Override
    public synchronized void setDataBackend(DefaultStyleDataBackend dataBackend) {
        this.oldDataBackend = (DefaultStyleDataBackend)this.getDataBackend();
        super.setDataBackend(dataBackend);
    }

    protected DefaultStyleDataBackend updateData(Element[] elements) {
        StyleMetaData[] metaData = StyleTableModel.selectCommonAttributes(elements);
        TableStyle tableStyle = this.getTableStyle();
        if (tableStyle == TableStyle.ASCENDING) {
            Arrays.sort(metaData, new PlainMetaDataComparator());
            return new DefaultStyleDataBackend(metaData, new GroupingHeader[metaData.length], elements);
        }
        if (tableStyle == TableStyle.DESCENDING) {
            Arrays.sort(metaData, Collections.reverseOrder(new PlainMetaDataComparator()));
            return new DefaultStyleDataBackend(metaData, new GroupingHeader[metaData.length], elements);
        }
        Arrays.sort(metaData, new GroupedMetaDataComparator());
        Locale locale = Locale.getDefault();
        int groupCount = 0;
        int metaDataCount = 0;
        if (metaData.length > 0) {
            String oldValue = null;
            for (int i = 0; i < metaData.length; ++i) {
                StyleMetaData data = metaData[i];
                if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
                ++metaDataCount;
                if (groupCount == 0) {
                    groupCount = 1;
                    StyleMetaData firstdata = metaData[i];
                    oldValue = firstdata.getGrouping(locale);
                    continue;
                }
                String grouping = data.getGrouping(locale);
                if (ObjectUtilities.equal(oldValue, (Object)grouping)) continue;
                oldValue = grouping;
                ++groupCount;
            }
        }
        StyleMetaData[] groupedMetaData = new StyleMetaData[metaDataCount + groupCount];
        int targetIdx = 0;
        GroupingHeader[] groupings = new GroupingHeader[groupedMetaData.length];
        GroupingHeader group = null;
        for (int sourceIdx = 0; sourceIdx < metaData.length; ++sourceIdx) {
            StyleMetaData data = metaData[sourceIdx];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
            if (targetIdx == 0) {
                groupings[targetIdx] = group = new GroupingHeader(data.getGrouping(locale));
                ++targetIdx;
            } else {
                String newgroup = data.getGrouping(locale);
                if (!ObjectUtilities.equal((Object)newgroup, (Object)group.getHeaderText())) {
                    groupings[targetIdx] = group = new GroupingHeader(newgroup);
                    ++targetIdx;
                }
            }
            groupings[targetIdx] = group;
            groupedMetaData[targetIdx] = data;
            ++targetIdx;
        }
        if (this.oldDataBackend != null) {
            groupings = this.reconcileState(groupings, this.oldDataBackend.getGroupings());
        }
        return new DefaultStyleDataBackend(groupedMetaData, groupings, elements);
    }

    private static boolean isSameElements(Element[] elements, ElementType[] elementTypes, Element[] oldElements) {
        if (elements.length != oldElements.length) {
            return false;
        }
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            if (oldElements[i].getObjectID() != element.getObjectID()) {
                return false;
            }
            if (oldElements[i].getElementType() == elementTypes[i]) continue;
            return false;
        }
        return true;
    }

    protected static StyleMetaData[] selectCommonAttributes(Element[] elements) {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        ArrayList<StyleMetaData> selectedArrays = new ArrayList<StyleMetaData>();
        for (int elementIdx = 0; elementIdx < elements.length; ++elementIdx) {
            Element element = elements[elementIdx];
            StyleMetaData[] datas = element.getMetaData().getStyleDescriptions();
            for (int styleIdx = 0; styleIdx < datas.length; ++styleIdx) {
                StyleMetaData data = datas[styleIdx];
                String name = data.getName();
                if (data.isHidden()) {
                    attributes.put(name, Boolean.FALSE);
                    continue;
                }
                if (!WorkspaceSettings.getInstance().isVisible((MetaData)data)) {
                    attributes.put(name, Boolean.FALSE);
                    continue;
                }
                Object attribute = attributes.get(name);
                if (Boolean.TRUE.equals(attribute) || attribute != null) continue;
                if (elementIdx == 0) {
                    selectedArrays.add(data);
                    attributes.put(name, Boolean.TRUE);
                    continue;
                }
                attributes.put(name, Boolean.FALSE);
            }
        }
        return selectedArrays.toArray(new StyleMetaData[selectedArrays.size()]);
    }

    public void setData(Element[] elements) {
        DefaultStyleDataBackend backend = (DefaultStyleDataBackend)this.getDataBackend();
        if (StyleTableModel.isSameElements(elements, backend.getElementTypes(), backend.getData())) {
            if (this.isSynchronous()) {
                new AbstractStyleTableModel.SameElementsUpdateDataTask((AbstractStyleTableModel)this, (StyleDataBackend)backend, this.isSynchronous()).run();
            } else {
                SwingUtilities.invokeLater(new AbstractStyleTableModel.SameElementsUpdateDataTask((AbstractStyleTableModel)this, (StyleDataBackend)backend, this.isSynchronous()));
            }
            return;
        }
        this.pool.execute(new UpdateDataTask(elements, this.isSynchronous()));
    }

    public Element[] getData() {
        return ((DefaultStyleDataBackend)this.getDataBackend()).getData();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Messages.getString("StyleTableModel.NameColumn", new Object[0]);
            }
            case 1: {
                return Messages.getString("StyleTableModel.InheritColumn", new Object[0]);
            }
            case 2: {
                return Messages.getString("StyleTableModel.ValueColumn", new Object[0]);
            }
            case 3: {
                return Messages.getString("StyleTableModel.FormulaColumn", new Object[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return this.getGroupings(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                return new GroupedName((MetaData)metaData);
            }
            case 1: {
                return this.computeInheritValue(metaData, rowIndex);
            }
            case 2: {
                return this.computeFullValue(metaData, rowIndex);
            }
            case 3: {
                return this.computeExpressionValue(metaData, rowIndex);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                return;
            }
            case 1: {
                if (!Boolean.TRUE.equals(aValue) || !this.defineFullValue(metaData, null)) break;
                ((DefaultStyleDataBackend)this.getDataBackend()).clearCache(rowIndex);
                this.fireTableDataChanged();
                break;
            }
            case 2: {
                if (!this.defineFullValue(metaData, aValue)) break;
                ((DefaultStyleDataBackend)this.getDataBackend()).clearCache(rowIndex);
                this.fireTableDataChanged();
                break;
            }
            case 3: {
                if (aValue != null && !(aValue instanceof Expression)) {
                    return;
                }
                if (!this.defineExpressionValue(metaData, (Expression)aValue)) break;
                ((DefaultStyleDataBackend)this.getDataBackend()).clearExpressionsCache(rowIndex);
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    @Override
    protected boolean defineFullValue(StyleMetaData metaData, Object value) {
        if (value != null && !metaData.getTargetType().isInstance(value)) {
            logger.warn((Object)("Invalid type: " + value + "(" + value.getClass() + ") but expected " + metaData.getTargetType()));
            return false;
        }
        boolean changed = false;
        Element[] elements = ((DefaultStyleDataBackend)this.getDataBackend()).getData();
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            ElementStyleSheet styleSheet = element.getStyle();
            Object attribute = styleSheet.getStyleProperty(metaData.getStyleKey());
            if (ObjectUtilities.equal((Object)attribute, (Object)value)) continue;
            changed = true;
        }
        if (changed) {
            ReportDocumentContext reportRenderContext = this.getReportRenderContext();
            if (reportRenderContext == null) {
                throw new IllegalStateException("No report render context? Thats bad.");
            }
            UndoManager undo = reportRenderContext.getUndo();
            ArrayList<StyleEditUndoEntry> undos = new ArrayList<StyleEditUndoEntry>();
            for (int i = 0; i < elements.length; ++i) {
                Element element = elements[i];
                ElementStyleSheet styleSheet = element.getStyle();
                Object attribute = styleSheet.getStyleProperty(metaData.getStyleKey());
                undos.add(new StyleEditUndoEntry(element.getObjectID(), metaData.getStyleKey(), attribute, value));
                styleSheet.setStyleProperty(metaData.getStyleKey(), value);
            }
            undo.addChange(Messages.getString("StyleChange", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        }
        return changed;
    }

    @Override
    protected Object computeInheritValue(StyleMetaData metaData, int rowIndex) {
        DefaultStyleDataBackend dataBackend1 = (DefaultStyleDataBackend)this.getDataBackend();
        Object[] inheritValues = dataBackend1.getInheritValues();
        Object o = inheritValues[rowIndex];
        if (o == StyleDataBackend.NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return o;
        }
        boolean allLocalKeys = true;
        boolean allInheritedKeys = true;
        Element[] elements = dataBackend1.getData();
        if (elements.length > 0) {
            Element element = elements[0];
            ElementStyleSheet styleSheet = element.getStyle();
            boolean localKey = styleSheet.isLocalKey(metaData.getStyleKey());
            allLocalKeys &= localKey;
            boolean bl = allInheritedKeys = !localKey;
        }
        Boolean retval = allLocalKeys && allInheritedKeys ? null : (allInheritedKeys ? Boolean.TRUE : (allLocalKeys ? Boolean.FALSE : null));
        inheritValues[rowIndex] = retval == null ? StyleDataBackend.NULL_INDICATOR : retval;
        return retval;
    }

    private boolean defineExpressionValue(StyleMetaData metaData, Expression value) {
        boolean changed = false;
        Element[] elements = ((DefaultStyleDataBackend)this.getDataBackend()).getData();
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            Expression attribute = element.getStyleExpression(metaData.getStyleKey());
            if (ObjectUtilities.equal((Object)attribute, (Object)value)) continue;
            changed = true;
        }
        if (changed) {
            ReportDocumentContext reportRenderContext = this.getReportRenderContext();
            if (reportRenderContext == null) {
                throw new IllegalStateException("No report render context? Thats bad.");
            }
            UndoManager undo = reportRenderContext.getUndo();
            ArrayList<StyleExpressionEditUndoEntry> undos = new ArrayList<StyleExpressionEditUndoEntry>();
            for (int i = 0; i < elements.length; ++i) {
                Element element = elements[i];
                Expression attribute = element.getStyleExpression(metaData.getStyleKey());
                if (value == null) {
                    undos.add(new StyleExpressionEditUndoEntry(element.getObjectID(), metaData.getStyleKey(), attribute, null));
                    element.setStyleExpression(metaData.getStyleKey(), null);
                    element.notifyNodePropertiesChanged();
                    continue;
                }
                Expression expression = value.getInstance();
                undos.add(new StyleExpressionEditUndoEntry(element.getObjectID(), metaData.getStyleKey(), attribute, expression));
                element.setStyleExpression(metaData.getStyleKey(), expression);
                element.notifyNodePropertiesChanged();
            }
            undo.addChange(Messages.getString("StyleChange", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        }
        return changed;
    }

    private Expression computeExpressionValue(StyleMetaData metaData, int row) {
        DefaultStyleDataBackend dataBackend1 = (DefaultStyleDataBackend)this.getDataBackend();
        Object[] expressionValues = dataBackend1.getExpressionValues();
        Object o = expressionValues[row];
        if (o == NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return (Expression)o;
        }
        Expression lastElement = null;
        Element[] elements = dataBackend1.getData();
        if (elements.length > 0) {
            Element element = elements[0];
            lastElement = element.getStyleExpression(metaData.getStyleKey());
        }
        expressionValues[row] = lastElement != null ? lastElement : NULL_INDICATOR;
        return lastElement;
    }

    @Override
    public Class getClassForCell(int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return GroupingHeader.class;
        }
        switch (columnIndex) {
            case 0: {
                return GroupedName.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return metaData.getTargetType();
            }
            case 3: {
                return Expression.class;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public PropertyEditor getEditorForCell(int rowIndex, int columnIndex) {
        StyleMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return this.computeEditor(metaData, rowIndex);
            }
            case 3: {
                return null;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public ReportDocumentContext getReportRenderContext() {
        return this.reportRenderContext;
    }

    public void setReportRenderContext(ReportDocumentContext reportRenderContext) {
        this.reportRenderContext = reportRenderContext;
    }

    private class UpdateDataTask
    implements Runnable {
        private Element[] elements;
        private boolean synchronous;

        private UpdateDataTask(Element[] elements, boolean synchronous) {
            this.synchronous = synchronous;
            this.elements = (Element[])elements.clone();
        }

        @Override
        public void run() {
            try {
                DefaultStyleDataBackend dataBackend = StyleTableModel.this.updateData(this.elements);
                if (this.synchronous || SwingUtilities.isEventDispatchThread()) {
                    StyleTableModel.this.setDataBackend(dataBackend);
                    StyleTableModel.this.fireTableDataChanged();
                } else {
                    SwingUtilities.invokeAndWait(new AbstractStyleTableModel.NotifyChangeTask((AbstractStyleTableModel)StyleTableModel.this, (StyleDataBackend)dataBackend));
                }
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    protected static class DefaultStyleDataBackend
    extends AbstractStyleDataBackend {
        private Element[] elements;
        private ElementType[] elementTypes;
        private Object[] inheritValues;
        private Object[] expressionValues;

        private DefaultStyleDataBackend() {
            this.elements = EMPTY_ELEMENTS;
            this.elementTypes = EMPTY_ELEMENT_TYPES;
            this.inheritValues = EMPTY_VALUES;
            this.expressionValues = EMPTY_VALUES;
        }

        private DefaultStyleDataBackend(StyleMetaData[] metaData, GroupingHeader[] groupings, Element[] elements) {
            super(metaData, groupings);
            this.elements = elements;
            this.elementTypes = new ElementType[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                Element element = elements[i];
                this.elementTypes[i] = element.getElementType();
            }
            ResolverStyleSheet resolverStyleSheet = this.getResolvedStyle();
            if (elements.length > 0) {
                SimpleStyleResolver resolver = new SimpleStyleResolver(true);
                resolver.resolve((ReportElement)elements[0], resolverStyleSheet);
            }
            this.inheritValues = new Object[metaData.length];
            this.expressionValues = new Object[metaData.length];
        }

        @Override
        public void clearCache(int rowIndex) {
            super.clearCache(rowIndex);
            this.inheritValues[rowIndex] = null;
        }

        @Override
        public void resetCache() {
            super.resetCache();
            Arrays.fill(this.inheritValues, null);
            Arrays.fill(this.expressionValues, null);
            ResolverStyleSheet resolverStyleSheet = this.getResolvedStyle();
            if (this.elements.length > 0) {
                SimpleStyleResolver resolver = new SimpleStyleResolver(true);
                resolver.resolve((ReportElement)this.elements[0], resolverStyleSheet);
            } else {
                resolverStyleSheet.clear();
            }
        }

        public Element[] getData() {
            return this.elements;
        }

        public void clearExpressionsCache(int rowIndex) {
            this.expressionValues[rowIndex] = null;
        }

        public Object[] getInheritValues() {
            return this.inheritValues;
        }

        public Object[] getExpressionValues() {
            return this.expressionValues;
        }

        public ElementType[] getElementTypes() {
            return this.elementTypes;
        }
    }
}

