/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.AbstractReportDataTreeModel;
import org.pentaho.reporting.designer.core.editor.structuretree.InheritedDataFactoryWrapper;
import org.pentaho.reporting.designer.core.editor.structuretree.ParentDataFactoryNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.editor.structuretree.SubReportParametersNode;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;

public class SubReportDataTreeModel
extends AbstractReportDataTreeModel {
    private SubReport reportElement;
    private SubReportParametersNode reportParametersNode;

    public SubReportDataTreeModel(ReportDocumentContext renderContext) {
        super(renderContext);
        if (!(renderContext.getReportDefinition() instanceof SubReport)) {
            throw new IllegalArgumentException("Instantiating a SubReportDataTreeModel on a MasterReport-Context");
        }
        this.reportElement = (SubReport)renderContext.getReportDefinition();
        this.reportParametersNode = new SubReportParametersNode();
    }

    protected SubReportParametersNode getReportParametersNode() {
        return this.reportParametersNode;
    }

    @Override
    public Object getRoot() {
        return this.reportElement;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.reportParametersNode) {
            return false;
        }
        if (node == this.reportParametersNode.getImportParametersNode()) {
            return false;
        }
        if (node == this.reportParametersNode.getExportParametersNode()) {
            return false;
        }
        if (node instanceof ParameterMapping) {
            return true;
        }
        if (node instanceof ParentDataFactoryNode) {
            return false;
        }
        if (node instanceof InheritedDataFactoryWrapper) {
            return false;
        }
        return super.isLeaf(node);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.reportParametersNode) {
            switch (index) {
                case 0: {
                    return this.reportParametersNode.getImportParametersNode();
                }
                case 1: {
                    return this.reportParametersNode.getExportParametersNode();
                }
            }
            throw new IndexOutOfBoundsException();
        }
        if (parent == this.reportParametersNode.getImportParametersNode()) {
            return this.reportElement.getInputMappings()[index];
        }
        if (parent == this.reportParametersNode.getExportParametersNode()) {
            return this.reportElement.getExportMappings()[index];
        }
        if (parent == this.reportElement) {
            switch (index) {
                case 0: {
                    return this.reportElement.getDataFactory();
                }
                case 1: {
                    Section parentSection = this.reportElement.getParentSection();
                    if (parentSection == null) {
                        throw new IllegalStateException();
                    }
                    AbstractReportDefinition reportDefinition = (AbstractReportDefinition)parentSection.getReportDefinition();
                    return new ParentDataFactoryNode(reportDefinition);
                }
                case 2: {
                    return this.getReportFunctionNode();
                }
                case 3: {
                    return this.getReportEnvironmentDataRow();
                }
                case 4: {
                    return this.reportParametersNode;
                }
            }
            throw new IndexOutOfBoundsException();
        }
        if (parent instanceof ParentDataFactoryNode) {
            ParentDataFactoryNode pdfn = (ParentDataFactoryNode)parent;
            CompoundDataFactory compoundDataFactory = pdfn.getDataFactory();
            if (index == compoundDataFactory.size()) {
                if (pdfn.isSubReport()) {
                    return pdfn.getParentNode();
                }
                throw new IndexOutOfBoundsException();
            }
            return new InheritedDataFactoryWrapper(compoundDataFactory.getReference(index));
        }
        if (parent instanceof InheritedDataFactoryWrapper) {
            InheritedDataFactoryWrapper idf = (InheritedDataFactoryWrapper)parent;
            DataFactory dataFactory = idf.getDataFactory();
            String[] queryNames = dataFactory.getQueryNames();
            return new ReportQueryNode(dataFactory, queryNames[index], false);
        }
        return super.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.reportElement) {
            return 5;
        }
        if (parent == this.reportParametersNode) {
            return 2;
        }
        if (parent == this.reportParametersNode.getImportParametersNode()) {
            return this.reportElement.getInputMappings().length;
        }
        if (parent == this.reportParametersNode.getExportParametersNode()) {
            return this.reportElement.getExportMappings().length;
        }
        if (parent instanceof ParentDataFactoryNode) {
            ParentDataFactoryNode pdfn = (ParentDataFactoryNode)parent;
            CompoundDataFactory compoundDataFactory = pdfn.getDataFactory();
            if (pdfn.isSubReport()) {
                return compoundDataFactory.size() + 1;
            }
            return compoundDataFactory.size();
        }
        if (parent instanceof InheritedDataFactoryWrapper) {
            InheritedDataFactoryWrapper idf = (InheritedDataFactoryWrapper)parent;
            return idf.getDataFactory().getQueryNames().length;
        }
        return super.getChildCount(parent);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.reportElement) {
            if (child == this.reportElement.getDataFactory()) {
                return 0;
            }
            if (child instanceof ParentDataFactoryNode) {
                return 1;
            }
            if (child == this.getReportFunctionNode()) {
                return 2;
            }
            if (child == this.getReportEnvironmentDataRow()) {
                return 3;
            }
            if (child == this.reportParametersNode) {
                return 4;
            }
            return -1;
        }
        if (parent instanceof ParentDataFactoryNode) {
            ParentDataFactoryNode pdfn = (ParentDataFactoryNode)parent;
            CompoundDataFactory compoundDataFactory = pdfn.getDataFactory();
            if (child instanceof ParentDataFactoryNode) {
                return compoundDataFactory.size();
            }
            if (!(child instanceof InheritedDataFactoryWrapper)) {
                return -1;
            }
            InheritedDataFactoryWrapper wrapper = (InheritedDataFactoryWrapper)child;
            CompoundDataFactory dataFactoryElement = this.getDataFactoryElement();
            for (int i = 0; i < dataFactoryElement.size(); ++i) {
                DataFactory dataFactory = dataFactoryElement.getReference(i);
                if (dataFactory != wrapper.getDataFactory()) continue;
                return i;
            }
            return -1;
        }
        if (parent instanceof InheritedDataFactoryWrapper) {
            InheritedDataFactoryWrapper idf = (InheritedDataFactoryWrapper)parent;
            if (!(child instanceof ReportQueryNode)) {
                return -1;
            }
            ReportQueryNode rfn = (ReportQueryNode)child;
            if (rfn.getDataFactory() != idf.getDataFactory()) {
                return -1;
            }
            String[] queryNames = rfn.getDataFactory().getQueryNames();
            return this.indexOf(queryNames, rfn.getQueryName());
        }
        if (parent == this.reportParametersNode) {
            if (child == this.reportParametersNode.getImportParametersNode()) {
                return 0;
            }
            if (child == this.reportParametersNode.getExportParametersNode()) {
                return 1;
            }
            return -1;
        }
        return super.getIndexOfChild(parent, child);
    }
}

