/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.AbstractReportTree;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportStructureTreeModel;
import org.pentaho.reporting.designer.core.editor.structuretree.StructureTreeCellRenderer;
import org.pentaho.reporting.designer.core.editor.structuretree.TreeSelectionHelper;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;

public class LayoutReportTree
extends AbstractReportTree {
    private ReportDocumentContext renderContext;
    private ReportUpdateHandler updateHandler = new ReportUpdateHandler();

    public LayoutReportTree() {
        this.setCellRenderer(new StructureTreeCellRenderer());
        this.setDragEnabled(false);
        this.setEditable(false);
    }

    @Override
    protected TreePath getPathForNode(Object node) {
        if (this.getStructureModel() == null) {
            return null;
        }
        return TreeSelectionHelper.getPathForNode(this.getStructureModel(), node);
    }

    @Override
    public ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    @Override
    public void setRenderContext(ReportDocumentContext renderContext) {
        if (this.renderContext != null) {
            this.renderContext.getSelectionModel().removeReportSelectionListener(this.getSelectionHandler());
            this.renderContext.getReportDefinition().removeReportModelListener((ReportModelListener)this.updateHandler);
        }
        this.renderContext = renderContext;
        if (this.renderContext != null) {
            this.renderContext.getSelectionModel().addReportSelectionListener(this.getSelectionHandler());
            this.renderContext.getReportDefinition().addReportModelListener((ReportModelListener)this.updateHandler);
        }
        this.updateFromRenderContext();
        this.restoreState();
    }

    protected void updateFromRenderContext() {
        try {
            this.setUpdateFromExternalSource(true);
            if (this.renderContext == null) {
                this.setModel(EMPTY_MODEL);
                return;
            }
            AbstractReportDefinition report = this.renderContext.getReportDefinition();
            this.setModel(new ReportStructureTreeModel(report));
        }
        finally {
            this.setUpdateFromExternalSource(false);
        }
    }

    private ReportStructureTreeModel getStructureModel() {
        TreeModel model = this.getModel();
        if (model instanceof ReportStructureTreeModel) {
            return (ReportStructureTreeModel)model;
        }
        return null;
    }

    private class ReportUpdateHandler
    implements ReportModelListener {
        private ReportUpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeChanged(ReportModelEvent event) {
            ReportStructureTreeModel model = LayoutReportTree.this.getStructureModel();
            if (model == null) {
                return;
            }
            try {
                if (event.isNodeStructureChanged() || event.isNodeAddedEvent() || event.isNodeDeleteEvent()) {
                    model.fireTreeDataChanged(event.getSource());
                } else if (event.getType() == 0) {
                    Object eventParameter = event.getParameter();
                    if (eventParameter instanceof AttributeChange) {
                        AttributeChange attributeChange = (AttributeChange)eventParameter;
                        if ("http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(attributeChange.getNamespace()) && ("name".equals(attributeChange.getName()) || "field".equals(attributeChange.getName()) || "value".equals(attributeChange.getName()) || "resource-identifier".equals(attributeChange.getName()))) {
                            LayoutReportTree.this.invalidateLayoutCache();
                        }
                        return;
                    }
                    Object element = event.getElement();
                    if (element instanceof ReportElement) {
                        StyleChange change;
                        if (element instanceof Section && eventParameter instanceof StyleChange && BandStyleKeys.LAYOUT.equals((Object)(change = (StyleChange)eventParameter).getStyleKey())) {
                            LayoutReportTree.this.invalidateLayoutCache();
                            model.fireTreeStructureChanged(element);
                            return;
                        }
                        model.fireTreeNodeChanged(event.getElement());
                    } else {
                        model.fireTreeNodeChanged(event.getReport());
                    }
                }
            }
            finally {
                LayoutReportTree.this.restoreState();
            }
        }
    }
}

