/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.lineal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.editor.report.ResizeRootBandComponent;
import org.pentaho.reporting.designer.core.editor.report.RootBandRenderingModel;
import org.pentaho.reporting.designer.core.editor.report.layouting.ElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.lineal.VerticalLinealComponent;
import org.pentaho.reporting.designer.core.util.CanvasImageLoader;
import org.pentaho.reporting.engine.classic.core.PageDefinition;

public class AllVerticalLinealsComponent
extends JPanel {
    private ArrayList<VerticalLinealComponent> lineals;
    private JPanel innerCarrier;
    private RootBandRenderingModel renderContext;

    public AllVerticalLinealsComponent(RootBandRenderingModel renderContext) {
        if (renderContext == null) {
            throw new NullPointerException();
        }
        this.setLayout(new BorderLayout());
        this.renderContext = renderContext;
        this.renderContext.addChangeListener(new ReportUpdateHandler());
        this.lineals = new ArrayList();
        this.innerCarrier = new JPanel();
        this.innerCarrier.setBackground(new Color(255, 255, 255, 0));
        this.innerCarrier.setOpaque(false);
        this.innerCarrier.setLayout(new BoxLayout(this.innerCarrier, 1));
        this.add((Component)this.innerCarrier, "North");
        this.setOpaque(false);
        this.setBackground(new Color(255, 255, 255, 0));
        this.refresh();
    }

    public void refresh() {
        for (int i = 0; i < this.lineals.size(); ++i) {
            VerticalLinealComponent component = this.lineals.get(i);
            component.setPageDefinition(null, null);
        }
        this.lineals.clear();
        this.innerCarrier.removeAll();
        ElementRenderer[] allRenderers = this.renderContext.getAllRenderers();
        PageDefinition definition = this.renderContext.getPageDefinition();
        for (int i = 0; i < allRenderers.length; ++i) {
            ElementRenderer renderer = allRenderers[i];
            boolean showBorder = false;
            VerticalLinealComponent c = new VerticalLinealComponent(false, this.renderContext.getRenderContext());
            c.setPageDefinition(definition, renderer);
            this.lineals.add(c);
            this.innerCarrier.add(c);
            this.innerCarrier.add(new ResizeRootBandComponent(false, renderer, this.renderContext.getRenderContext()));
        }
        this.innerCarrier.add(new BottomImageBorder());
        this.innerCarrier.invalidate();
        this.innerCarrier.revalidate();
    }

    private class BottomImageBorder
    extends JPanel {
        public BottomImageBorder() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ImageIcon leftCornerBorder = CanvasImageLoader.getInstance().getLeftCornerShadowImage();
            ImageIcon bottomBorder = CanvasImageLoader.getInstance().getBottomShadowImage();
            g.drawImage(leftCornerBorder.getImage(), this.getWidth() - 23, 0, leftCornerBorder.getIconWidth(), leftCornerBorder.getIconHeight(), null);
            g.drawImage(bottomBorder.getImage(), this.getWidth() - 15, 0, this.getWidth(), bottomBorder.getIconHeight(), null);
        }
    }

    private class ReportUpdateHandler
    implements ChangeListener {
        private ReportUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AllVerticalLinealsComponent.this.refresh();
        }
    }
}

