/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.report.layouting.DesignerTableContentProducer;
import org.pentaho.reporting.designer.core.editor.report.layouting.ReportLayouter;
import org.pentaho.reporting.designer.core.editor.report.layouting.TransferGlobalLayoutProcessStep;
import org.pentaho.reporting.designer.core.editor.report.layouting.TransferLayoutProcessStep;
import org.pentaho.reporting.designer.core.util.BreakPositionsList;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.IncompatibleFeatureException;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableLayoutProducer;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class SharedElementRenderer {
    private final ReportLayouter reportLayouter;
    private final MasterReport masterReport;
    private long minimumVersionNeeded;
    private EventListenerList listenerList;
    private LogicalPageBox pageBox;
    private TransferGlobalLayoutProcessStep transferGlobalLayoutProcessor;
    private TransferLayoutProcessStep transferLayoutProcessor;
    private Map<InstanceID, Set<InstanceID>> conflicts;
    private long layoutAge;
    private boolean lastResult;
    private boolean warnMigration;
    private TableLayoutProducer tableLayoutProducer;
    private DesignerTableContentProducer tableContentProducer;

    public SharedElementRenderer(ReportRenderContext reportRenderContext) {
        if (reportRenderContext == null) {
            throw new NullPointerException();
        }
        this.masterReport = reportRenderContext.getMasterReportElement();
        if (this.masterReport == null) {
            throw new NullPointerException();
        }
        this.warnMigration = true;
        this.reportLayouter = new ReportLayouter(reportRenderContext);
        this.listenerList = new EventListenerList();
        this.transferGlobalLayoutProcessor = new TransferGlobalLayoutProcessStep();
        this.transferLayoutProcessor = new TransferLayoutProcessStep();
        this.conflicts = new HashMap<InstanceID, Set<InstanceID>>();
        this.minimumVersionNeeded = -1L;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public void fireChangeEvent() {
        ChangeEvent ce = new ChangeEvent(this);
        ChangeListener[] changeListeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener listener = changeListeners[i];
            listener.stateChanged(ce);
        }
    }

    protected OutputProcessorMetaData getOutputProcessorMetaData() {
        return this.reportLayouter.getOutputProcessorMetaData();
    }

    public boolean isLayoutValid() {
        return this.layoutAge == this.masterReport.getChangeTracker();
    }

    public boolean performLayouting() {
        if (this.isLayoutValid()) {
            return this.lastResult;
        }
        try {
            this.pageBox = this.reportLayouter.layout();
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)new ReportProcessingException("Fatal Layouter Error: This report cannot be processed due to a unrecoverable error in the reporting-engine. Please file a bug-report.", e));
            if (this.warnMigration) {
                IncompatibleFeatureException ife = this.extractIncompatibleFeatureException(e);
                if (ife != null) {
                    this.minimumVersionNeeded = ife.getMinimumVersionNeeded();
                }
                this.warnMigration = false;
            }
            this.pageBox = null;
        }
        this.transferGlobalLayoutProcessor.reset();
        try {
            if (this.pageBox != null) {
                OutputProcessorMetaData outputProcessorMetaData = this.getOutputProcessorMetaData();
                if (this.tableLayoutProducer == null) {
                    this.tableLayoutProducer = new TableLayoutProducer(outputProcessorMetaData);
                    this.tableLayoutProducer.setProcessWatermark(false);
                } else {
                    this.tableLayoutProducer.clear();
                }
                this.tableLayoutProducer.update(this.pageBox, false);
                if (this.tableContentProducer == null) {
                    this.tableContentProducer = new DesignerTableContentProducer(this.tableLayoutProducer.getLayout(), outputProcessorMetaData);
                } else {
                    this.tableContentProducer.reset(this.tableLayoutProducer.getLayout());
                }
                this.conflicts.clear();
                this.conflicts = this.tableContentProducer.computeConflicts(this.pageBox, this.conflicts);
                this.tableLayoutProducer.computeDesigntimeConflicts((RenderBox)this.pageBox.getWatermarkArea());
                SheetLayout watermarkLayout = this.tableLayoutProducer.getLayout();
                this.tableContentProducer.reset(watermarkLayout);
                this.conflicts = this.tableContentProducer.computeWatermarkConflics(this.pageBox, this.conflicts);
                this.transferGlobalLayoutProcessor.performTransfer(this.pageBox, this.conflicts, this.masterReport);
            }
            this.lastResult = true;
            this.layoutAge = this.masterReport.getChangeTracker();
            this.fireChangeEvent();
            return true;
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            this.lastResult = false;
            this.layoutAge = this.masterReport.getChangeTracker();
            this.fireChangeEvent();
            return false;
        }
    }

    public long getMinimumVersionNeeded() {
        return this.minimumVersionNeeded;
    }

    public boolean isMigrationError() {
        return this.minimumVersionNeeded != -1L;
    }

    public void clearMigrationError() {
        this.minimumVersionNeeded = -1L;
    }

    private IncompatibleFeatureException extractIncompatibleFeatureException(Throwable e) {
        while (e != null) {
            if (e instanceof IncompatibleFeatureException) {
                return (IncompatibleFeatureException)e;
            }
            if (e == e.getCause()) {
                return null;
            }
            e = e.getCause();
        }
        return null;
    }

    public void transferLocalLayout(Section section, Map<InstanceID, Element> elementsById, BreakPositionsList verticalEdgePositions) {
        elementsById.clear();
        verticalEdgePositions.clear();
        if (this.pageBox != null) {
            this.transferLayoutProcessor.performTransfer(section, this.pageBox, elementsById, verticalEdgePositions);
        }
    }

    public Map<InstanceID, Element> getElementsById() {
        return this.transferGlobalLayoutProcessor.getElementsById();
    }

    public Map<InstanceID, Set<InstanceID>> getConflicts() {
        return this.conflicts;
    }

    public BreakPositionsList getHorizontalEdgePositions() {
        return this.transferGlobalLayoutProcessor.getHorizontalEdgePositions();
    }

    public ReportLayouter getLayouter() {
        return this.reportLayouter;
    }

    public LogicalPageBox getPageBox() {
        return this.pageBox;
    }

    public Rectangle2D getFallbackBounds() {
        return new Rectangle2D.Float(0.0f, 0.0f, this.masterReport.getPageDefinition().getWidth(), 0.0f);
    }
}

