/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.elements;

import java.util.Locale;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.AbstractReportElementDragHandler;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;

public class DefaultReportElementDragHandler
extends AbstractReportElementDragHandler {
    @Override
    protected Element createElement(ElementMetaData elementMetaData, String fieldName, ReportDocumentContext context) throws InstantiationException {
        ElementType type = elementMetaData.create();
        Element visualElement = (Element)type.create();
        ElementStyleSheet styleSheet = visualElement.getStyle();
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)DEFAULT_WIDTH);
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)DEFAULT_HEIGHT);
        type.configureDesignTimeDefaults((ReportElement)visualElement, Locale.getDefault());
        if (elementMetaData.getAttributeDescription("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field") != null) {
            visualElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", (Object)fieldName);
        }
        this.configureWizardProperties(fieldName, context, visualElement);
        return visualElement;
    }

    private void configureWizardProperties(String fieldName, ReportDocumentContext context, Element visualElement) {
        ContextAwareDataSchemaModel model = context.getReportDataSchemaModel();
        if (fieldName == null) {
            return;
        }
        DataAttributes attributes = model.getDataSchema().getAttributes(fieldName);
        String source = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, model.getDataAttributeContext());
        if (!"table".equals(source)) {
            return;
        }
        AbstractReportDefinition report = context.getReportDefinition();
        DataFactory dataFactory = ModelUtility.findDataFactoryForQuery(report, report.getQuery());
        if (dataFactory == null) {
            return;
        }
        DataFactoryMetaData data = dataFactory.getMetaData();
        if (data.isFormattingMetaDataSource()) {
            visualElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", (Object)Boolean.TRUE);
            visualElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", (Object)Boolean.TRUE);
        }
    }
}

