/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.elements;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.elements.InsertCrosstabGroupAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.editor.report.elements.AbstractSubreportHandler;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.BandedSubreportEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;

public class CrosstabConfigureHandler
extends AbstractSubreportHandler<CrosstabElement> {
    public CrosstabConfigureHandler(CrosstabElement subReport, Band parent, ReportElementEditorContext dragContext, boolean rootband) {
        super(subReport, parent, dragContext, rootband);
    }

    public CrosstabConfigureHandler(CrosstabElement subReport, Band parent, ReportDesignerContext designerContext, ReportDocumentContext renderContext) {
        super(subReport, parent, designerContext, renderContext);
    }

    @Override
    boolean showConfirmationDialog() {
        UndoManager undo = this.renderContext.getUndo();
        if (this.rootband) {
            int result = JOptionPane.showOptionDialog(this.component, Messages.getString("CrosstabReportElementDragHandler.BandedOrInlineSubreportQuestion", new Object[0]), Messages.getString("CrosstabReportElementDragHandler.InsertSubreport", new Object[0]), 1, -1, null, new String[]{Messages.getString("CrosstabReportElementDragHandler.Inline", new Object[0]), Messages.getString("CrosstabReportElementDragHandler.Banded", new Object[0]), Messages.getString("CrosstabReportElementDragHandler.Cancel", new Object[0])}, Messages.getString("CrosstabReportElementDragHandler.Inline", new Object[0]));
            if (result == -1 || result == 2) {
                return false;
            }
            if (result == 0) {
                undo.addChange(Messages.getString("CrosstabReportElementDragHandler.UndoEntry", new Object[0]), new ElementEditUndoEntry(this.parent.getObjectID(), this.parent.getElementCount(), null, (Element)this.subReport));
                this.parent.addElement((Element)this.subReport);
            } else {
                AbstractRootLevelBand arb = (AbstractRootLevelBand)this.parent;
                undo.addChange(Messages.getString("CrosstabReportElementDragHandler.UndoEntry", new Object[0]), new BandedSubreportEditUndoEntry(this.parent.getObjectID(), arb.getSubReportCount(), null, this.subReport));
                arb.addSubReport(this.subReport);
            }
        } else {
            undo.addChange(Messages.getString("CrosstabReportElementDragHandler.UndoEntry", new Object[0]), new ElementEditUndoEntry(this.parent.getObjectID(), this.parent.getElementCount(), null, (Element)this.subReport));
            this.parent.addElement((Element)this.subReport);
        }
        return true;
    }

    @Override
    void createSubReportTab() {
        AbstractReportDefinition reportDefinition = this.designerContext.getActiveContext().getReportDefinition();
        try {
            ((CrosstabElement)this.subReport).setDataFactory(reportDefinition.getDataFactory());
            ((CrosstabElement)this.subReport).getReportDefinition().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "zoom", (Object)Float.valueOf(1.5f));
            int idx = this.designerContext.addSubReport(this.designerContext.getActiveContext(), this.subReport);
            this.designerContext.setActiveDocument(this.designerContext.getReportRenderContext(idx));
        }
        catch (ReportDataFactoryException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    @Override
    void doSetQuery(String queryName) {
        InsertCrosstabGroupAction crosstabAction = new InsertCrosstabGroupAction();
        crosstabAction.setReportDesignerContext(this.designerContext);
        crosstabAction.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    public static void configureDefaults(CrosstabElement visualElement) {
        visualElement.setAutoSort(Boolean.TRUE);
        visualElement.getPageHeader().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getReportHeader().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getReportFooter().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getPageFooter().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        visualElement.getWatermark().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
    }
}

