/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.drag;

import java.awt.geom.Point2D;
import java.util.List;
import org.pentaho.reporting.designer.core.editor.report.drag.AbstractMouseDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.SnapPositionsModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class ResizeRightDragOperation
extends AbstractMouseDragOperation {
    private long snapThreshold = WorkspaceSettings.getInstance().getSnapThreshold();

    public ResizeRightDragOperation(List<Element> selectedVisualElements, Point2D originPoint, SnapPositionsModel horizontalSnapModel, SnapPositionsModel verticalSnapModel) {
        super(selectedVisualElements, originPoint, horizontalSnapModel, verticalSnapModel);
    }

    @Override
    public void update(Point2D normalizedPoint, double zoomFactor) {
        SnapPositionsModel horizontalSnapModel = this.getHorizontalSnapModel();
        Element[] selectedVisualElements = this.getSelectedVisualElements();
        long originPointX = this.getOriginPointX();
        long[] elementWidth = this.getElementWidth();
        long px = StrictGeomUtility.toInternalValue((double)normalizedPoint.getX());
        long dx = px - originPointX;
        for (int i = 0; i < selectedVisualElements.length; ++i) {
            Element element = selectedVisualElements[i];
            if (element instanceof RootLevelBand) continue;
            ElementStyleSheet styleSheet = element.getStyle();
            double elementMinWidth = styleSheet.getDoubleStyleProperty(ElementStyleKeys.MIN_WIDTH, 0.0);
            long targetWidth = elementWidth[i] + dx;
            CachedLayoutData data = ModelUtility.getCachedLayoutData(element);
            long elementX = data.getX();
            long targetX2 = elementX + targetWidth;
            if (elementMinWidth >= 0.0) {
                float position;
                long localWidth;
                long snapPosition = horizontalSnapModel.getNearestSnapPosition(targetX2, element.getObjectID());
                if (Math.abs(snapPosition - targetX2) > this.snapThreshold) {
                    localWidth = Math.max(0L, targetX2 - elementX);
                    position = (float)StrictGeomUtility.toExternalValue((long)localWidth);
                    styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(position));
                } else {
                    localWidth = Math.max(0L, snapPosition - elementX);
                    position = (float)StrictGeomUtility.toExternalValue((long)localWidth);
                    styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(position));
                }
            } else {
                Section parent = element.getParentSection();
                CachedLayoutData parentData = ModelUtility.getCachedLayoutData((Element)parent);
                long parentBase = parentData.getWidth();
                if (parentBase > 0L) {
                    long percentage;
                    long localWidth;
                    long snapPosition = horizontalSnapModel.getNearestSnapPosition(targetX2, element.getObjectID());
                    if (Math.abs(snapPosition - targetX2) > this.snapThreshold) {
                        localWidth = Math.max(0L, targetX2 - elementX);
                        percentage = StrictGeomUtility.toInternalValue((double)(localWidth * 100L / parentBase));
                        styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                    } else {
                        localWidth = Math.max(0L, snapPosition - elementX);
                        percentage = StrictGeomUtility.toInternalValue((double)(localWidth * 100L / parentBase));
                        styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                    }
                }
            }
            element.notifyNodePropertiesChanged();
        }
    }

    @Override
    public void finish() {
    }
}

