/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ZoomModel;
import org.pentaho.reporting.designer.core.editor.ZoomModelListener;
import org.pentaho.reporting.designer.core.editor.preview.DesignerPreviewPane;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportParameterValidationException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ReportPreviewComponent
extends JPanel {
    private PreviewPane previewPane;
    private ZoomModel zoomModel;
    private ZoomUpdateHandler zoomUpdateHandler;
    private ReportProgressDialog progressDialog;
    private ReportProgressBar progressBar;

    public ReportPreviewComponent(ReportDesignerContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setBackground(new Color(0, 0, 0, 0));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.zoomUpdateHandler = new ZoomUpdateHandler();
        this.previewPane = new DesignerPreviewPane(context);
        this.previewPane.setOpaque(false);
        this.previewPane.setBackground(new Color(0, 0, 0, 0));
        this.previewPane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.previewPane.addPropertyChangeListener((PropertyChangeListener)new StatusHandler(this.previewPane, context));
        this.add((Component)this.previewPane, "Center");
        Component parent = context.getView().getParent();
        this.progressDialog = parent instanceof Dialog ? new ReportProgressDialog((Dialog)parent) : (parent instanceof Frame ? new ReportProgressDialog((Frame)parent) : new ReportProgressDialog());
        this.progressDialog.pack();
        this.progressBar = new ReportProgressBar();
        this.progressBar.setVisible(false);
        this.previewPane.addReportProgressListener((ReportProgressListener)this.progressBar);
    }

    public void updatePreview(ReportDocumentContext reportRenderContext) {
        if (this.zoomModel != null) {
            this.zoomModel.removeZoomModelListener(this.zoomUpdateHandler);
            this.previewPane.removePropertyChangeListener("zoom", (PropertyChangeListener)this.zoomUpdateHandler);
        }
        if (reportRenderContext == null) {
            this.previewPane.setReportJob(null);
            this.zoomModel = null;
        } else {
            MasterReport reportDialog = (MasterReport)reportRenderContext.getContextRoot();
            this.previewPane.setReportJob(reportDialog);
            this.zoomModel = reportRenderContext.getZoomModel();
            this.zoomModel.addZoomModelListener(this.zoomUpdateHandler);
            this.previewPane.addPropertyChangeListener("zoom", (PropertyChangeListener)this.zoomUpdateHandler);
            this.previewPane.setZoom((double)this.zoomModel.getZoomAsPercentage());
            EventQueue.invokeLater(new RequestFocusTask());
        }
    }

    public void setZoom(double zoomFactor) {
        this.previewPane.setZoom(zoomFactor);
    }

    public double getZoom() {
        return this.previewPane.getZoom();
    }

    public void dispose() {
        this.previewPane.setClosed(true);
    }

    private class ZoomUpdateHandler
    implements ZoomModelListener,
    PropertyChangeListener {
        private ZoomUpdateHandler() {
        }

        @Override
        public void zoomFactorChanged() {
            if (ReportPreviewComponent.this.zoomModel == null) {
                return;
            }
            ReportPreviewComponent.this.setZoom(ReportPreviewComponent.this.zoomModel.getZoomAsPercentage());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("zoom".equals(evt.getPropertyName())) {
                float factor = (float)ReportPreviewComponent.this.previewPane.getZoom();
                if (ReportPreviewComponent.this.zoomModel.getZoomAsPercentage() != factor) {
                    ReportPreviewComponent.this.zoomModel.setZoomAsPercentage(factor);
                }
            }
        }
    }

    private class RequestFocusTask
    implements Runnable {
        private RequestFocusTask() {
        }

        @Override
        public void run() {
            ReportPreviewComponent.this.requestFocusInWindow();
        }
    }

    private class StatusHandler
    implements PropertyChangeListener {
        private PreviewPane previewPane;
        private ReportDesignerContext context;

        private StatusHandler(PreviewPane previewPane, ReportDesignerContext context) {
            this.previewPane = previewPane;
            this.context = context;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName;
            if ("statusText".equals(evt.getPropertyName())) {
                this.context.setStatusText(this.previewPane.getStatusText());
            }
            if ("error".equals(propertyName = evt.getPropertyName())) {
                Throwable error = this.previewPane.getError();
                if (error != null && !(error instanceof ReportParameterValidationException) && !(error instanceof ReportInterruptedException)) {
                    UncaughtExceptionsModel.getInstance().addException(error);
                }
                return;
            }
            if ("statusText".equals(propertyName) || "statusType".equals(propertyName)) {
                this.context.setStatusText(this.previewPane.getStatusText());
                return;
            }
            if ("paginating".equals(propertyName)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    this.context.setStatusText("Paginating...");
                    if (ReportPreviewComponent.this.progressBar != null) {
                        this.previewPane.addReportProgressListener((ReportProgressListener)ReportPreviewComponent.this.progressBar);
                        ReportPreviewComponent.this.progressBar.setOnlyPagination(true);
                        ReportPreviewComponent.this.progressBar.setVisible(true);
                        ReportPreviewComponent.this.progressBar.revalidate();
                    }
                    if (ReportPreviewComponent.this.progressDialog != null) {
                        this.previewPane.addReportProgressListener((ReportProgressListener)ReportPreviewComponent.this.progressDialog);
                        LibSwingUtil.centerDialogInParent((Dialog)ReportPreviewComponent.this.progressDialog);
                        ReportPreviewComponent.this.progressDialog.setOnlyPagination(true);
                        ReportPreviewComponent.this.progressDialog.setVisible(true);
                        ReportPreviewComponent.this.progressDialog.toFront();
                    }
                } else {
                    this.context.setStatusText("");
                    if (ReportPreviewComponent.this.progressBar != null) {
                        ReportPreviewComponent.this.progressBar.setOnlyPagination(false);
                        ReportPreviewComponent.this.progressBar.setVisible(false);
                        this.previewPane.removeReportProgressListener((ReportProgressListener)ReportPreviewComponent.this.progressBar);
                        ReportPreviewComponent.this.progressBar.revalidate();
                    }
                    if (ReportPreviewComponent.this.progressDialog != null) {
                        this.previewPane.removeReportProgressListener((ReportProgressListener)ReportPreviewComponent.this.progressDialog);
                        ReportPreviewComponent.this.progressDialog.setOnlyPagination(false);
                        ReportPreviewComponent.this.progressDialog.dispose();
                    }
                }
            }
        }
    }
}

