/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.parameters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.ReportDesignerDocumentContext;
import org.pentaho.reporting.designer.core.actions.global.DeleteAction;
import org.pentaho.reporting.designer.core.actions.report.AddDataFactoryAction;
import org.pentaho.reporting.designer.core.actions.report.EditQueryAction;
import org.pentaho.reporting.designer.core.editor.parameters.DataFactoryTreeCellRenderer;
import org.pentaho.reporting.designer.core.editor.parameters.DataFactoryTreeModel;
import org.pentaho.reporting.designer.core.editor.parameters.DataFactoryWrapper;
import org.pentaho.reporting.designer.core.editor.parameters.Messages;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.DataFactoryChange;
import org.pentaho.reporting.engine.classic.core.designtime.DataSourcePlugin;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;

public class ProvisionDataSourcePanel
extends JPanel {
    private JTree availableDataSources;
    private DataFactoryTreeModel availableDataSourcesModel = new DataFactoryTreeModel();
    private ReportDesignerContext reportDesignerContext;

    public boolean isDataSourceSelected() {
        TreePath selectionPath = this.availableDataSources.getSelectionPath();
        if (selectionPath == null) {
            return false;
        }
        return selectionPath.getLastPathComponent() instanceof DataFactoryWrapper;
    }

    public DataFactory getSelectedDataSource() {
        TreePath selectionPath = this.availableDataSources.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        int size = selectionPath.getPathCount();
        if (size >= 2) {
            DataFactoryWrapper dataFactoryWrapper = (DataFactoryWrapper)selectionPath.getPathComponent(1);
            return dataFactoryWrapper.getEditedDataFactory();
        }
        return null;
    }

    private void createDataSourceMenu(JComponent insertDataSourcesMenu) {
        DataFactoryMetaData[] datas = DataFactoryRegistry.getInstance().getAll();
        HashMap<String, Boolean> groupMap = new HashMap<String, Boolean>();
        for (int i = 0; i < datas.length; ++i) {
            DataFactoryMetaData data = datas[i];
            if (data.isHidden() || !data.isEditorAvailable()) continue;
            String currentGrouping = data.getGrouping(Locale.getDefault());
            groupMap.put(currentGrouping, groupMap.containsKey(currentGrouping));
        }
        Arrays.sort(datas, new GroupedMetaDataComparator());
        String grouping = null;
        JMenu subMenu = null;
        boolean firstElement = true;
        for (int i = 0; i < datas.length; ++i) {
            DataFactoryMetaData data = datas[i];
            if (data.isHidden() || !data.isEditorAvailable() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
            String currentGrouping = data.getGrouping(Locale.getDefault());
            Boolean isMultiGrouping = (Boolean)groupMap.get(currentGrouping);
            if (!firstElement) {
                if (!ObjectUtilities.equal((Object)currentGrouping, grouping)) {
                    grouping = currentGrouping;
                    if (isMultiGrouping.booleanValue()) {
                        subMenu = new JMenu(currentGrouping);
                        insertDataSourcesMenu.add(subMenu);
                    }
                }
            } else {
                firstElement = false;
                grouping = currentGrouping;
                if (isMultiGrouping.booleanValue()) {
                    subMenu = new JMenu(currentGrouping);
                    insertDataSourcesMenu.add(subMenu);
                }
            }
            AddDataSourceAction action = new AddDataSourceAction(data);
            if (isMultiGrouping.booleanValue()) {
                subMenu.add(new JMenuItem(action));
                continue;
            }
            insertDataSourcesMenu.add(new JMenuItem(action));
        }
    }

    public ProvisionDataSourcePanel() {
        this.availableDataSources = new JTree(this.availableDataSourcesModel);
        this.availableDataSources.getSelectionModel().setSelectionMode(1);
        this.availableDataSources.setCellRenderer(new DataFactoryTreeCellRenderer());
        this.availableDataSources.setRootVisible(false);
        this.init();
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
    }

    public void importDataSourcesFromMaster(CompoundDataFactory cdf) {
        this.availableDataSourcesModel.importFromReport(cdf);
    }

    public DataFactoryTreeModel getDataFactoryTreeModel() {
        return this.availableDataSourcesModel;
    }

    public JTree getDataSourcesTree() {
        return this.availableDataSources;
    }

    public String getSelectedQueryName() {
        Object node = this.availableDataSources.getLastSelectedPathComponent();
        if (node != null) {
            return node.toString();
        }
        return "";
    }

    public void expandAllNodes() {
        for (int i = 0; i < this.availableDataSources.getRowCount(); ++i) {
            this.availableDataSources.expandRow(i);
        }
    }

    protected void init() {
        RemoveDataSourceAction removeAction = new RemoveDataSourceAction();
        EditDataSourceAction editDataSourceAction = new EditDataSourceAction();
        ShowAddDataSourcePopupAction showAddDataSourcePopupAction = new ShowAddDataSourcePopupAction();
        this.availableDataSources.addTreeSelectionListener(editDataSourceAction);
        this.availableDataSources.addTreeSelectionListener(removeAction);
        JScrollPane theScrollPanel = new JScrollPane(this.availableDataSources);
        theScrollPanel.setAutoscrolls(true);
        JPanel theDataSetsButtonPanel = new JPanel();
        theDataSetsButtonPanel.setLayout(new FlowLayout(2));
        theDataSetsButtonPanel.add((Component)new BorderlessButton((Action)showAddDataSourcePopupAction));
        theDataSetsButtonPanel.add((Component)new BorderlessButton((Action)editDataSourceAction));
        theDataSetsButtonPanel.add((Component)new BorderlessButton((Action)removeAction));
        JPanel theControlsPanel = new JPanel(new BorderLayout());
        theControlsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.DataSources", new Object[0])), "West");
        theControlsPanel.add((Component)theDataSetsButtonPanel, "East");
        JPanel dataSetsPanel = new JPanel(new BorderLayout());
        dataSetsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        dataSetsPanel.add((Component)theScrollPanel, "Center");
        dataSetsPanel.add((Component)theControlsPanel, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)dataSetsPanel, "Center");
    }

    private class DataSourceDesignTimeContext
    implements DesignTimeContext {
        public AbstractReportDefinition getReport() {
            return (AbstractReportDefinition)ProvisionDataSourcePanel.this.reportDesignerContext.getActiveContext().getContextRoot();
        }

        public Window getParentWindow() {
            return LibSwingUtil.getWindowAncestor((Component)ProvisionDataSourcePanel.this);
        }

        public DataSchemaModel getDataSchemaModel() {
            return ProvisionDataSourcePanel.this.reportDesignerContext.getActiveContext().getReportDataSchemaModel();
        }

        public void error(Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }

        public void userError(Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }

        public LocaleSettings getLocaleSettings() {
            return WorkspaceSettings.getInstance();
        }

        public boolean isShowExpertItems() {
            return WorkspaceSettings.getInstance().isShowExpertItems();
        }

        public boolean isShowDeprecatedItems() {
            return WorkspaceSettings.getInstance().isShowDeprecatedItems();
        }

        public DataFactoryContext getDataFactoryContext() {
            return new DesignTimeDataFactoryContext((MasterReport)ProvisionDataSourcePanel.this.reportDesignerContext.getActiveContext().getContextRoot());
        }

        public MaturityLevel getMaturityLevel() {
            return WorkspaceSettings.getInstance().getMaturityLevel();
        }
    }

    private static class DataTabSetVisible
    implements Runnable {
        private ReportDesignerContext designerContext;
        private ReportDesignerDocumentContext<?> activeContext;

        public DataTabSetVisible(ReportDesignerContext designerContext, ReportDesignerDocumentContext<?> activeContext) {
            this.designerContext = designerContext;
            this.activeContext = activeContext;
        }

        @Override
        public void run() {
            if (this.activeContext == null) {
                return;
            }
            this.designerContext.setActiveDocument(this.activeContext);
            this.designerContext.getView().showDataTree();
        }
    }

    private class AddDataSourceAction
    extends AbstractAction {
        private DataFactoryMetaData dataSourcePlugin;

        private AddDataSourceAction(DataFactoryMetaData dataSourcePlugin) {
            this.dataSourcePlugin = dataSourcePlugin;
            this.putValue("Name", dataSourcePlugin.getDisplayName(Locale.getDefault()));
            this.putValue("ShortDescription", dataSourcePlugin.getDescription(Locale.getDefault()));
            Image image = dataSourcePlugin.getIcon(Locale.getDefault(), 2);
            if (image != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSourcePlugin editor = this.dataSourcePlugin.createEditor();
            if (editor == null) {
                return;
            }
            DataFactory dataFactory = editor.performEdit((DesignTimeContext)new DataSourceDesignTimeContext(), null, null, null);
            if (dataFactory == null) {
                return;
            }
            AddDataFactoryAction.addDataFactory(ProvisionDataSourcePanel.this.reportDesignerContext.getActiveContext(), dataFactory, new DataFactoryChange[0]);
            ProvisionDataSourcePanel.this.availableDataSourcesModel.add(new DataFactoryWrapper(null, dataFactory));
            ProvisionDataSourcePanel.this.expandAllNodes();
            SwingUtilities.invokeLater(new DataTabSetVisible(ProvisionDataSourcePanel.this.reportDesignerContext, ProvisionDataSourcePanel.this.reportDesignerContext.getActiveContext()));
        }
    }

    private final class ShowAddDataSourcePopupAction
    extends AbstractAction {
        public ShowAddDataSourcePopupAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = new JPopupMenu();
            ProvisionDataSourcePanel.this.createDataSourceMenu(menu);
            Object source = e.getSource();
            if (source instanceof Component) {
                Component c = (Component)source;
                menu.show(c, 0, c.getHeight());
            } else {
                menu.show(ProvisionDataSourcePanel.this, 0, 0);
            }
        }
    }

    private class EditDataSourceAction
    extends AbstractAction
    implements TreeSelectionListener {
        private EditDataSourceAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getEditIcon());
            this.putValue("ShortDescription", Messages.getString("ParameterDialog.EditDataSourceAction", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (ProvisionDataSourcePanel.this.getSelectedDataSource() == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataFactory dataFactory = ProvisionDataSourcePanel.this.getSelectedDataSource();
            if (dataFactory == null) {
                return;
            }
            DataFactoryMetaData metadata = dataFactory.getMetaData();
            if (!metadata.isEditable()) {
                return;
            }
            ProvisionDataSourcePanel.this.reportDesignerContext.getActiveContext().getSelectionModel().setSelectedElements(new Object[]{dataFactory});
            EditQueryAction editQueryAction = new EditQueryAction();
            editQueryAction.setReportDesignerContext(ProvisionDataSourcePanel.this.reportDesignerContext);
            editQueryAction.actionPerformed(new ActionEvent(this, 1001, ""));
            int idx = ProvisionDataSourcePanel.this.availableDataSourcesModel.indexOf(dataFactory);
            if (idx == -1) {
                throw new IllegalStateException("DataSource Model is out of sync with the GUI");
            }
            if (editQueryAction.getEditedDataFactory() != null) {
                ProvisionDataSourcePanel.this.availableDataSourcesModel.edit(idx, editQueryAction.getEditedDataFactory());
            }
        }
    }

    private class RemoveDataSourceAction
    extends AbstractAction
    implements TreeSelectionListener {
        public RemoveDataSourceAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.putValue("ShortDescription", Messages.getString("ParameterDialog.DeleteDataSourceAction", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.setEnabled(ProvisionDataSourcePanel.this.isDataSourceSelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = JOptionPane.showConfirmDialog(ProvisionDataSourcePanel.this, Messages.getString("ParameterDialog.DeleteDataSourceWarningMessage", new Object[0]), Messages.getString("ParameterDialog.DeleteDataSourceWarningTitle", new Object[0]), 0);
            if (result == 0) {
                DataFactory theSelectedDataFactory = ProvisionDataSourcePanel.this.getSelectedDataSource();
                ProvisionDataSourcePanel.this.reportDesignerContext.getActiveContext().getSelectionModel().setSelectedElements(new Object[]{theSelectedDataFactory});
                DeleteAction deleteAction = new DeleteAction();
                deleteAction.setReportDesignerContext(ProvisionDataSourcePanel.this.reportDesignerContext);
                deleteAction.actionPerformed(new ActionEvent(this, 1001, ""));
                ProvisionDataSourcePanel.this.availableDataSourcesModel.remove(theSelectedDataFactory);
            }
        }
    }
}

