/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.parameters;

import com.google.common.annotations.VisibleForTesting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.parameters.ClassComboBoxEditor;
import org.pentaho.reporting.designer.core.editor.parameters.ClassListCellRenderer;
import org.pentaho.reporting.designer.core.editor.parameters.DataFactoryTreeModel;
import org.pentaho.reporting.designer.core.editor.parameters.DataFactoryWrapper;
import org.pentaho.reporting.designer.core.editor.parameters.DefaultValueEditorPanel;
import org.pentaho.reporting.designer.core.editor.parameters.Messages;
import org.pentaho.reporting.designer.core.editor.parameters.ParameterType;
import org.pentaho.reporting.designer.core.editor.parameters.ProvisionDataSourcePanel;
import org.pentaho.reporting.designer.core.editor.parameters.StaticTextComboBoxModel;
import org.pentaho.reporting.designer.core.settings.ui.ValidationMessage;
import org.pentaho.reporting.designer.core.settings.ui.ValidationResult;
import org.pentaho.reporting.designer.core.util.FormulaEditorDataModel;
import org.pentaho.reporting.designer.core.util.FormulaEditorPanel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.engine.classic.core.DefaultResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.parameters.AbstractParameter;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.PlainParameter;
import org.pentaho.reporting.engine.classic.core.parameters.StaticListParameter;
import org.pentaho.reporting.engine.classic.core.states.NoOpPerformanceMonitorContext;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class ParameterDialog
extends CommonDialog
implements FormulaEditorDataModel {
    private static final ValidationMessage.Severity[] ALL_SEVERITIES = new ValidationMessage.Severity[]{ValidationMessage.Severity.WARN, ValidationMessage.Severity.ERROR};
    private static final Class[] DEFAULT_CLASSES = new Class[]{String.class, Boolean.class, Number.class, Date.class, java.sql.Date.class, Time.class, Timestamp.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Byte.class, BigInteger.class, BigDecimal.class, TableModel.class, Object.class};
    private ReportDesignerContext reportDesignerContext;
    private ProvisionDataSourcePanel provisionDataSourcePanel;
    private JTextField nameTextField;
    @VisibleForTesting
    JTextField labelTextField;
    private DefaultValueEditorPanel defaultValueTextField;
    @VisibleForTesting
    JTextField dataFormatField;
    private DataFactoryTreeModel availableDataSourcesModel;
    private JComboBox idComboBox;
    private JComboBox displayValueComboBox;
    private JComboBox valueTypeComboBox;
    private JCheckBox mandatoryCheckBox;
    private JCheckBox hiddenCheckBox;
    private JCheckBox strictValuesCheckBox;
    private JCheckBox autofillSelectionCheckBox;
    private JCheckBox reevaluateOnInvalidStrictParamCheckBox;
    private JLabel displayFormulaLabel;
    private FormulaEditorPanel postProcessingFormulaField;
    private FormulaEditorPanel displayFormulaField;
    private FormulaEditorPanel defaultValueFormulaField;
    @VisibleForTesting
    FormulaEditorPanel labelFormula;
    @VisibleForTesting
    FormulaEditorPanel dataFormatFormula;
    private JSpinner visibleItemsTextField;
    private JLabel visibleItemsLabel;
    private ComboBoxModel parameterTypeModel;
    private JTree availableDataSources;
    private StaticTextComboBoxModel queryComboBoxModel;
    private ParameterContext parameterContext;
    private JLabel displayValueLabel;
    private JComboBox timeZoneBox;
    private KeyedComboBoxModel<String, String> timeZoneModel;
    private JLabel timeZoneLabel;
    private String parameter;

    public ParameterDialog(ReportDesignerContext context) {
        this.reportDesignerContext = context;
        this.init();
    }

    public ParameterDialog(Dialog aParent, ReportDesignerContext context) {
        super(aParent);
        this.reportDesignerContext = context;
        this.init();
    }

    public ParameterDialog(Frame aParent, ReportDesignerContext context) {
        super(aParent);
        this.reportDesignerContext = context;
        this.init();
    }

    protected void init() {
        this.provisionDataSourcePanel = new ProvisionDataSourcePanel();
        this.provisionDataSourcePanel.setReportDesignerContext(this.reportDesignerContext);
        this.parameterContext = new EditorParameterContext();
        this.setModal(true);
        this.availableDataSourcesModel = this.provisionDataSourcePanel.getDataFactoryTreeModel();
        this.availableDataSourcesModel.addTreeModelListener(new DataSetQueryUpdateHandler());
        this.provisionDataSourcePanel.getDataSourcesTree().addTreeSelectionListener(new QuerySelectionHandler());
        this.availableDataSources = this.provisionDataSourcePanel.getDataSourcesTree();
        this.defaultValueTextField = new DefaultValueEditorPanel();
        this.dataFormatField = new JTextField();
        TypeSelectionHandler typeSelectionHandler = new TypeSelectionHandler(this.defaultValueTextField);
        this.dataFormatField.getDocument().addDocumentListener((DocumentListener)((Object)typeSelectionHandler));
        this.nameTextField = new JTextField();
        this.labelTextField = new JTextField();
        this.mandatoryCheckBox = new JCheckBox(Messages.getString("ParameterDialog.Mandatory", new Object[0]));
        this.mandatoryCheckBox.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.hiddenCheckBox = new JCheckBox(Messages.getString("ParameterDialog.Hidden", new Object[0]));
        this.hiddenCheckBox.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.strictValuesCheckBox = new JCheckBox(Messages.getString("ParameterDialog.StrictValues", new Object[0]));
        this.strictValuesCheckBox.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.reevaluateOnInvalidStrictParamCheckBox = new JCheckBox(Messages.getString("ParameterDialog.ReevaluateOnInvalidStrictParam", new Object[0]));
        this.reevaluateOnInvalidStrictParamCheckBox.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.autofillSelectionCheckBox = new JCheckBox(Messages.getString("ParameterDialog.AutofillSelection", new Object[0]));
        this.autofillSelectionCheckBox.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.parameterTypeModel = ParameterType.createParameterTypesModel();
        this.parameterTypeModel.addListDataListener(new TypeListener());
        this.parameterTypeModel.addListDataListener(typeSelectionHandler);
        this.timeZoneModel = new KeyedComboBoxModel();
        this.timeZoneModel.setAllowOtherValue(true);
        this.timeZoneModel.add((Object)"utc", (Object)Messages.getString("ParameterDialog.UseUniversalTime", new Object[0]));
        this.timeZoneModel.add((Object)"server", (Object)Messages.getString("ParameterDialog.UseServerTimezone", new Object[0]));
        this.timeZoneModel.add((Object)"client", (Object)Messages.getString("ParameterDialog.UseClientTimezone", new Object[0]));
        Object[] timeZoneId = TimeZone.getAvailableIDs();
        Arrays.sort(timeZoneId);
        for (int i = 0; i < timeZoneId.length; ++i) {
            Object string = timeZoneId[i];
            TimeZone timeZone = TimeZone.getTimeZone((String)string);
            this.timeZoneModel.add((Object)timeZone.getID(), (Object)Messages.getString("ParameterDialog.TimeZoneLabel", timeZone.getID(), timeZone.getDisplayName()));
        }
        this.timeZoneModel.addListDataListener((ListDataListener)typeSelectionHandler);
        this.timeZoneBox = new JComboBox(this.timeZoneModel);
        this.timeZoneLabel = new JLabel(Messages.getString("ParameterDialog.TimeZone", new Object[0]));
        this.queryComboBoxModel = new StaticTextComboBoxModel();
        this.queryComboBoxModel.addListDataListener(new QuerySelectionHandler());
        this.idComboBox = new JComboBox();
        this.idComboBox.setEditable(true);
        this.displayValueLabel = new JLabel(Messages.getString("ParameterDialog.DisplayName", new Object[0]));
        this.displayValueComboBox = new JComboBox();
        this.displayValueComboBox.setEditable(true);
        this.valueTypeComboBox = new JComboBox<Class>(new DefaultComboBoxModel<Class>(DEFAULT_CLASSES));
        this.valueTypeComboBox.setEditable(true);
        this.valueTypeComboBox.setEditor(new ClassComboBoxEditor(true, DEFAULT_CLASSES));
        this.valueTypeComboBox.setRenderer(new ClassListCellRenderer());
        this.valueTypeComboBox.getModel().addListDataListener(typeSelectionHandler);
        this.visibleItemsLabel = new JLabel(Messages.getString("ParameterDialog.VisibleItems", new Object[0]));
        this.visibleItemsTextField = new JSpinner(new SpinnerNumberModel(0, 0, 50000, 1));
        this.displayFormulaLabel = new JLabel(Messages.getString("ParameterDialog.DisplayFormula", new Object[0]));
        this.displayFormulaField = new FormulaEditorPanel();
        this.displayFormulaField.setEditorDataModel(this);
        this.displayFormulaField.setLimitFields(true);
        this.postProcessingFormulaField = new FormulaEditorPanel();
        this.postProcessingFormulaField.setEditorDataModel(this);
        this.postProcessingFormulaField.setLimitFields(true);
        this.defaultValueFormulaField = new FormulaEditorPanel();
        this.defaultValueFormulaField.setEditorDataModel(this);
        this.defaultValueFormulaField.setLimitFields(true);
        this.labelFormula = new FormulaEditorPanel();
        this.labelFormula.setEditorDataModel(this);
        this.labelFormula.setLimitFields(true);
        this.dataFormatFormula = new FormulaEditorPanel();
        this.dataFormatFormula.setEditorDataModel(this);
        this.dataFormatFormula.setLimitFields(true);
        super.init();
        this.timeZoneBox.setVisible(false);
        this.timeZoneLabel.setVisible(false);
        this.displayFormulaField.setVisible(false);
        this.visibleItemsLabel.setVisible(false);
        this.visibleItemsTextField.setVisible(false);
        this.displayFormulaLabel.setVisible(false);
        this.displayValueLabel.setVisible(false);
        this.displayValueComboBox.setVisible(false);
        this.strictValuesCheckBox.setVisible(false);
        this.reevaluateOnInvalidStrictParamCheckBox.setVisible(false);
        this.autofillSelectionCheckBox.setVisible(false);
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.Parameter";
    }

    private TimeZone getSelectedTimeZone() {
        Object selectedItem = this.timeZoneModel.getSelectedKey();
        if (selectedItem == null) {
            return TimeZone.getDefault();
        }
        if ("server".equals(selectedItem) || "client".equals(selectedItem)) {
            return TimeZone.getDefault();
        }
        String id = String.valueOf(selectedItem);
        if ("utc".equals(id)) {
            return TimeZone.getTimeZone("UTC");
        }
        TimeZone timeZone = TimeZone.getTimeZone(id);
        if ("GMT".equals(timeZone.getID()) && !"GMT".equals(id)) {
            return TimeZone.getDefault();
        }
        return timeZone;
    }

    protected Component createContentPane() {
        JSplitPane mainPanel = new JSplitPane();
        mainPanel.setOrientation(1);
        mainPanel.setLeftComponent(this.provisionDataSourcePanel);
        mainPanel.setRightComponent(this.createDetailsPanel());
        mainPanel.setDividerLocation(300);
        return mainPanel;
    }

    private JPanel createDetailsPanel() {
        JComboBox queryBox = new JComboBox(this.queryComboBoxModel);
        queryBox.setEditable(true);
        JPanel detailsPanel = new JPanel(new GridBagLayout());
        detailsPanel.setBorder(BorderFactory.createEmptyBorder(30, 5, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.anchor = 21;
        gbc.gridy = 0;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.Name", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.nameTextField, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridy = 1;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.Label", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.labelTextField, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridy = 2;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.LabelFormula", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.labelFormula, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 3;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.ValueType", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.valueTypeComboBox, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 4;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.DataFormat", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.dataFormatField, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 5;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.DataFormatFormula", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.dataFormatFormula, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 6;
        gbc.gridx = 0;
        detailsPanel.add((Component)this.timeZoneLabel, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.timeZoneBox, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 7;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.DefaultValue", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.defaultValueTextField, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 8;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.DefaultValueFormula", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.defaultValueFormulaField, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 9;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.PostProcessingFormula", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.postProcessingFormulaField, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 10;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.mandatoryCheckBox, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 11;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.hiddenCheckBox, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridy = 12;
        gbc.gridx = 0;
        detailsPanel.add((Component)this.createPromptPanel(), gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 13;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.Type", new Object[0])), gbc);
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add(new JComboBox(this.parameterTypeModel), gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 14;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.Query", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add(queryBox, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 15;
        gbc.gridx = 0;
        detailsPanel.add((Component)new JLabel(Messages.getString("ParameterDialog.Id", new Object[0])), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.idComboBox, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 16;
        gbc.gridx = 0;
        detailsPanel.add((Component)this.displayValueLabel, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.displayValueComboBox, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 17;
        gbc.gridx = 0;
        detailsPanel.add((Component)this.displayFormulaLabel, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.displayFormulaField, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 18;
        gbc.gridx = 0;
        detailsPanel.add((Component)this.visibleItemsLabel, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.visibleItemsTextField, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 19;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.strictValuesCheckBox, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 20;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.reevaluateOnInvalidStrictParamCheckBox, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridy = 21;
        gbc.gridx = 1;
        detailsPanel.add((Component)this.autofillSelectionCheckBox, gbc);
        JPanel theDetailsLayoutPanel = new JPanel(new BorderLayout());
        theDetailsLayoutPanel.add((Component)detailsPanel, "North");
        return theDetailsLayoutPanel;
    }

    private Box createPromptPanel() {
        Box pane = Box.createHorizontalBox();
        pane.setBorder(BorderFactory.createEmptyBorder(15, 0, 10, 0));
        JLabel promptLabel = new JLabel(Messages.getString("ParameterDialog.Prompt", new Object[0]));
        pane.add(promptLabel);
        pane.add(Box.createRigidArea(new Dimension(10, 0)));
        JSeparator horizontalSeparator = new JSeparator();
        horizontalSeparator.setAlignmentY(0.0f);
        pane.add(horizontalSeparator);
        return pane;
    }

    @VisibleForTesting
    void updateFromParameter(ParameterDefinitionEntry p) {
        if (p == null) {
            this.dataFormatField.setText(null);
            this.labelTextField.setText(null);
            this.nameTextField.setText(null);
            this.defaultValueTextField.setValue(null, String.class);
            this.visibleItemsTextField.setValue(0);
            this.parameterTypeModel.setSelectedItem(null);
            this.availableDataSources.clearSelection();
            this.displayValueComboBox.setSelectedItem(null);
            this.valueTypeComboBox.setSelectedItem(String.class);
            this.mandatoryCheckBox.setSelected(false);
            this.hiddenCheckBox.setSelected(false);
            this.postProcessingFormulaField.setFormula(null);
            this.displayFormulaField.setFormula(null);
            this.strictValuesCheckBox.setSelected(true);
            this.timeZoneBox.setSelectedItem(null);
            this.autofillSelectionCheckBox.setSelected(false);
            this.reevaluateOnInvalidStrictParamCheckBox.setSelected(false);
            this.setSelectedQuery(null);
            return;
        }
        if (p instanceof DefaultListParameter) {
            DefaultListParameter parameter = (DefaultListParameter)p;
            String queryName = parameter.getQueryName();
            DataFactory factoryForQuery = this.findDataFactoryForQuery(queryName);
            if (factoryForQuery != null) {
                int idx = this.availableDataSourcesModel.indexOf(factoryForQuery);
                this.availableDataSources.setSelectionPath(new TreePath(new Object[]{this.availableDataSourcesModel.getRoot(), this.availableDataSourcesModel.get(idx), queryName}));
            } else {
                this.setSelectedQuery(queryName);
            }
            this.autofillSelectionCheckBox.setSelected("true".equals(parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "autofill-selection", this.parameterContext)));
            this.reevaluateOnInvalidStrictParamCheckBox.setSelected("true".equals(parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "re-evaluate-on-failed-values", this.parameterContext)));
            this.strictValuesCheckBox.setSelected(parameter.isStrictValueCheck());
            this.displayValueComboBox.setSelectedItem(parameter.getTextColumn());
            this.idComboBox.setSelectedItem(parameter.getKeyColumn());
            int visibleItems = ParserUtil.parseInt((String)parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-visible-items"), (int)0);
            this.visibleItemsTextField.setValue(visibleItems);
        } else {
            this.autofillSelectionCheckBox.setSelected(false);
            this.reevaluateOnInvalidStrictParamCheckBox.setSelected(false);
            this.strictValuesCheckBox.setSelected(true);
        }
        boolean multiSelection = p instanceof ListParameter ? ((ListParameter)p).isAllowMultiSelection() : false;
        Class<?> theType = p.getValueType();
        this.valueTypeComboBox.setSelectedItem(multiSelection ? theType.getComponentType() : theType);
        this.nameTextField.setText(p.getName());
        String labelText = p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", this.parameterContext);
        String labelFormulaText = p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label-formula", this.parameterContext);
        this.labelTextField.setText(Objects.equals(labelText, labelFormulaText) ? "" : labelText);
        this.labelFormula.setFormula(labelFormulaText);
        String dataFormatText = p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format", this.parameterContext);
        String dataFormatFormulaText = p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format-formula", this.parameterContext);
        this.dataFormatField.setText(Objects.equals(dataFormatText, dataFormatFormulaText) ? "" : dataFormatText);
        this.dataFormatFormula.setFormula(dataFormatFormulaText);
        this.mandatoryCheckBox.setSelected(p.isMandatory());
        this.postProcessingFormulaField.setFormula(p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "post-processor-formula", this.parameterContext));
        this.displayFormulaField.setFormula(p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "display-value-formula", this.parameterContext));
        String hiddenValue = p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "hidden", this.parameterContext);
        if (hiddenValue != null) {
            this.hiddenCheckBox.setSelected(hiddenValue.equals("true"));
        }
        if (p instanceof AbstractParameter) {
            AbstractParameter parameter = (AbstractParameter)p;
            this.defaultValueTextField.setValue(parameter.getDefaultValue(), parameter.getValueType());
        } else {
            this.defaultValueTextField.setValue(null, p.getValueType());
        }
        this.defaultValueFormulaField.setFormula(p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "default-value-formula", this.parameterContext));
        this.timeZoneModel.setSelectedKey((Object)p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "timezone", this.parameterContext));
        String type = p.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", this.parameterContext);
        if (type != null) {
            int size = this.parameterTypeModel.getSize();
            for (int i = 0; i < size; ++i) {
                ParameterType typeEntry = (ParameterType)this.parameterTypeModel.getElementAt(i);
                if (typeEntry == null || typeEntry.isMultiSelection() != multiSelection || !type.equals(typeEntry.getInternalName())) continue;
                this.parameterTypeModel.setSelectedItem(typeEntry);
                break;
            }
        } else {
            this.parameterTypeModel.setSelectedItem(null);
        }
    }

    private String getSelectedQuery() {
        return (String)this.queryComboBoxModel.getSelectedItem();
    }

    private void setSelectedQuery(String query) {
        this.queryComboBoxModel.setSelectedItem(query);
    }

    private ParameterDefinitionEntry createParameterResult() {
        Number visibleItemsInput;
        boolean hasVisibleItems;
        boolean queryIsOptional;
        String typeName;
        String layout;
        boolean isMultiSelect;
        String query = this.getSelectedQuery();
        String name = this.nameTextField.getText();
        String label = this.labelTextField.getText();
        Object rawDefaultValue = this.defaultValueTextField.getValue();
        String dataFormat = this.dataFormatField.getText();
        boolean isMandatory = this.mandatoryCheckBox.isSelected();
        ParameterType type = (ParameterType)this.parameterTypeModel.getSelectedItem();
        if (query == null) {
            return this.createQuerylessParameter(name, label, rawDefaultValue, dataFormat, isMandatory, type);
        }
        String keyColumn = (String)this.idComboBox.getSelectedItem();
        if (type != null) {
            isMultiSelect = type.isMultiSelection();
            layout = type.getLayout();
            typeName = type.getInternalName();
            queryIsOptional = type.isQueryOptional();
            hasVisibleItems = type.isHasVisibleItems();
        } else {
            isMultiSelect = false;
            layout = null;
            typeName = null;
            queryIsOptional = true;
            hasVisibleItems = false;
        }
        String textColumn = queryIsOptional ? keyColumn : (String)this.displayValueComboBox.getSelectedItem();
        Class<?> selectedType = (Class<?>)this.valueTypeComboBox.getSelectedItem();
        Class<?> valueType = isMultiSelect ? Array.newInstance(selectedType, 0).getClass() : selectedType;
        DefaultListParameter parameter = new DefaultListParameter(query, keyColumn, textColumn, name, isMultiSelect, this.strictValuesCheckBox.isSelected(), valueType);
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-layout", layout);
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", typeName);
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "re-evaluate-on-failed-values", String.valueOf(this.reevaluateOnInvalidStrictParamCheckBox.isSelected()));
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "autofill-selection", String.valueOf(this.autofillSelectionCheckBox.isSelected()));
        if (!StringUtils.isEmpty((String)label)) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", label);
        } else if (!StringUtils.isEmpty((String)this.labelFormula.getFormula())) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", this.labelFormula.getFormula());
        }
        parameter.setMandatory(isMandatory);
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "hidden", String.valueOf(this.hiddenCheckBox.isSelected()));
        parameter.setDefaultValue(rawDefaultValue);
        if (hasVisibleItems && (visibleItemsInput = (Number)this.visibleItemsTextField.getValue()) != null && visibleItemsInput.intValue() > 0) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-visible-items", String.valueOf(visibleItemsInput));
        }
        if (!StringUtils.isEmpty((String)dataFormat)) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format", dataFormat);
        } else if (!StringUtils.isEmpty((String)this.dataFormatFormula.getFormula())) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format", this.dataFormatFormula.getFormula());
        }
        if (!queryIsOptional) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "display-value-formula", this.displayFormulaField.getFormula());
        }
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "default-value-formula", this.defaultValueFormulaField.getFormula());
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "post-processor-formula", this.postProcessingFormulaField.getFormula());
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "timezone", (String)this.timeZoneModel.getSelectedKey());
        if (!StringUtils.isEmpty((String)this.labelFormula.getFormula())) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label-formula", this.labelFormula.getFormula());
        }
        if (!StringUtils.isEmpty((String)this.dataFormatFormula.getFormula())) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format-formula", this.dataFormatFormula.getFormula());
        }
        return parameter;
    }

    @VisibleForTesting
    ParameterDefinitionEntry createQuerylessParameter(String name, String label, Object rawDefaultValue, String dataFormat, boolean mandatory, ParameterType type) {
        PlainParameter parameter;
        Class selectedType = (Class)this.valueTypeComboBox.getSelectedItem();
        if (type == null || !type.isMultiSelection()) {
            parameter = new PlainParameter(name);
            parameter.setValueType(selectedType);
        } else {
            Class<?> valueType = Array.newInstance(selectedType, 0).getClass();
            parameter = new StaticListParameter(name, true, false, valueType);
        }
        if (type != null) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", type.getInternalName());
        }
        if (!StringUtils.isEmpty((String)label)) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", label);
        } else if (!StringUtils.isEmpty((String)this.labelFormula.getFormula())) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", this.labelFormula.getFormula());
        }
        parameter.setDefaultValue(rawDefaultValue);
        parameter.setMandatory(mandatory);
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "hidden", String.valueOf(this.hiddenCheckBox.isSelected()));
        if (!StringUtils.isEmpty((String)dataFormat)) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format", dataFormat);
        } else if (!StringUtils.isEmpty((String)this.dataFormatFormula.getFormula())) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format", this.dataFormatFormula.getFormula());
        }
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "default-value-formula", this.defaultValueFormulaField.getFormula());
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "post-processor-formula", this.postProcessingFormulaField.getFormula());
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "timezone", (String)this.timeZoneModel.getSelectedKey());
        if (!StringUtils.isEmpty((String)this.labelFormula.getFormula())) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label-formula", this.labelFormula.getFormula());
        }
        if (!StringUtils.isEmpty((String)this.dataFormatFormula.getFormula())) {
            parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format-formula", this.dataFormatFormula.getFormula());
        }
        return parameter;
    }

    private ParameterType getSelectedParameterType() {
        return (ParameterType)this.parameterTypeModel.getSelectedItem();
    }

    private DataFactory findDataFactoryForQuery(String query) {
        if (query == null) {
            return null;
        }
        QueryDataRowWrapper dataRow = new QueryDataRowWrapper((DataRow)new ReportParameterValues(), 1, 0);
        int size = this.availableDataSourcesModel.size();
        for (int i = 0; i < size; ++i) {
            DataFactory factory;
            DataFactoryWrapper factoryWrapper = this.availableDataSourcesModel.get(i);
            if (factoryWrapper.isRemoved() || !(factory = factoryWrapper.getEditedDataFactory()).isQueryExecutable(query, (DataRow)dataRow)) continue;
            return factory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterEditResult performEditParameter(ReportDesignerContext context, MasterReport masterReport, ParameterDefinitionEntry parameterDefinitionEntry) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (parameterDefinitionEntry == null) {
            this.setTitle(Messages.getString("ParameterDialog.Title.Add", new Object[0]));
            this.parameter = null;
        } else {
            this.setTitle(Messages.getString("ParameterDialog.Title.Edit", new Object[0]));
            this.parameter = parameterDefinitionEntry.getName();
        }
        try {
            this.reportDesignerContext = context;
            this.displayFormulaField.setReportDesignerContext(context);
            this.defaultValueFormulaField.setReportDesignerContext(context);
            this.postProcessingFormulaField.setReportDesignerContext(context);
            this.availableDataSourcesModel.importFromReport((CompoundDataFactory)masterReport.getDataFactory());
            this.provisionDataSourcePanel.expandAllNodes();
            this.updateFromParameter(parameterDefinitionEntry);
            if (this.performEdit()) {
                ParameterEditResult parameterEditResult = new ParameterEditResult(this.availableDataSourcesModel.toArray(), this.createParameterResult());
                return parameterEditResult;
            }
            ParameterEditResult parameterEditResult = null;
            return parameterEditResult;
        }
        finally {
            this.reportDesignerContext = null;
            this.displayFormulaField.setReportDesignerContext(null);
            this.postProcessingFormulaField.setReportDesignerContext(null);
            this.defaultValueFormulaField.setReportDesignerContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDataFields() {
        String queryName = this.getSelectedQuery();
        if (queryName == null) {
            return new String[0];
        }
        DataFactory rawDataFactory = this.findDataFactoryForQuery(queryName);
        if (rawDataFactory == null) {
            return new String[0];
        }
        try (CachingDataFactory dataFactory = new CachingDataFactory(rawDataFactory, true);){
            ReportDocumentContext activeContext = this.reportDesignerContext.getActiveContext();
            if (activeContext != null) {
                MasterReport reportDefinition = (MasterReport)activeContext.getContextRoot();
                dataFactory.initialize((DataFactoryContext)new DesignTimeDataFactoryContext(reportDefinition));
            }
            TableModel tableModel = dataFactory.queryData(queryName, (DataRow)new QueryDataRowWrapper((DataRow)new ReportParameterValues(), 1, 0));
            int colCount = tableModel.getColumnCount();
            String[] cols = new String[colCount];
            for (int i = 0; i < colCount; ++i) {
                cols[i] = tableModel.getColumnName(i);
            }
            String[] stringArray = cols;
            return stringArray;
        }
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    protected boolean validateInputs(boolean onConfirm) {
        ValidationResult validationResult = this.validate(new ValidationResult());
        ValidationMessage[] validationMessages = validationResult.getValidationMessages(ALL_SEVERITIES);
        if (validationMessages.length == 0) {
            return true;
        }
        StringBuilder messages = new StringBuilder(100);
        for (ValidationMessage validationMessage : validationMessages) {
            messages.append(validationMessage.getMessage());
            messages.append('\n');
        }
        JOptionPane.showMessageDialog((Component)((Object)this), messages, Messages.getString("ParameterDialog.ErrorTitle", new Object[0]), 2);
        return false;
    }

    private ValidationResult validate(ValidationResult validationResult) {
        if (StringUtils.isEmpty((String)this.nameTextField.getText())) {
            String nameCaption = Messages.getString("ParameterDialog.Name", new Object[0]);
            validationResult.addValidationMessage(new ValidationMessage(ValidationMessage.Severity.ERROR, Messages.getString("ParameterDialog.ValueMustBeSetMessage", nameCaption)));
        }
        if (this.dataFormatField.getText().contains("Y") && !this.dataFormatField.getText().contains("ww")) {
            String dataFormatCaption = Messages.getString("ParameterDialog.DataFormat", new Object[0]);
            validationResult.addValidationMessage(new ValidationMessage(ValidationMessage.Severity.ERROR, Messages.getString("ParameterDialog.InvalidDateFormatPattern", dataFormatCaption)));
        }
        return validationResult;
    }

    private class TypeSelectionHandler
    extends DocumentChangeHandler
    implements ListDataListener {
        private DefaultValueEditorPanel valueEditorPanel;

        private TypeSelectionHandler(DefaultValueEditorPanel valueEditorPanel) {
            this.valueEditorPanel = valueEditorPanel;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent event) {
            Object o = ParameterDialog.this.valueTypeComboBox.getSelectedItem();
            if (!(o instanceof Class)) {
                ParameterDialog.this.timeZoneLabel.setVisible(false);
                ParameterDialog.this.timeZoneBox.setVisible(false);
                this.valueEditorPanel.setValueType(String.class, null, TimeZone.getDefault());
                return;
            }
            Class<?> selectedClass = (Class<?>)o;
            ParameterType parameterType = ParameterDialog.this.getSelectedParameterType();
            Class<?> type = parameterType == null || !parameterType.isMultiSelection() ? selectedClass : Array.newInstance(selectedClass, 0).getClass();
            ParameterDialog.this.timeZoneLabel.setVisible(Date.class.isAssignableFrom(selectedClass));
            ParameterDialog.this.timeZoneBox.setVisible(Date.class.isAssignableFrom(selectedClass));
            this.valueEditorPanel.setValueType(type, ParameterDialog.this.dataFormatField.getText(), ParameterDialog.this.getSelectedTimeZone());
        }

        protected void handleChange(DocumentEvent e) {
            this.contentsChanged(null);
        }
    }

    private class EditorParameterContext
    implements ParameterContext {
        private ReportEnvironment defaultEnvironment;
        private DocumentMetaData defaultDocumentMetaData;
        private DataRow dataRow;
        private ResourceBundleFactory resourceBundleFactory;
        private ResourceManager resourceManager = new ResourceManager();

        private EditorParameterContext() {
            this.resourceBundleFactory = new DefaultResourceBundleFactory();
            this.defaultEnvironment = new DefaultReportEnvironment(ClassicEngineBoot.getInstance().getGlobalConfig());
            this.defaultDocumentMetaData = new MemoryDocumentMetaData();
            ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(this.defaultEnvironment);
            this.dataRow = new CompoundDataRow((DataRow)envDataRow, (DataRow)new StaticDataRow());
        }

        public PerformanceMonitorContext getPerformanceMonitorContext() {
            return new NoOpPerformanceMonitorContext();
        }

        public DataRow getParameterData() {
            return this.dataRow;
        }

        public DataFactory getDataFactory() {
            return ParameterDialog.this.provisionDataSourcePanel.getSelectedDataSource();
        }

        public ResourceManager getResourceManager() {
            if (ParameterDialog.this.reportDesignerContext == null) {
                return this.resourceManager;
            }
            ReportDocumentContext activeContext = ParameterDialog.this.reportDesignerContext.getActiveContext();
            if (activeContext == null) {
                return this.resourceManager;
            }
            return ((MasterReport)activeContext.getContextRoot()).getResourceManager();
        }

        public ResourceBundleFactory getResourceBundleFactory() {
            if (ParameterDialog.this.reportDesignerContext == null) {
                return this.resourceBundleFactory;
            }
            ReportDocumentContext activeContext = ParameterDialog.this.reportDesignerContext.getActiveContext();
            if (activeContext == null) {
                return this.resourceBundleFactory;
            }
            MasterReport report = (MasterReport)activeContext.getContextRoot();
            return MasterReport.computeAndInitResourceBundleFactory((ResourceBundleFactory)report.getResourceBundleFactory(), (ReportEnvironment)report.getReportEnvironment());
        }

        public Configuration getConfiguration() {
            if (ParameterDialog.this.reportDesignerContext == null) {
                return ClassicEngineBoot.getInstance().getGlobalConfig();
            }
            ReportDocumentContext activeContext = ParameterDialog.this.reportDesignerContext.getActiveContext();
            if (activeContext == null) {
                return ClassicEngineBoot.getInstance().getGlobalConfig();
            }
            return ((MasterReport)activeContext.getContextRoot()).getConfiguration();
        }

        public ResourceKey getContentBase() {
            if (ParameterDialog.this.reportDesignerContext == null) {
                return null;
            }
            ReportDocumentContext activeContext = ParameterDialog.this.reportDesignerContext.getActiveContext();
            if (activeContext == null) {
                return null;
            }
            return ((MasterReport)activeContext.getContextRoot()).getContentBase();
        }

        public DocumentMetaData getDocumentMetaData() {
            if (ParameterDialog.this.reportDesignerContext == null) {
                return this.defaultDocumentMetaData;
            }
            ReportDocumentContext activeContext = ParameterDialog.this.reportDesignerContext.getActiveContext();
            if (activeContext == null) {
                return this.defaultDocumentMetaData;
            }
            return ((MasterReport)activeContext.getContextRoot()).getBundle().getMetaData();
        }

        public ReportEnvironment getReportEnvironment() {
            if (ParameterDialog.this.reportDesignerContext == null) {
                return this.defaultEnvironment;
            }
            ReportDocumentContext activeContext = ParameterDialog.this.reportDesignerContext.getActiveContext();
            if (activeContext == null) {
                return this.defaultEnvironment;
            }
            return ((MasterReport)activeContext.getContextRoot()).getReportEnvironment();
        }

        public void close() throws ReportDataFactoryException {
        }
    }

    private class QuerySelectionHandler
    implements ListDataListener,
    TreeSelectionListener {
        private QuerySelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getPath() == null) {
                return;
            }
            Object o = e.getPath().getLastPathComponent();
            if (o instanceof String) {
                ParameterDialog.this.queryComboBoxModel.setSelectedItem(o);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            String[] cols = ParameterDialog.this.getDataFields();
            ParameterDialog.this.idComboBox.setModel(new DefaultComboBoxModel<String>(cols));
            ParameterDialog.this.displayValueComboBox.setModel(new DefaultComboBoxModel<String>(cols));
            String selectedQuery = (String)ParameterDialog.this.queryComboBoxModel.getSelectedItem();
            boolean querySelected = !StringUtils.isEmpty((String)selectedQuery, (boolean)false);
            ParameterDialog.this.strictValuesCheckBox.setVisible(querySelected);
            ParameterDialog.this.reevaluateOnInvalidStrictParamCheckBox.setVisible(querySelected);
            ParameterDialog.this.autofillSelectionCheckBox.setVisible(querySelected);
        }
    }

    private class DataSetQueryUpdateHandler
    implements TreeModelListener {
        private DataSetQueryUpdateHandler() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.valueChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.valueChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.valueChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.valueChanged();
        }

        private void valueChanged() {
            int count = ParameterDialog.this.availableDataSourcesModel.size();
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (int i = 0; i < count; ++i) {
                DataFactoryWrapper factoryWrapper = ParameterDialog.this.availableDataSourcesModel.get(i);
                if (factoryWrapper.isRemoved()) continue;
                String[] strings = factoryWrapper.getEditedDataFactory().getQueryNames();
                set.addAll(Arrays.asList(strings));
            }
            ParameterDialog.this.queryComboBoxModel.setValues(set.toArray(new String[set.size()]));
            TreePath selectionPath = ParameterDialog.this.availableDataSources.getSelectionPath();
            if (selectionPath == null) {
                ParameterDialog.this.setSelectedQuery(null);
                ParameterDialog.this.idComboBox.setModel(new DefaultComboBoxModel());
                ParameterDialog.this.displayValueComboBox.setModel(new DefaultComboBoxModel());
                return;
            }
            Object maybeQuery = selectionPath.getLastPathComponent();
            if (maybeQuery instanceof String) {
                ParameterDialog.this.setSelectedQuery((String)maybeQuery);
            }
        }
    }

    private class TypeListener
    implements ListDataListener {
        private TypeListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ParameterType type = (ParameterType)ParameterDialog.this.parameterTypeModel.getSelectedItem();
            boolean visible = type != null && type.isHasVisibleItems();
            ParameterDialog.this.visibleItemsTextField.setVisible(visible);
            ParameterDialog.this.visibleItemsLabel.setVisible(visible);
            boolean displayFormulaVisible = type != null && !type.isQueryOptional();
            ParameterDialog.this.displayFormulaField.setVisible(displayFormulaVisible);
            ParameterDialog.this.displayFormulaLabel.setVisible(displayFormulaVisible);
            ParameterDialog.this.displayValueLabel.setVisible(displayFormulaVisible);
            ParameterDialog.this.displayValueComboBox.setVisible(displayFormulaVisible);
            String selectedQuery = (String)ParameterDialog.this.queryComboBoxModel.getSelectedItem();
            boolean querySelected = !StringUtils.isEmpty((String)selectedQuery, (boolean)false);
            ParameterDialog.this.strictValuesCheckBox.setVisible(querySelected);
            ParameterDialog.this.reevaluateOnInvalidStrictParamCheckBox.setVisible(querySelected);
            ParameterDialog.this.autofillSelectionCheckBox.setVisible(querySelected);
        }
    }

    public static class ParameterEditResult {
        private DataFactoryWrapper[] wrappers;
        private ParameterDefinitionEntry parameter;

        public ParameterEditResult(DataFactoryWrapper[] wrappers, ParameterDefinitionEntry entries) {
            this.wrappers = wrappers;
            this.parameter = entries;
        }

        public DataFactoryWrapper[] getWrappers() {
            return this.wrappers;
        }

        public ParameterDefinitionEntry getParameter() {
            return this.parameter;
        }
    }
}

