/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.metadata;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DocumentMetaDataDialog
extends CommonDialog {
    private JLabel fileNameLabel;
    private JLabel locationLabel;
    private JLabel creationDateLabel;
    private JLabel modifiedDateLabel;
    private JLabel sizeLabel;
    private JTextField authorField;
    private JTextField titleField;
    private JTextField subjectField;
    private JTextField keywordsField;
    private JTextArea descriptionField;

    public DocumentMetaDataDialog() throws HeadlessException {
        this.init();
    }

    public DocumentMetaDataDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public DocumentMetaDataDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.fileNameLabel = new JLabel();
        this.locationLabel = new JLabel();
        this.creationDateLabel = new JLabel();
        this.modifiedDateLabel = new JLabel();
        this.sizeLabel = new JLabel();
        this.authorField = new JTextField();
        this.titleField = new JTextField();
        this.subjectField = new JTextField();
        this.keywordsField = new JTextField();
        this.descriptionField = new JTextArea();
        this.setMinimumSize(new Dimension(600, 400));
        this.setTitle(Messages.getString("DocumentMetaDataDialog.DialogTitle", new Object[0]));
        super.init();
    }

    protected void performInitialResize() {
        this.setSize(800, 600);
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.DocumentMetaDataDialog";
    }

    protected Component createContentPane() {
        JPanel generalPanel = new JPanel();
        generalPanel.setMinimumSize(new Dimension(500, 300));
        generalPanel.setLayout(new GridBagLayout());
        generalPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)new JLabel(IconLoader.getInstance().getAboutIcon()), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)this.fileNameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.ipadx = 250;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)new JSeparator(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.CreationDate", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)this.creationDateLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.ModificationDate", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)this.modifiedDateLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.Location", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)this.locationLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        generalPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.Size", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 2, 5);
        gbc.fill = 2;
        generalPanel.add((Component)this.sizeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        generalPanel.add((Component)new JPanel(), gbc);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.Author", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)this.authorField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.Title", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)this.titleField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.Subject", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)this.subjectField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.Keywords", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)this.keywordsField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)new JLabel(Messages.getString("DocumentMetaDataDialog.Description", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 2, 5);
        descriptionPanel.add((Component)new JScrollPane(this.descriptionField), gbc);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(Messages.getString("DocumentMetaDataDialog.General", new Object[0]), generalPanel);
        tabbedPane.add(Messages.getString("DocumentMetaDataDialog.Description", new Object[0]), descriptionPanel);
        return tabbedPane;
    }

    public DocumentMetaData performEdit(DocumentMetaData metaData, ResourceManager resourceManager, ResourceKey bundleKey) {
        Date creationDate = (Date)metaData.getBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date");
        String keyWords = (String)metaData.getBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords");
        String creator = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "creator");
        Date date = (Date)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "date");
        String description = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "description");
        String subject = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "subject");
        String title = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "title");
        if (creationDate != null) {
            this.creationDateLabel.setText(DateFormat.getDateTimeInstance().format(creationDate));
        } else {
            this.creationDateLabel.setText(null);
        }
        this.keywordsField.setText(keyWords);
        this.authorField.setText(creator);
        if (date != null) {
            this.modifiedDateLabel.setText(DateFormat.getDateTimeInstance().format(date));
        } else {
            this.modifiedDateLabel.setText(null);
        }
        this.descriptionField.setText(description);
        this.subjectField.setText(subject);
        this.titleField.setText(title);
        if (bundleKey == null) {
            this.locationLabel.setText(null);
            this.fileNameLabel.setText(null);
            this.sizeLabel.setText(null);
        } else {
            URL url;
            if (bundleKey.getParent() != null) {
                bundleKey = bundleKey.getParent();
            }
            if ((url = resourceManager.toURL(bundleKey)) != null) {
                String fileName;
                String file = url.getFile();
                int idx = file.indexOf(fileName = IOUtils.getInstance().getFileName(file));
                String location = idx == -1 ? null : file.substring(0, idx);
                this.fileNameLabel.setText(fileName);
                this.locationLabel.setText(location);
            }
            this.sizeLabel.setText(null);
            try {
                ResourceData resourceData = resourceManager.loadRawData(bundleKey);
                Object size = resourceData.getAttribute("content-length");
                if (size != null) {
                    this.sizeLabel.setText(String.valueOf(size));
                }
            }
            catch (ResourceLoadingException resourceLoadingException) {
                // empty catch block
            }
        }
        if (!super.performEdit()) {
            return null;
        }
        MemoryDocumentMetaData o = new MemoryDocumentMetaData();
        if (!StringUtils.isEmpty((String)this.keywordsField.getText())) {
            o.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords", (Object)this.keywordsField.getText());
        } else {
            o.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords", null);
        }
        if (!StringUtils.isEmpty((String)this.authorField.getText())) {
            o.setBundleAttribute("http://purl.org/dc/elements/1.1/", "creator", (Object)this.authorField.getText());
        } else {
            o.setBundleAttribute("http://purl.org/dc/elements/1.1/", "creator", null);
        }
        if (!StringUtils.isEmpty((String)this.descriptionField.getText())) {
            o.setBundleAttribute("http://purl.org/dc/elements/1.1/", "description", (Object)this.descriptionField.getText());
        } else {
            o.setBundleAttribute("http://purl.org/dc/elements/1.1/", "description", null);
        }
        if (!StringUtils.isEmpty((String)this.subjectField.getText())) {
            o.setBundleAttribute("http://purl.org/dc/elements/1.1/", "subject", (Object)this.subjectField.getText());
        } else {
            o.setBundleAttribute("http://purl.org/dc/elements/1.1/", "subject", null);
        }
        if (!StringUtils.isEmpty((String)this.titleField.getText())) {
            o.setBundleAttribute("http://purl.org/dc/elements/1.1/", "title", (Object)this.titleField.getText());
        } else {
            o.setBundleAttribute("http://purl.org/dc/elements/1.1/", "title", null);
        }
        return o;
    }

    public static class EditResult {
        private String oldAuthor;
        private String newAuthor;
        private String oldTitle;
        private String newTitle;
        private String oldSubject;
        private String newSubject;
        private String oldKeywords;
        private String newKeywords;
        private String oldDescription;
        private String newDescription;

        public EditResult(String oldAuthor, String newAuthor, String oldTitle, String newTitle, String oldSubject, String newSubject, String oldKeywords, String newKeywords, String oldDescription, String newDescription) {
            this.oldAuthor = oldAuthor;
            this.newAuthor = newAuthor;
            this.oldTitle = oldTitle;
            this.newTitle = newTitle;
            this.oldSubject = oldSubject;
            this.newSubject = newSubject;
            this.oldKeywords = oldKeywords;
            this.newKeywords = newKeywords;
            this.oldDescription = oldDescription;
            this.newDescription = newDescription;
        }

        public String getOldAuthor() {
            return this.oldAuthor;
        }

        public String getNewAuthor() {
            return this.newAuthor;
        }

        public String getOldTitle() {
            return this.oldTitle;
        }

        public String getNewTitle() {
            return this.newTitle;
        }

        public String getOldSubject() {
            return this.oldSubject;
        }

        public String getNewSubject() {
            return this.newSubject;
        }

        public String getOldKeywords() {
            return this.oldKeywords;
        }

        public String getNewKeywords() {
            return this.newKeywords;
        }

        public String getOldDescription() {
            return this.oldDescription;
        }

        public String getNewDescription() {
            return this.newDescription;
        }
    }
}

