/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTabbedPane;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.format.AdvancedFontPropertiesPane;
import org.pentaho.reporting.designer.core.editor.format.BorderPropertiesPane;
import org.pentaho.reporting.designer.core.editor.format.ColorPropertiesPane;
import org.pentaho.reporting.designer.core.editor.format.EditableStyleSheet;
import org.pentaho.reporting.designer.core.editor.format.FontPropertiesPane;
import org.pentaho.reporting.designer.core.editor.format.ParagraphPropertiesPane;
import org.pentaho.reporting.designer.core.util.undo.ElementFormatUndoEntry;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class ElementFormatDialog
extends CommonDialog {
    public static final int FONT_PANE = 0;
    public static final int ADVANCED_FONT_PANE = 1;
    public static final int PARAGRAPH_PANE = 2;
    public static final int BORDERS_PANE = 3;
    public static final int COLOR_PANE = 4;
    private FontPropertiesPane fontPropertiesPane;
    private AdvancedFontPropertiesPane advancedFontPropertiesPane;
    private ParagraphPropertiesPane paragraphPropertiesPane;
    private ColorPropertiesPane colorPropertiesPane;
    private BorderPropertiesPane borderPropertiesPane;
    private JTabbedPane tabbedPane;

    public ElementFormatDialog() throws HeadlessException {
        this.init();
    }

    public ElementFormatDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public ElementFormatDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getString("ElementFormatDialog.FormatElement", new Object[0]));
        this.fontPropertiesPane = new FontPropertiesPane();
        this.advancedFontPropertiesPane = new AdvancedFontPropertiesPane();
        this.paragraphPropertiesPane = new ParagraphPropertiesPane();
        this.colorPropertiesPane = new ColorPropertiesPane();
        this.borderPropertiesPane = new BorderPropertiesPane();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(Messages.getString("ElementFormatDialog.Font", new Object[0]), (Component)((Object)this.fontPropertiesPane));
        this.tabbedPane.add(Messages.getString("ElementFormatDialog.AdvancedFontSettings", new Object[0]), this.advancedFontPropertiesPane);
        this.tabbedPane.add(Messages.getString("ElementFormatDialog.Paragraph", new Object[0]), this.paragraphPropertiesPane);
        this.tabbedPane.add(Messages.getString("ElementFormatDialog.SizeAndBorders", new Object[0]), this.borderPropertiesPane);
        this.tabbedPane.add(Messages.getString("ElementFormatDialog.ColorAndBackground", new Object[0]), this.colorPropertiesPane);
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.ElementFormat";
    }

    protected Component createContentPane() {
        return this.tabbedPane;
    }

    public void setActivePane(int pane) {
        this.tabbedPane.setSelectedIndex(pane);
    }

    public ElementFormatUndoEntry.EditResult performEdit(ReportDesignerContext designerContext, ElementStyleSheet element, Map<StyleKey, Expression> styleExpressions) {
        EditableStyleSheet styleSheet = new EditableStyleSheet();
        styleSheet.copyParentValues(element);
        HashMap<StyleKey, Expression> editableStyleExpressions = styleExpressions == null ? null : new HashMap<StyleKey, Expression>(styleExpressions);
        this.fontPropertiesPane.initializeFromStyle(styleSheet);
        this.advancedFontPropertiesPane.initializeFromStyle(styleSheet);
        this.paragraphPropertiesPane.initializeFromStyle(styleSheet);
        this.borderPropertiesPane.initializeFromStyle(styleSheet);
        this.colorPropertiesPane.initializeFromStyle(styleSheet);
        this.fontPropertiesPane.commitValues(styleSheet);
        this.advancedFontPropertiesPane.commitValues(styleSheet);
        this.paragraphPropertiesPane.commitValues(styleSheet);
        this.borderPropertiesPane.commitValues(styleSheet);
        this.colorPropertiesPane.commitValues(styleSheet);
        styleSheet.clearEdits();
        if (!this.performEdit()) {
            return null;
        }
        this.fontPropertiesPane.commitValues(styleSheet);
        this.advancedFontPropertiesPane.commitValues(styleSheet);
        this.paragraphPropertiesPane.commitValues(styleSheet);
        this.borderPropertiesPane.commitValues(styleSheet);
        this.colorPropertiesPane.commitValues(styleSheet);
        return new ElementFormatUndoEntry.EditResult(styleSheet, editableStyleExpressions);
    }
}

