/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.util.HashSet;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.editor.format.BorderSelection;
import org.pentaho.reporting.designer.core.editor.format.BorderSelectionEvent;
import org.pentaho.reporting.designer.core.editor.format.BorderSelectionListener;

public class BorderSelectionModel {
    private EventListenerList eventListeners = new EventListenerList();
    private HashSet<BorderSelection> selectedItems = new HashSet();

    public void addBorderSelectionListener(BorderSelectionListener listener) {
        this.eventListeners.add(BorderSelectionListener.class, listener);
    }

    public void removeBorderSelectionListener(BorderSelectionListener listener) {
        this.eventListeners.remove(BorderSelectionListener.class, listener);
    }

    public BorderSelection[] getSelections() {
        return this.selectedItems.toArray(new BorderSelection[this.selectedItems.size()]);
    }

    public boolean isSelected(BorderSelection selection) {
        return this.selectedItems.contains((Object)selection);
    }

    public void addSelection(BorderSelection selection) {
        if (this.selectedItems.add(selection)) {
            this.fireSelectionAdded(selection);
        }
    }

    public void removeSelection(BorderSelection selection) {
        if (this.selectedItems.remove((Object)selection)) {
            this.fireSelectionRemoved(selection);
        }
    }

    public void clearSelection() {
        Iterator<BorderSelection> iterator = this.selectedItems.iterator();
        while (iterator.hasNext()) {
            BorderSelection selection = iterator.next();
            iterator.remove();
            this.fireSelectionRemoved(selection);
        }
    }

    private void fireSelectionRemoved(BorderSelection selection) {
        BorderSelectionEvent event = new BorderSelectionEvent(this, selection);
        BorderSelectionListener[] listeners = (BorderSelectionListener[])this.eventListeners.getListeners(BorderSelectionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            BorderSelectionListener listener = listeners[i];
            listener.selectionRemoved(event);
        }
    }

    private void fireSelectionAdded(BorderSelection selection) {
        BorderSelectionEvent event = new BorderSelectionEvent(this, selection);
        BorderSelectionListener[] listeners = (BorderSelectionListener[])this.eventListeners.getListeners(BorderSelectionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            BorderSelectionListener listener = listeners[i];
            listener.selectionAdded(event);
        }
    }
}

